package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.GdQlrMapper;
import cn.gtmap.estateplat.config.core.service.GdQlrService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.GdQlr;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
*@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
*@Date 14:46 2017/12/21
*/
@Service
public class GdQlrServiceImpl implements GdQlrService {
    @Autowired
    private GdQlrMapper gdQlrMapper;
    @Autowired
    private EntityMapper entityMapper;

    @Override
    public List<GdQlr> getGdQlrListByqlidAndQlrlx(String gdQlid, String qlrlx) {
        List<GdQlr> gdQlrList = null;
        if (StringUtils.isNotBlank(gdQlid) || StringUtils.isNotBlank(qlrlx)) {
            HashMap hashMap = new HashMap();
            hashMap.put("qlid", gdQlid);
            hashMap.put("qlrlx", qlrlx);
            gdQlrList = gdQlrMapper.getGdQlrList(hashMap);
        }
        return gdQlrList;
    }

    @Override
    public String combinationQlr(List<GdQlr> gdQlrList) {
        StringBuilder qlrBuilder = new StringBuilder();
        List<String> qlridList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(gdQlrList)) {
            for (GdQlr gdQlr : gdQlrList) {
                if (StringUtils.isBlank(qlrBuilder.toString())) {
                    qlrBuilder.append(gdQlr.getQlr());
                    qlridList.add(gdQlr.getQlrid());
                } else if (!qlridList.contains(gdQlr.getQlrid())) {
                    qlrBuilder.append("、").append(gdQlr.getQlr());
                    qlridList.add(gdQlr.getQlrid());
                }
            }
        }
        return qlrBuilder.toString();
    }

    @Override
    public HashMap<String,String> combinationQlrAndYwrByProid(String proid){
        HashMap<String,String> qlrAndYwrMap = null;
        if(StringUtils.isNotBlank(proid)) {
            qlrAndYwrMap = new HashMap<String, String>();
            Example gdQlrExample = new Example(GdQlr.class);
            gdQlrExample.createCriteria().andEqualTo("proid",proid);
            List<GdQlr> gdQlrList = entityMapper.selectByExample(gdQlrExample);
            String qlr = "";
            String qlrzjzl = "";
            String qlrzjh = "";
            String ywr = "";
            String ywrzjzl = "";
            String ywrzjh = "";
            if(CollectionUtils.isNotEmpty(gdQlrList)) {
                GdQlr gdQlrOne = gdQlrList.get(0);
                if(null!=gdQlrOne && StringUtils.isNotBlank(gdQlrOne.getQlrsfzjzl())){
                    qlrzjzl = gdQlrOne.getQlrsfzjzl();
                    ywrzjzl = gdQlrOne.getQlrsfzjzl();
                }
                for (GdQlr gdQlr:gdQlrList) {
                    if(StringUtils.equals(gdQlr.getQlrlx(), Constants.QLRLX_QLR)) {
                        if(StringUtils.isNotBlank(gdQlr.getQlr())) {
                            if(StringUtils.isBlank(qlr)) {
                                qlr = gdQlr.getQlr();
                            }else{
                                qlr += "," + gdQlr.getQlr();
                            }
                        }

//                        if(StringUtils.isNotBlank(gdQlr.getQlrsfzjzl())) {
//                            if(StringUtils.isBlank(qlrzjzl)) {
//                                qlrzjzl = gdQlr.getQlrsfzjzl();
//                            }else{
//                                qlrzjzl += "," + gdQlr.getQlrsfzjzl();
//                            }
//                        }

                        if(StringUtils.isNotBlank(gdQlr.getQlrzjh())) {
                            if(StringUtils.isBlank(qlrzjh)) {
                                qlrzjh = gdQlr.getQlrzjh();

                            }else{
                                qlrzjh += "," + gdQlr.getQlrzjh();
                            }
                        }

                    } else if(StringUtils.equals(gdQlr.getQlrlx(), Constants.QLRLX_YWR)) {
                        if(StringUtils.isNotBlank(gdQlr.getQlr())) {
                            if(StringUtils.isBlank(ywr)) {
                                ywr = gdQlr.getQlr();
                            }else{
                                ywr += "," + gdQlr.getQlr();
                            }
                        }

//                        if(StringUtils.isNotBlank(gdQlr.getQlrsfzjzl())) {
//                            if(StringUtils.isBlank(ywrzjzl)) {
//                                ywrzjzl = gdQlr.getQlrsfzjzl();
//                            }else{
//                                ywrzjzl += "," + gdQlr.getQlrsfzjzl();
//                            }
//                        }

                        if(StringUtils.isNotBlank(gdQlr.getQlrzjh())) {
                            if(StringUtils.isBlank(ywrzjh)) {
                                ywrzjh = gdQlr.getQlrzjh();
                            }else{
                                ywrzjh += "," + gdQlr.getQlrzjh();
                            }
                        }
                    }
                }
            }
            qlrAndYwrMap.put("qlr",qlr);
            qlrAndYwrMap.put("qlrzjzl",qlrzjzl);
            qlrAndYwrMap.put("qlrzjh",qlrzjh);
            qlrAndYwrMap.put("ywr",ywr);
            qlrAndYwrMap.put("ywrzjzl",ywrzjzl);
            qlrAndYwrMap.put("ywrzjh",ywrzjh);
        }
        return  qlrAndYwrMap;
    }

    @Override
    public List<GdQlr> getGdQlrListByCqzh(String cqzh) {
        List<GdQlr> gdQlrList = null;
        if(StringUtils.isNotBlank(cqzh)) {
            Example gdQlrExample = new Example(GdQlr.class);
            gdQlrExample.createCriteria().andEqualTo("cqzh",cqzh);
            gdQlrList = entityMapper.selectByExample(gdQlrExample);
        }
        return gdQlrList;
    }
}
