package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.GdTdMapper;
import cn.gtmap.estateplat.config.core.service.GdTdService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.GdQlDyhRel;
import cn.gtmap.estateplat.model.server.core.GdTd;
import cn.gtmap.estateplat.model.server.core.GdTdQl;
import cn.gtmap.estateplat.model.server.core.GdTdsyq;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class GdTdServiceImpl implements GdTdService {

    @Autowired
    EntityMapper entityMapper;
    @Autowired
    GdTdMapper gdTdMapper;

    @Override
    public String getTdQlidByFwQlid(String qlid) {
        String tdqlid = "";
        if (StringUtils.isNotBlank(qlid)) {
            Example example = new Example(GdQlDyhRel.class);
            example.createCriteria().andEqualTo("qlid", qlid);
            List<GdQlDyhRel> gdQlDyhRelList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(gdQlDyhRelList))
                tdqlid = gdQlDyhRelList.get(0).getTdqlid();
        }
        return tdqlid;
    }

    @Override
    public List<String> getGdTdQlidByDjh(final String djh) {
        return gdTdMapper.getGdTdQlidByDjh(djh);
    }

    @Override
    public List<GdTdsyq> queryTdsyqByTdid(String tdid) {
        List<GdTdsyq> gdTdsyqList = null;
        if (StringUtils.isNotBlank(tdid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("tdid", tdid);
            gdTdsyqList = gdTdMapper.getGdTdSyqsByGdTd(hashMap);
        }
        return gdTdsyqList;
    }

    @Override
    public List<GdTd> getGdTdByProid(String proid) {
        List<GdTd> gdTdList = null;
        if (StringUtils.isNotBlank(proid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("proid", proid);
            gdTdList = gdTdMapper.getGdTdListByGdTdQlAndGdXm(hashMap);
        }
        return gdTdList;
    }

    @Override
    public GdTd getGdTdByDjh(String djh) {
        GdTd gdTd = null;
        if (StringUtils.isNotBlank(djh)) {
            Example gdTdExample = new Example(GdTd.class);
            gdTdExample.createCriteria().andEqualTo("djh", djh);
            List<GdTd> gdTdList = entityMapper.selectByExample(GdTd.class, gdTdExample);
            if (gdTdList != null && gdTdList.size() > 0) {
                gdTd = gdTdList.get(0);
            }
        }
        return gdTd;
    }

    @Override
    public GdTd getGdTdByTdid(String tdid) {
        GdTd gdTd = null;
        if (StringUtils.isNotBlank(tdid)) {
            Example gdTdExample = new Example(GdTd.class);
            gdTdExample.createCriteria().andEqualTo("tdid", tdid);
            List<GdTd> gdTdList = entityMapper.selectByExample(GdTd.class, gdTdExample);
            if (gdTdList != null && gdTdList.size() > 0) {
                gdTd = gdTdList.get(0);
            }
        }
        return gdTd;
    }

    @Override
    public void updateGdTdsyqRedundantField(GdTdsyq gdTdsyq) {
        if(gdTdsyq != null&&StringUtils.isNotBlank(gdTdsyq.getQlid())) {
            gdTdMapper.updateGdTdsyqRedundantField(gdTdsyq);
        }
    }

    @Override
    public void updateGdTdQlRedundantField(GdTdQl gdTdQl) {
        if(gdTdQl != null&&StringUtils.isNotBlank(gdTdQl.getQlid())) {
            gdTdMapper.updateGdTdQlRedundantField(gdTdQl);
        }

    }

    @Override
    public List<GdTdsyq> getGdTdsyqListByTdzh(String tdzh) {
        List<GdTdsyq> gdTdsyqList = null;
        if (StringUtils.isNotBlank(tdzh)) {
            Example example = new Example(GdTdsyq.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("tdzh", tdzh);
            gdTdsyqList = entityMapper.selectByExample(example);
        }
        return gdTdsyqList;
    }

    @Override
    public GdTdsyq queryGdTdsyqByQlid(String qlid) {
        GdTdsyq gdTdsyq = null;
        if(StringUtils.isNotBlank(qlid)) {
            gdTdsyq = entityMapper.selectByPrimaryKey(GdTdsyq.class,qlid);
        }
        return gdTdsyq;
    }
}
