package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.GdXmMapper;
import cn.gtmap.estateplat.config.core.service.GdXmService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.GdBdcQlRel;
import cn.gtmap.estateplat.model.server.core.GdXm;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class GdXmServiceImpl implements GdXmService {
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    GdXmMapper gdXmMapper;

    @Override
    public List<String> getGdBdcidByProid(final String gdproid) {
        List<String> stringList = null;
        String qlid = getQlidByGdproid(gdproid);
        if(StringUtils.isNotBlank(qlid)) {
            Example example = new Example(GdBdcQlRel.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("qlid", qlid);
            List<GdBdcQlRel> gdBdcQlRelList = entityMapper.selectByExample(GdBdcQlRel.class, example);
            if (CollectionUtils.isNotEmpty(gdBdcQlRelList)) {
                stringList = new ArrayList<String>();
                for (GdBdcQlRel gdBdcQlRel : gdBdcQlRelList) {
                    stringList.add(gdBdcQlRel.getBdcid());
                }
            }
        }
        return stringList;
    }


    public String getQlidByGdproid(String gdproid) {
        String qlid = "";
        if(StringUtils.isNotBlank(gdproid)) {
            List<String> list = gdXmMapper.getQlidByGdproid(gdproid);
            if (CollectionUtils.isNotEmpty(list)) {
                qlid = list.get(0);
            }
        }
        return qlid;
    }

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @Description:根据qlid获取所有过渡证号
     * @Date 9:42 2017/12/26
     */
    @Override
    public List<String> listPlCqzhByQlid(final String qlid) {
        List<String> plCqzhList = null;
        if(StringUtils.isNotBlank(qlid)) {
            plCqzhList = gdXmMapper.listPlCqzhByQlid(qlid);
        }
        return plCqzhList;
    }

    /**
     *@Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     *@Description:根据fwid获取所有该房屋上的权利证号
     *@Date 9:42 2017/12/26
     */
    @Override
    public List<String> listCqzhByFwid(final String fwid){
        List<String> cqzhList = null;
        if(StringUtils.isNotBlank(fwid)) {
            cqzhList = gdXmMapper.listCqzhByFwid(fwid);
        }
        return cqzhList;
    }

    /**
     *@Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     *@Description:根据tdid获取所有该土地上的证号
     *@Date 9:42 2017/12/26
     */
    public List<String> listCqzhByTdid(final String tdid){
        List<String> cqzhList = null;
        if(StringUtils.isNotBlank(tdid)) {
            cqzhList = gdXmMapper.listCqzhByTdid(tdid);
        }
        return cqzhList;
    }

    @Override
    public List<String> getGdproidByCqzh(String cqzh) {
        List<String> gdproidList = null;
        if(StringUtils.isNotBlank(cqzh)) {
            gdproidList = gdXmMapper.getGdproidByCqzh(cqzh);
        }
        return gdproidList;
    }

    @Override
    public String getGdQsztByGdProid(String gdproid) {
        String gdQszt = "";
        if(StringUtils.isNotBlank(gdproid)) {
            gdQszt = gdXmMapper.getGdQsztByGdproid(gdproid);
        }
        return gdQszt;
    }

    @Override
    public String getCqzhByGdproid(String proid) {
        String cqzh = "";
        if(StringUtils.isNotBlank(proid)) {
            cqzh = gdXmMapper.getCqzhByGdproid(proid);
        }
        return cqzh;
    }

    @Override
    public Map getGxObjectByGdproid(String proid) {
        Map gxObject = null;
        if(StringUtils.isNotBlank(proid)) {
            gxObject = gdXmMapper.getGxObjectByGdproid(proid);
        }
        return gxObject;
    }

    @Override
    public List<GdXm> getGdXmListByGdProid(String gdproid) {
        List<GdXm> gdXmList = null;
        if(StringUtils.isNotBlank(gdproid)) {
            gdXmList = gdXmMapper.getGdXmListByGdProid(gdproid);
        }
        return gdXmList;
    }
}
