package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.service.BdcLogService;
import cn.gtmap.estateplat.config.core.service.LogService;
import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.utils.AnnotationsUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/11/15
 * @description
 */
@Service
public class LogServiceImpl implements LogService {

    @Autowired
    private BdcLogService bdcLogService;

    @Autowired
    private EntityMapper entityMapper;

    @Override
    public void saveOrUpdateLog(Object... objects) {
        for (Object object : objects) {
            if (object != null) {
                Method method1 = AnnotationsUtils.getAnnotationsName(object);
                try {
                    if (method1.invoke(object) != null) {
                        String id = method1.invoke(object).toString();
                     /*   if (entityMapper.selectByPrimaryKey(object.getClass(), id) != null) {
                            bdcLogService.updateLog(object);
                        } else {
                            bdcLogService.saveLog(object);
                        }*/
                     entityMapper.saveOrUpdate(object,id);
                    }
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new AppException(e.getMessage());
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                    throw new AppException(e.getMessage());
                }
            }
        }
    }

    @Override
    public void deleteLog(Object... objects) {
        for (Object object : objects) {
            if (object != null && entityMapper.select(object) != null) {
                bdcLogService.deleteLog(object);
            }
        }
    }

    @Override
    public void saveExcelLog(Object... objects) {
        for (Object object : objects) {
            if (object != null && entityMapper.select(object) != null) {
                bdcLogService.saveLog(object);
            }
        }
    }
}
