package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.service.PfUserVoService;
import cn.gtmap.estateplat.config.utils.PlatformUtil;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @version 1.0, 2017/6/26.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class PfUserVoServiceImpl implements PfUserVoService {

    @Autowired
    SysUserService sysUserService;

    @Override
    public List<PfUserVo> getPfUserVoToZsbh() {
        List<PfUserVo> pfUserVoList = null;
        String getZsbhByRy = AppConfig.getProperty("getZsbhByRy");
        if (StringUtils.isNotBlank(getZsbhByRy) && getZsbhByRy.equals("true")) {
            String zsbhUseRoleName = AppConfig.getProperty("zsbhUseRoleName");
            if (StringUtils.isNotBlank(zsbhUseRoleName)) {
                List<PfRoleVo> pfRoleVoList = sysUserService.getRoleList();
                if (CollectionUtils.isNotEmpty(pfRoleVoList)) {
                    for (PfRoleVo pfRoleVo : pfRoleVoList) {
                        if (StringUtils.equals(pfRoleVo.getRoleName(), zsbhUseRoleName)) {
                            pfUserVoList = sysUserService.getUserListByRole(pfRoleVo.getRoleId());
                            break;
                        }
                    }
                }
            } else {
                pfUserVoList = sysUserService.getAllUsers();
            }
        }
        return pfUserVoList;
    }

    @Override
    public List<String> getUserNameByIOrganId(String organId) {
        List<String> usernameList = new ArrayList<String>();
        List<PfUserVo> userList = PlatformUtil.getUsersByOrganId(organId);
        if (CollectionUtils.isNotEmpty(userList)) {
            for (PfUserVo pfUserVo : userList) {
                if (StringUtils.isNotBlank(pfUserVo.getUserName()))
                    usernameList.add(pfUserVo.getUserName());
            }
        }
        return usernameList;
    }

    @Override
    public String getUserNameByUserId(String userid) {
        String username = null;
        if (StringUtils.isNotBlank(userid)) {
            PfUserVo pfUserVo = sysUserService.getUserVo(userid);
            if (pfUserVo != null)
                username = pfUserVo.getUserName();
        }
        return username;
    }
}
