package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcFdcqDzMapper;
import cn.gtmap.estateplat.config.core.mapper.config.BdcQllxMapper;
import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.model.InitVoFromParm;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.config.utils.ReadXmlProps;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CalendarUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.lang.annotation.Annotation;
import java.util.*;

/**
 * @author <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @version 1.0, 2017/6/29.
 * @description
 */
@Service
public class QllxServiceImpl implements QllxService {

    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private BdcQllxMapper bdcQllxMapper;
    @Autowired
    private BdcFdcqDzService bdcFdcqDzService;
    @Autowired
    private BdcFdcqDzMapper bdcFdcqDzMapper;
    @Autowired
    private DjsjService djsjService;
    @Autowired
    private BdcdyService bdcdyService;
    @Autowired
    private DataManagerService dataManagerService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcDjbService bdcDjbService;

    @Override
    @Transactional(readOnly = true)
    public QllxVo makeSureQllx(final BdcXm bdcXm) {
        String qllx;
        if (bdcXm != null) {
            qllx = bdcXm.getQllx();
        } else {
            return null;
        }
        QllxVo vo = null;
        if (StringUtils.isNotBlank(qllx)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            BdcCf bdcCf = new BdcCf();
            map.put(getTableName(bdcCf).toUpperCase(), bdcCf);

            BdcDyaq bdcDyaq = new BdcDyaq();
            map.put(getTableName(bdcDyaq).toUpperCase(), bdcDyaq);

            BdcDyq bdcDyq = new BdcDyq();
            map.put(getTableName(bdcDyq).toUpperCase(), bdcDyq);

            BdcFdcq bdcFdcq = new BdcFdcq();
            map.put(getTableName(bdcFdcq).toUpperCase(), bdcFdcq);

            BdcFdcqDz bdcFdcqDz = new BdcFdcqDz();
            map.put(getTableName(bdcFdcqDz).toUpperCase(), bdcFdcqDz);

            BdcHysyq bdcHysyq = new BdcHysyq();
            map.put(getTableName(bdcHysyq).toUpperCase(), bdcHysyq);

            BdcJsydzjdsyq bdcJsydzjdsyq = new BdcJsydzjdsyq();
            map.put(getTableName(bdcJsydzjdsyq).toUpperCase(), bdcJsydzjdsyq);

            BdcJzwgy bdcJzwgy = new BdcJzwgy();
            map.put(getTableName(bdcJzwgy).toUpperCase(), bdcJzwgy);

            BdcJzwsyq bdcJzwsyq = new BdcJzwsyq();
            map.put(getTableName(bdcJzwsyq).toUpperCase(), bdcJzwsyq);

            BdcLq bdcLq = new BdcLq();
            map.put(getTableName(bdcLq).toUpperCase(), bdcLq);

            BdcQsq bdcQsq = new BdcQsq();
            map.put(getTableName(bdcQsq).toUpperCase(), bdcQsq);

            BdcTdcbnydsyq bdcTdcbnydsyq = new BdcTdcbnydsyq();
            map.put(getTableName(bdcTdcbnydsyq).toUpperCase(), bdcTdcbnydsyq);

            BdcTdsyq bdcTdsyq = new BdcTdsyq();
            map.put(getTableName(bdcTdsyq).toUpperCase(), bdcTdsyq);

            BdcYg bdcYg = new BdcYg();
            map.put(getTableName(bdcYg).toUpperCase(), bdcYg);

            BdcYy bdcYy = new BdcYy();
            map.put(getTableName(bdcYy).toUpperCase(), bdcYy);

            BdcFdcqDz BdcFdcqDz = new BdcFdcqDz();
            map.put(getTableName(bdcFdcqDz).toUpperCase(), BdcFdcqDz);
            vo = makeSureQllx(bdcXm.getQllx());
            if (vo != null && vo instanceof BdcFdcq) {
                /**
                 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
                 * @Time 2020/6/23 15:36
                 * @description 针对江阴不动产单元是多幢  权利是fdcq 查不到权利的问题
                 */
                vo = queryQllxVo(vo, bdcXm.getProid());
                if (vo == null) {
                    String fwlx = djsjService.getFwlxByProid(bdcXm.getProid());
                    String bdcdyfwlx = "";
                    BdcBdcdy bdcBdcdy = null;
                    if (StringUtils.isNotBlank(bdcXm.getBdcdyid())) {
                        bdcBdcdy = entityMapper.selectByPrimaryKey(BdcBdcdy.class, bdcXm.getBdcdyid());
                    }
                    if (bdcBdcdy != null) {
                        bdcdyfwlx = bdcBdcdy.getBdcdyfwlx();
                    }

                    if ((StringUtils.isNotBlank(fwlx) && StringUtils.equals(Constants.DJSJ_FWDZ_DM, fwlx)) ||
                            StringUtils.equals(Constants.DJSJ_FWDZ_DM, bdcdyfwlx)) {
                        vo = (QllxVo) map.get("BDC_FDCQ_DZ".toUpperCase());
                    }
                }
            }
        }
        if (vo == null) {
            vo = new BdcFdcq();
        }
        return vo;
    }

    @Override
    public String getTableName(QllxVo vo) {
        String tableName = "";
        if (vo != null) {
            Annotation[] aos = vo.getClass().getAnnotations();
            for (Annotation ao : aos) {
                tableName = AnnotationUtils.getValue(ao, "name").toString();
            }
        }
        return tableName;
    }

    public QllxVo makeSureQllx(final String qllx) {
        QllxVo qllxVo = null;
        if (StringUtils.isNotBlank(qllx)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            BdcCf bdcCf = new BdcCf();
            map.put(getTableName(bdcCf).toUpperCase(), bdcCf);

            BdcDyaq bdcDyaq = new BdcDyaq();
            map.put(getTableName(bdcDyaq).toUpperCase(), bdcDyaq);

            BdcDyq bdcDyq = new BdcDyq();
            map.put(getTableName(bdcDyq).toUpperCase(), bdcDyq);

            BdcFdcq bdcFdcq = new BdcFdcq();
            map.put(getTableName(bdcFdcq).toUpperCase(), bdcFdcq);

            BdcFdcqDz bdcFdcqDz = new BdcFdcqDz();
            map.put(getTableName(bdcFdcqDz).toUpperCase(), bdcFdcqDz);

            BdcHysyq bdcHysyq = new BdcHysyq();
            map.put(getTableName(bdcHysyq).toUpperCase(), bdcHysyq);

            BdcJsydzjdsyq bdcJsydzjdsyq = new BdcJsydzjdsyq();
            map.put(getTableName(bdcJsydzjdsyq).toUpperCase(), bdcJsydzjdsyq);

            BdcJzwgy bdcJzwgy = new BdcJzwgy();
            map.put(getTableName(bdcJzwgy).toUpperCase(), bdcJzwgy);

            BdcJzwsyq bdcJzwsyq = new BdcJzwsyq();
            map.put(getTableName(bdcJzwsyq).toUpperCase(), bdcJzwsyq);

            BdcLq bdcLq = new BdcLq();
            map.put(getTableName(bdcLq).toUpperCase(), bdcLq);

            BdcQsq bdcQsq = new BdcQsq();
            map.put(getTableName(bdcQsq).toUpperCase(), bdcQsq);

            BdcTdcbnydsyq bdcTdcbnydsyq = new BdcTdcbnydsyq();
            map.put(getTableName(bdcTdcbnydsyq).toUpperCase(), bdcTdcbnydsyq);

            BdcTdsyq bdcTdsyq = new BdcTdsyq();
            map.put(getTableName(bdcTdsyq).toUpperCase(), bdcTdsyq);

            BdcYg bdcYg = new BdcYg();
            map.put(getTableName(bdcYg).toUpperCase(), bdcYg);

            BdcYy bdcYy = new BdcYy();
            map.put(getTableName(bdcYy).toUpperCase(), bdcYy);

            BdcZdQllx bdcZdQllx = bdcZdGlService.getBdcZdQllxByDm(qllx);
            if (bdcZdQllx != null && map.containsKey(bdcZdQllx.getTableName().toUpperCase())) {
                qllxVo = (QllxVo) map.get(bdcZdQllx.getTableName().toUpperCase());
            }
        }
        return qllxVo;
    }

    @Override
    public QllxVo getQllxVoByProid(String proid) {
        List<?> list = new ArrayList<Object>();
        //判断是否是查封
        Example example = new Example(BdcCf.class);
        example.createCriteria().andEqualTo("proid", proid);
        list = entityMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return new BdcCf();
        }
        //判断是否是抵押
        example = new Example(BdcDyaq.class);
        example.createCriteria().andEqualTo("proid", proid);
        list = entityMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return new BdcDyaq();
        }
        //判断是否是地役权
        example = new Example(BdcDyq.class);
        example.createCriteria().andEqualTo("proid", proid);
        list = entityMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return new BdcDyq();
        }
        //判断是否是房地产权
        example = new Example(BdcFdcq.class);
        example.createCriteria().andEqualTo("proid", proid);
        list = entityMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return new BdcFdcq();
        }
        //判断是否是房地产权 多撞
        BdcFdcqDz bdcFdcqDz = bdcFdcqDzService.getBdcFdcqDzByProid(proid);
        if (bdcFdcqDz != null) {
            return new BdcFdcqDz();
        }
        //判断是否是海域（含无居民海岛） 使用权
        example = new Example(BdcHysyq.class);
        example.createCriteria().andEqualTo("proid", proid);
        list = entityMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return new BdcHysyq();
        }
        //判断是否是建设用地使用权、宅基地使用权
        example = new Example(BdcJsydzjdsyq.class);
        example.createCriteria().andEqualTo("proid", proid);
        list = entityMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return new BdcJsydzjdsyq();
        }
        //判断是否是建筑物区分所有权
        example = new Example(BdcJzwgy.class);
        example.createCriteria().andEqualTo("proid", proid);
        list = entityMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return new BdcJzwgy();
        }
        //判断是否是构（建）筑物所有权
        example = new Example(BdcJzwsyq.class);
        example.createCriteria().andEqualTo("proid", proid);
        list = entityMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return new BdcJzwsyq();
        }
        //判断是否是林权
        example = new Example(BdcLq.class);
        example.createCriteria().andEqualTo("proid", proid);
        list = entityMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return new BdcLq();
        }
        //判断是否是其他相关权利
        example = new Example(BdcQsq.class);
        example.createCriteria().andEqualTo("proid", proid);
        list = entityMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return new BdcQsq();
        }
        //判断是否是土地承包经营权、农用地使用权
        example = new Example(BdcTdcbnydsyq.class);
        example.createCriteria().andEqualTo("proid", proid);
        list = entityMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return new BdcTdcbnydsyq();
        }
        //判断是否是土地所有权
        example = new Example(BdcTdsyq.class);
        example.createCriteria().andEqualTo("proid", proid);
        list = entityMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return new BdcTdsyq();
        }
        //判断是否是预告
        example = new Example(BdcYg.class);
        example.createCriteria().andEqualTo("proid", proid);
        list = entityMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return new BdcYg();
        }
        //判断是否是异议
        example = new Example(BdcYy.class);
        example.createCriteria().andEqualTo("proid", proid);
        list = entityMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return new BdcYy();
        }
        return null;
    }

    @Override
    public List<Map> getQllxListByPage(HashMap map) {
        return bdcQllxMapper.getQllxListByPage(map);
    }

    @Override
    public String makeSureBdcqzlx(QllxVo qllxVo) {
        String zsFont = "";
        if (qllxVo instanceof BdcCf) {
            zsFont = Constants.BDCQZM_BH_FONT;
        } else if (qllxVo instanceof BdcDyaq) {
            zsFont = Constants.BDCQZM_BH_FONT;
        } else if (qllxVo instanceof BdcDyq) {
            zsFont = Constants.BDCQZM_BH_FONT;
        } else if (qllxVo instanceof BdcFdcq) {
            zsFont = Constants.BDCQZS_BH_FONT;
        } else if (qllxVo instanceof BdcFdcqDz) {
            zsFont = Constants.BDCQZS_BH_FONT;
        } else if (qllxVo instanceof BdcHysyq) {
            zsFont = Constants.BDCQZS_BH_FONT;
        } else if (qllxVo instanceof BdcJsydzjdsyq) {
            zsFont = Constants.BDCQZS_BH_FONT;
        } else if (qllxVo instanceof BdcJzwgy) {
            zsFont = Constants.BDCQZM_BH_FONT;
        } else if (qllxVo instanceof BdcJzwsyq) {
            zsFont = Constants.BDCQZS_BH_FONT;
        } else if (qllxVo instanceof BdcLq) {
            zsFont = Constants.BDCQZS_BH_FONT;
        } else if (qllxVo instanceof BdcQsq) {
            zsFont = Constants.BDCQZM_BH_FONT;
        } else if (qllxVo instanceof BdcTdcbnydsyq) {
            zsFont = Constants.BDCQZS_BH_FONT;
        } else if (qllxVo instanceof BdcTdsyq) {
            zsFont = Constants.BDCQZS_BH_FONT;
        } else {
            zsFont = Constants.BDCQZM_BH_FONT;
        }
        return zsFont;
    }

    @Override
    public QllxVo queryQllxVo(BdcXm bdcXm) {
        QllxVo qllxVo = makeSureQllx(bdcXm);
        if (qllxVo != null && StringUtils.isNotBlank(bdcXm.getProid())) {
            qllxVo = queryQllxVo(qllxVo, bdcXm.getProid());
        }
        return qllxVo;
    }

    @Override
    public QllxVo queryQllxVo(QllxVo qllxVo, String proid) {
        QllxVo returnQllx = null;
        if (qllxVo != null && StringUtils.isNotBlank(proid)) {
            Example qllxTemp = new Example(qllxVo.getClass());
            qllxTemp.createCriteria().andEqualTo("proid", proid);
            List<QllxVo> qllxVoList = (List<QllxVo>) entityMapper.selectByExample(qllxVo.getClass(), qllxTemp);
            if (qllxVoList != null && qllxVoList.size() > 0) {
                returnQllx = qllxVoList.get(0);
            }

            if (returnQllx == null) {
                qllxVo = new BdcFdcqDz();
                qllxVoList = (List<QllxVo>) entityMapper.selectByExample(qllxVo.getClass(), qllxTemp);
                if (qllxVoList != null && qllxVoList.size() > 0) {
                    returnQllx = qllxVoList.get(0);
                }
            }
            //hqz 判断当前是否为房屋多幢，并把项目取出
            if (qllxVo instanceof BdcFdcqDz) {
                String qlid = qllxVo.getQlid();
                if (StringUtils.isNotBlank(qlid)) {
                    List<BdcFwfzxx> fwfzxxs = bdcFdcqDzMapper.queryBdcFwfzxxlstByQlid(qlid);
                    ((BdcFdcqDz) qllxVo).setFwfzxxList(fwfzxxs);
                }
            }
        }
        return returnQllx;
    }

    @Override
    public QllxVo queryQllxVoByBdcdyh(String bdcdyh, String qllx) {
        QllxVo returnQllx = null;
        if (StringUtils.isNoneBlank(bdcdyh)) {
            BdcBdcdy bdcBdcdy = bdcdyService.getBdcdyByBdcdyh(bdcdyh);
            if (bdcBdcdy != null && StringUtils.isNoneBlank(bdcBdcdy.getBdcdyid())) {
                returnQllx = queryQllxVoByBdcdyid(bdcBdcdy.getBdcdyid(), qllx);
            }
        }
        return returnQllx;
    }

    @Override
    public QllxVo queryQllxVoByBdcdyid(String bdcdyid, String qllx) {
        QllxVo returnQllx = null;
        if (StringUtils.isNoneBlank(bdcdyid)) {
            Example example = new Example(BdcXm.class);
            example.createCriteria().andEqualTo("bdcdyid", bdcdyid).andEqualTo("qllx", qllx);
            List<BdcXm> bdcXmList = entityMapper.selectByExampleNotNull(example);
            if (CollectionUtils.isNotEmpty(bdcXmList)) {
                for (BdcXm bdcXm : bdcXmList) {
                    if (bdcXm != null && StringUtils.isNoneBlank(bdcXm.getProid())) {
                        QllxVo qllxVo = queryQllxVo(bdcXm);
                        if (qllxVo != null && qllxVo.getQszt().equals(Constants.QLLX_QSZT_XS)) {
                            returnQllx = qllxVo;
                            break;
                        }
                    }
                }
            }
        }
        return returnQllx;
    }

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 新建权利表
     */
    @Override
    public QllxVo newQllxVo(BdcXm bdcXm, String bdcdyid, InitVoFromParm initVoFromParm) {
        QllxVo qllxVo = makeSureQllx(bdcXm);
        if (qllxVo != null) {
            qllxVo.setQlid(UUIDGenerator.generate18());
            qllxVo.setBdcdyid(bdcdyid);
            qllxVo.setProid(bdcXm.getProid());
            qllxVo.setYwh(bdcXm.getBh());
            qllxVo.setQllx(bdcXm.getQllx());
            qllxVo.setQszt(Constants.QLLX_QSZT_XS);
            if (initVoFromParm != null) {
                if (qllxVo instanceof BdcTdcbnydsyq && initVoFromParm.getDjsjNydDcb() != null) {
                    DjsjNydDcb djsjNydDcb = initVoFromParm.getDjsjNydDcb();
                    ((BdcTdcbnydsyq) qllxVo).setSyksqx(djsjNydDcb.getQsrq());
                    ((BdcTdcbnydsyq) qllxVo).setSyjsqx(djsjNydDcb.getZzrq());
                    ((BdcTdcbnydsyq) qllxVo).setSyqmj(djsjNydDcb.getFzmj());
                    if (initVoFromParm.getCbzdDcb() != null) {
                        DjsjCbzdDcb djsjCbzdDcb = initVoFromParm.getCbzdDcb();
                        DjsjCbzdCbf djsjCbzdCbf = initVoFromParm.getCbzdCbf();
                        BdcTdcbnydsyq bdcTdcbnydsyq = (BdcTdcbnydsyq) qllxVo;
                        if (StringUtils.isNotBlank(djsjCbzdDcb.getSyttlx())) {
                            bdcTdcbnydsyq.setSyttlx(djsjCbzdDcb.getSyttlx());
                        }
                        if (StringUtils.isNotBlank(djsjCbzdDcb.getYzyfs())) {
                            bdcTdcbnydsyq.setYzyfs(djsjCbzdDcb.getYzyfs());
                        }
                        if (djsjCbzdDcb.getCcgd() != null) {
                            bdcTdcbnydsyq.setCcgd(djsjCbzdDcb.getCcgd());
                        }
                        if (djsjCbzdDcb.getCdfgd() != null) {
                            bdcTdcbnydsyq.setCdfgd(djsjCbzdDcb.getCcgd().toString());
                        }
                        if (djsjCbzdDcb.getCdjq() != null) {
                            bdcTdcbnydsyq.setCdjq(djsjCbzdDcb.getCdjq());
                        }
                        if (djsjCbzdDcb.getCdysz() != null) {
                            bdcTdcbnydsyq.setCdysz(djsjCbzdDcb.getCdysz());
                        }
                        if (djsjCbzdDcb.getSyzxl() != null) {
                            bdcTdcbnydsyq.setSyzcl(djsjCbzdDcb.getSyzxl());
                        }
                        if (djsjCbzdCbf != null) {
                            bdcTdcbnydsyq.setQdcbfs(djsjCbzdCbf.getQdcbfs());
                        }
                    }
                }
                if (qllxVo instanceof BdcLq && initVoFromParm.getDjsjNydDcb() != null) {
                    DjsjNydDcb djsjNydDcb = initVoFromParm.getDjsjNydDcb();
                    ((BdcLq) qllxVo).setLdsyksqx(djsjNydDcb.getQsrq());
                    ((BdcLq) qllxVo).setLdsyjsqx(djsjNydDcb.getZzrq());
                    ((BdcLq) qllxVo).setSyqmj(djsjNydDcb.getFzmj());
                    if (initVoFromParm.getDjsjLqxx() != null) {
                        DjsjLqxx djsjLqxx = initVoFromParm.getDjsjLqxx();
                        BdcLq bdcLq = (BdcLq) qllxVo;
                        if (djsjLqxx.getZlnd() != null) {
                            bdcLq.setZlnd(djsjLqxx.getZlnd().toString());
                        }
                        if (StringUtils.isNotBlank(djsjLqxx.getXdm())) {
                            bdcLq.setXdm(djsjLqxx.getXdm());
                        }
                        if (StringUtils.isNotBlank(djsjLqxx.getLb())) {
                            bdcLq.setLb(djsjLqxx.getLb());
                        }
                        if (StringUtils.isNotBlank(djsjLqxx.getXb())) {
                            bdcLq.setXb(djsjLqxx.getXb());
                        }
                        if (StringUtils.isNotBlank(djsjLqxx.getQy())) {
                            bdcLq.setQy(djsjLqxx.getQy());
                        }
                        if (djsjLqxx.getZs() != null) {
                            bdcLq.setZs(djsjLqxx.getZs());
                        }
                        if (StringUtils.isNotBlank(djsjLqxx.getZysz())) {
                            bdcLq.setZysz(djsjLqxx.getZysz());
                        }
                        if (StringUtils.isNotBlank(djsjLqxx.getLz())) {
                            bdcLq.setLz(djsjLqxx.getLz());
                        }
                    }
                }
                if (qllxVo instanceof BdcHysyq && initVoFromParm.getDjsjZhxx() != null) {
                    DjsjZhxx djsjZhxx = initVoFromParm.getDjsjZhxx();
                    ((BdcHysyq) qllxVo).setSyksqx(djsjZhxx.getQsrq());
                    ((BdcHysyq) qllxVo).setSyjsqx(djsjZhxx.getZzrq());
                    ((BdcHysyq) qllxVo).setSyqmj(djsjZhxx.getZhmj());
                    BdcHysyq bdcHysyq = (BdcHysyq) qllxVo;
                    if (StringUtils.isNoneBlank(djsjZhxx.getXmmc())) {
                        bdcHysyq.setXmmc(djsjZhxx.getXmmc());
                    }
                }
            }

        }
        return qllxVo;
    }

    /**
     * @param bdcdyh    不动产单元号
     * @param bdclx     不动产类型
     * @param djId      地籍ID
     * @param bdcdyFwlx 不动产单元房屋类型
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 根据不动产单元号创建产权
     */
    @Override
    public QllxVo initPropertyRight(String bdcdyh, String bdclx, String djId, String bdcdyFwlx) {
        QllxVo qllxVo = null;
        if (StringUtils.isNoneBlank(bdcdyh, bdclx, djId) && StringUtils.length(bdcdyh) == 28) {
            String qllx = ReadXmlProps.getQllx(StringUtils.substring(bdcdyh, 12, 14), StringUtils.substring(bdcdyh, 19, 20));
            if (StringUtils.isNoneBlank(qllx)) {
                qllxVo = queryQllxVoByBdcdyh(bdcdyh, qllx);
                if (qllxVo == null) {
                    bdcdyService.initDjBdcdy(djId, bdcdyh, bdclx, bdcdyFwlx);
                    dataManagerService.addData(djId, bdcdyh, qllx, bdclx, bdcdyFwlx);
                    qllxVo = queryQllxVoByBdcdyh(bdcdyh, qllx);
                }
            }
        }
        return qllxVo;
    }

    @Override
    public void endQllxZt(BdcXm bdcXm) {
        if (CommonUtil.indexOfStrs(Constants.DJLX_DY_ZXDJ_SQLXDM, bdcXm.getSqlx()) || StringUtils.equals(Constants.SQLX_ZJJZW_ZX_DM, bdcXm.getSqlx()) || StringUtils.equals(Constants.SQLX_ZJJZW_ZX_FW_DM, bdcXm.getSqlx())) {
            changeQllxZt(bdcXm, Constants.QLLX_QSZT_HR, true);
        } else {
            changeQllxZt(bdcXm, Constants.QLLX_QSZT_XS, true);
        }
    }

    @Override
    public void changeQllxZt(BdcXm bdcxm, Integer qszt, Boolean ignoreHr) {
        if (bdcxm != null) {
            QllxVo qllxVo = makeSureQllx(bdcxm);
            if (qllxVo != null) {
                Example qllx = new Example(qllxVo.getClass());

                /**
                 * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
                 * @description 过滤掉历史状态的权利。如果ignoreHr为true,则需要将qszt为历史的过滤掉，主要针对【批量抵押变更做部分注销】
                 * 当前权利的权属状态操作要过滤历史状态的，针对原权利权属状态的不需要过滤
                 */
                if (ignoreHr) {
                    qllx.createCriteria().andEqualTo("proid", bdcxm.getProid()).andNotEqualTo("qszt", Constants.QLLX_QSZT_HR);
                } else {
                    qllx.createCriteria().andEqualTo("proid", bdcxm.getProid());
                }

                List<QllxVo> qllxVoList = (List<QllxVo>) entityMapper.selectByExample(qllxVo.getClass(), qllx);
                if (qllxVoList != null && qllxVoList.size() > 0) {
                    for (QllxVo yqllxVo : qllxVoList) {
                        if (yqllxVo != null) {
                            //zhouwanqing 过度解封生成的权利没有相关解封信息，所以在这添上
                            if (yqllxVo instanceof BdcCf && !StringUtils.equals(bdcxm.getXmly(), Constants.XMLY_BDC) && !CommonUtil.indexOfStrs(Constants.CF_SQLX, bdcxm.getSqlx())) {
                                BdcCf bdcCf = (BdcCf) yqllxVo;
                                bdcCf.setJfdjsj(new Date());
                                /**
                                 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
                                 * @description 过渡创建的续封做解封, 解封业务号不再赋值
                                 */
                                if (StringUtils.isBlank(bdcCf.getJfywh())) {
                                    bdcCf.setJfywh(bdcxm.getBh());
                                }
                                //解封流程只有一个受理，所以解封登簿人就是查封登簿人
                                bdcCf.setJfdbr(bdcCf.getDbr());
                                yqllxVo = bdcCf;
                            }
                            yqllxVo.setQszt(qszt);
                            //zdd 根据权利状态  处理权利开始以及结束时间属性
                            if (qszt == Constants.QLLX_QSZT_XS) {
                                yqllxVo.setQlqssj(CalendarUtil.getCurDate());
                            } else if (qszt == Constants.QLLX_QSZT_HR) {
                                yqllxVo.setQljssj(CalendarUtil.getCurDate());
                            }
                            entityMapper.updateByPrimaryKeySelective(yqllxVo);
                        }
                    }
                }
            }
        }

    }


    @Override
    public QllxVo updateDbr(QllxVo qllxVo, String userId) {
        if (qllxVo != null && StringUtils.isNotBlank(userId)) {
            PfUserVo pfUserVo = sysUserService.getUserVo(userId);
            BdcXm bdcXm = bdcXmService.getBdcXmByProid(qllxVo.getProid());
            if (pfUserVo != null) {
                if (StringUtils.equals(bdcXm.getXmly(), Constants.XMLY_FWSP) && StringUtils.equals(bdcXm.getSqlx(), Constants.SQLX_JF)) {
                    qllxVo.setDbr(null);
                    qllxVo.setDjsj(null);
                    if (qllxVo instanceof BdcCf) {
                        BdcCf bdcCf = (BdcCf) qllxVo;
                        bdcCf.setJfdbr(pfUserVo.getUserName());
                        bdcCf.setJfdjsj(new Date());
                        entityMapper.saveOrUpdate(bdcCf, bdcCf.getQlid());
                    }
                } else {
                    qllxVo.setDbr(pfUserVo.getUserName());
                    qllxVo.setDjsj(new Date());
                }
                //同时更新登记簿
                bdcDjbService.updateDjb(qllxVo.getProid(), pfUserVo.getUserName(), qllxVo);
            }
        }
        return qllxVo;
    }


    @Override
    public QllxVo updateZxDbr(QllxVo yqllxVo, String userId) {
        String getUserId = userId;
        Date getUserDate = new Date();
//        if (yqllxVo != null && StringUtils.isNotBlank(signKey)) {
//            List<PfSignVo> pfSignVoList = sysSignService.getSignList(signKey, proid);
//            if (pfSignVoList != null && pfSignVoList.size() > 0) {
//                getUserId = pfSignVoList.get(0).getUserId();
//                getUserDate = pfSignVoList.get(0).getSignDate();
//            }
//        } else if (yqllxVo != null && StringUtils.isNotBlank(defaultUserId)) {
//            getUserId = defaultUserId;
//            getUserDate = new Date();
//        } else if (yqllxVo != null && StringUtils.isNotBlank(userId)) {
//            getUserId = userId;
//            getUserDate = new Date();
//        }
        if (yqllxVo != null && StringUtils.isNotBlank(getUserId)) {
            PfUserVo pfUserVo = sysUserService.getUserVo(getUserId);
            if (pfUserVo != null) {
                if (yqllxVo instanceof BdcDyaq) {
                    BdcDyaq bdcDyaq = (BdcDyaq) yqllxVo;
                    bdcDyaq.setZxdbr(pfUserVo.getUserName());
                    bdcDyaq.setZxsj(getUserDate);
                    yqllxVo = bdcDyaq;
                } else if (yqllxVo instanceof BdcCf) {
                    BdcCf bdcCf = (BdcCf) yqllxVo;
                    bdcCf.setJfdbr(pfUserVo.getUserName());
                    bdcCf.setJfdjsj(getUserDate);
                    yqllxVo = bdcCf;
                } else if (yqllxVo instanceof BdcYy) {
                    BdcYy bdcYy = (BdcYy) yqllxVo;
                    bdcYy.setZxdbr(pfUserVo.getUserName());
                    bdcYy.setZxsj(getUserDate);
                    yqllxVo = bdcYy;
                }
            }
        }
        return yqllxVo;
    }


    @Override
    public void updateZxQllx(QllxVo qllxVo) {
        if (qllxVo != null) {
            String fj = qllxVo.getFj();
            if (StringUtils.isNotBlank(fj) && (StringUtils.contains(fj, "已注销") || StringUtils.contains(fj, "\n已注销"))) {
                qllxVo.setFj(StringUtils.remove(fj, "\n已注销"));
                qllxVo.setFj(StringUtils.remove(fj, "已注销"));
            }

            if (qllxVo instanceof BdcDyaq) {
                BdcDyaq bdcDyaq = (BdcDyaq) qllxVo;
                bdcDyaq.setZxdyywh(null);
                bdcDyaq.setZxdyyy(null);
                bdcDyaq.setZxdbr(null);
                bdcDyaq.setZxsj(null);
                entityMapper.updateByPrimaryKeyNull(bdcDyaq);
            } else if (qllxVo instanceof BdcCf) {
                BdcCf bdcCf = (BdcCf) qllxVo;
                bdcCf.setJfywh(null);
                bdcCf.setJfyy(null);
                bdcCf.setJfjg(null);
                bdcCf.setJflx(null);
                bdcCf.setJfwh(null);
                bdcCf.setJfwj(null);
                bdcCf.setJfdbr(null);
                bdcCf.setJfdjsj(null);
                entityMapper.updateByPrimaryKeyNull(bdcCf);
            } else if (qllxVo instanceof BdcYy) {
                BdcYy bdcYy = (BdcYy) qllxVo;
                bdcYy.setZxyyh(null);
                bdcYy.setZxyyyy(null);
                bdcYy.setZxdbr(null);
                bdcYy.setZxsj(null);
                entityMapper.updateByPrimaryKeyNull(bdcYy);
            } else if (qllxVo instanceof BdcFdcq) {
                BdcFdcq bdcFdcq = (BdcFdcq) qllxVo;
                bdcFdcq.setZxdbr(null);
                bdcFdcq.setZxdbsj(null);
                bdcFdcq.setZxywh(null);
                bdcFdcq.setZxyy(null);
                entityMapper.updateByPrimaryKeyNull(bdcFdcq);
            } else if (qllxVo instanceof BdcFdcqDz) {
                BdcFdcqDz bdcFdcqDz = (BdcFdcqDz) qllxVo;
                bdcFdcqDz.setZxdbr(null);
                bdcFdcqDz.setZxdbsj(null);
                bdcFdcqDz.setZxywh(null);
                bdcFdcqDz.setZxyy(null);
                entityMapper.updateByPrimaryKeyNull(bdcFdcqDz);
            } else if (qllxVo instanceof BdcLq) {
                BdcLq bdcLq = (BdcLq) qllxVo;
                bdcLq.setZxdbr(null);
                bdcLq.setZxdbsj(null);
                bdcLq.setZxywh(null);
                bdcLq.setZxyy(null);
                entityMapper.updateByPrimaryKeyNull(bdcLq);
            } else if (qllxVo instanceof BdcTdsyq) {
                BdcTdsyq bdcTdsyq = (BdcTdsyq) qllxVo;
                bdcTdsyq.setZxdbr(null);
                bdcTdsyq.setZxdbsj(null);
                bdcTdsyq.setZxywh(null);
                bdcTdsyq.setZxyy(null);
                entityMapper.updateByPrimaryKeyNull(bdcTdsyq);
            } else if (qllxVo instanceof BdcJsydzjdsyq) {
                BdcJsydzjdsyq bdcJsydzjdsyq = (BdcJsydzjdsyq) qllxVo;
                bdcJsydzjdsyq.setZxdbr(null);
                bdcJsydzjdsyq.setZxdbsj(null);
                bdcJsydzjdsyq.setZxywh(null);
                bdcJsydzjdsyq.setZxyy(null);
                entityMapper.updateByPrimaryKeyNull(bdcJsydzjdsyq);
            } else if (qllxVo instanceof BdcTdcbnydsyq) {
                BdcTdcbnydsyq bdcTdcbnydsyq = (BdcTdcbnydsyq) qllxVo;
                bdcTdcbnydsyq.setZxdbr(null);
                bdcTdcbnydsyq.setZxdbsj(null);
                bdcTdcbnydsyq.setZxywh(null);
                bdcTdcbnydsyq.setZxyy(null);
                entityMapper.updateByPrimaryKeyNull(bdcTdcbnydsyq);
            } else if (qllxVo instanceof BdcHysyq) {
                BdcHysyq bdcHysyq = (BdcHysyq) qllxVo;
                bdcHysyq.setZxdbr(null);
                bdcHysyq.setZxdbsj(null);
                bdcHysyq.setZxywh(null);
                bdcHysyq.setZxyy(null);
                entityMapper.updateByPrimaryKeyNull(bdcHysyq);
            } else if (qllxVo instanceof BdcJzwsyq) {
                BdcJzwsyq bdcJzwsyq = (BdcJzwsyq) qllxVo;
                bdcJzwsyq.setZxdbr(null);
                bdcJzwsyq.setZxdbsj(null);
                bdcJzwsyq.setZxywh(null);
                bdcJzwsyq.setZxyy(null);
                entityMapper.updateByPrimaryKeyNull(bdcJzwsyq);
            } else if (qllxVo instanceof BdcDyq) {
                BdcDyq bdcDyq = (BdcDyq) qllxVo;
                bdcDyq.setZxdbr(null);
                bdcDyq.setZxdbsj(null);
                bdcDyq.setZxywh(null);
                bdcDyq.setZxyy(null);
                entityMapper.updateByPrimaryKeyNull(bdcDyq);
            } else if (qllxVo instanceof BdcYg) {
                BdcYg bdcYg = (BdcYg) qllxVo;
                bdcYg.setZxdbr(null);
                bdcYg.setZxdbsj(null);
                bdcYg.setZxywh(null);
                bdcYg.setZxyy(null);
                entityMapper.updateByPrimaryKeyNull(bdcYg);
            }
        }
    }

    @Override
    public String getQllxByXnbdcdyh(String bdcdyh) {
        String qllx = "";
        String sfxnbdcdyh = AppConfig.getProperty("sfsc.xnbdcdyh");
        if (StringUtils.isNotBlank(sfxnbdcdyh) && StringUtils.equals(sfxnbdcdyh, "true")) {
            String bsm = StringUtils.substring(bdcdyh, 6, 7);
            if (StringUtils.equals(Constants.FLAG_XNBDCDYH, bsm)) {
                List<BdcXm> bdcXmList = bdcXmService.getBdcXmByBdcdyh(bdcdyh);
                if (CollectionUtils.isNotEmpty(bdcXmList)) {
                    qllx = bdcXmList.get(0).getQllx();
                }

            }
        }
        return qllx;
    }
}
