package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.service.RepositoryService;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/*
 * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
 * @version 1.0, 2017/11/29
 * @description  分页查询服务
 */
@Service
public class RepositoryServiceImpl implements RepositoryService {
    @Autowired
    private Repo repository;

    @Override
    public Page<HashMap> selectPaging(String name, Map map, Pageable pageable) {
        Page<HashMap> dataPaging = null;
        if (StringUtils.isNotBlank(name)) {
            dataPaging = repository.selectPaging(name, map, pageable);
        }
        return dataPaging;
    }
}
