package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.service.WorkFlowService;
import cn.gtmap.estateplat.config.utils.PlatformUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/27.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class WorkFlowServiceImpl implements WorkFlowService {

    @Autowired
    PlatformUtil platformUtil;

    @Override
    public List<HashMap> getWorkFlowNodes(String workFlowId) {
        String xml = PlatformUtil.getWorkFlowDefineService().getWorkFlowDefineXml(workFlowId);
        List<HashMap> listResult = new ArrayList<HashMap>();
        if (StringUtils.isNotBlank(xml)) {
            Document doc = null;
            try {
                doc = DocumentHelper.parseText(xml); // 将字符串转为XML
                Element rootElt = doc.getRootElement(); //
                List nodeList = rootElt.selectNodes("//Package/WorkflowProcesses/WorkflowProcess/Activities/Activity");
                if (nodeList != null && nodeList.size() > 0) {
                    for (int i = 0; i < nodeList.size(); i++) {
                        HashMap map = new HashMap();
                        Element element = (Element) nodeList.get(i);
                        String id = element.attributeValue("Id");
                        String name = element.attributeValue("Name");
                        map.put("dm", id);
                        map.put("mc", name);
                        listResult.add(map);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return listResult;
    }

    @Override
    public String getWorkflowNodeName(final String nodeId, final String wdid) {
        String nodeName = "";
        if (StringUtils.isNotBlank(nodeId) && StringUtils.isNotBlank(wdid)) {
            List<HashMap> nodeMapList = getWorkflowNode(wdid);
            if (CollectionUtils.isNotEmpty(nodeMapList)) {
                for (HashMap map : nodeMapList) {
                    if (StringUtils.equals(CommonUtil.formatEmptyValue(map.get("dm")), nodeId)) {
                        nodeName = CommonUtil.formatEmptyValue(map.get("mc"));
                        break;
                    }
                }
            }
        }
        return nodeName;
    }


    @Override
    public String getWorkflowNodeId(final String nodeName, final String wdid) {
        String nodeId = "";
        if (StringUtils.isNotBlank(nodeName) && StringUtils.isNotBlank(wdid)) {
            List<HashMap> nodeMapList = getWorkflowNode(wdid);
            if (CollectionUtils.isNotEmpty(nodeMapList)) {
                for (HashMap map : nodeMapList) {
                    if (StringUtils.equals(CommonUtil.formatEmptyValue(map.get("mc")), nodeName)) {
                        nodeId = CommonUtil.formatEmptyValue(map.get("dm"));
                        break;
                    }
                }
            }

        }
        return nodeId;
    }

    public List<HashMap> getWorkflowNode(String wdid) {
        List<HashMap> nodeMapList = null;
        if (StringUtils.isNotBlank(wdid)) {
            String xml = PlatformUtil.getWorkFlowDefineService().getWorkFlowDefineXml(wdid);
            nodeMapList = getWorkFlowNodes(xml);
        }
        return nodeMapList;
    }
}
