package cn.gtmap.estateplat.config.core.service.impl.dataManager;

import cn.gtmap.estateplat.config.core.service.BdcdyService;
import cn.gtmap.estateplat.config.core.service.LogService;
import cn.gtmap.estateplat.config.core.service.dataManager.HandleDateService;
import cn.gtmap.estateplat.config.model.ArdBdcXm;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/11/20
 * @description
 */
@Service
public class HandleDataServiceImpl implements HandleDateService {

    @Autowired
    private EntityMapper entityMapper;

    @Autowired
    private LogService logService;

    @Autowired
    private BdcdyService bdcdyService;

    @Override
    @Transactional
    public void saveData(List<Object> objectList) {
        if (CollectionUtils.isNotEmpty(objectList)) {
            for (Object object : objectList) {
                entityMapper.insertSelective(object);
            }
        }
    }

    @Override
    public String creatBdcdyh(ArdBdcXm ardBdcXm,String type){
        String bdcdyh="";
        //6位县级行政区代码
        Integer len = 6;
        String dwdm ="";
        if(ardBdcXm != null &&StringUtils.isNotBlank(ardBdcXm.getDwdm())){
            dwdm =ardBdcXm.getDwdm();
            if (dwdm.length() < len) {
                do {
                    dwdm = dwdm +"0";
                } while (dwdm.length() < len);
            }
            //获取最大的虚拟不动产单元号
            HashMap map = new HashMap();
            map.put("xzqdm",dwdm);
            map.put("bsm",Constants.FLAG_XNBDCDYH);
            if (StringUtils.equals(type, "LM")) {
                map.put("zdtzm",Constants.DZWTZM_L);
            }
            Integer maxLsh =bdcdyService.getMaxBdcdyhLsh(map);
            if (maxLsh == null) {
                maxLsh = 0;
            }
            maxLsh = ++maxLsh;
            String lsh =maxLsh.toString();
            //12位递增数
            if (lsh.length() < 12) {
                do {
                    lsh = "0" + lsh;
                } while (lsh.length() < 12);
            }
            bdcdyh =dwdm +Constants.FLAG_XNBDCDYH +lsh+Constants.DZWTZM_L+"00000001";
        }
        return bdcdyh;

    }
}
