package cn.gtmap.estateplat.config.core.service.impl.dataManager;

import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.core.service.dataManager.HandleDateService;
import cn.gtmap.estateplat.config.core.service.dataManager.OrganizeArdDataService;
import cn.gtmap.estateplat.config.model.*;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.config.utils.ReadXmlProps;
import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/9/8
 * @description
 */
@Service
public class OrganizeArdDataServiceImpl implements OrganizeArdDataService {

    @Autowired
    private BdcdyService bdcdyService;

    @Autowired
    private BdcXmService bdcXmService;

    @Autowired
    private QllxService qllxService;

    @Autowired
    private BdcZdGlService bdcZdGlService;

    @Autowired
    private HandleDateService handleDataService;

    @Autowired
    private LogService logService;

    @Autowired
    private EntityMapper entityMapper;

    @Override
    public Map<String, String> initArdExcelProject(Map<String, List<Object>> map, String type) {
        Boolean sfxnbdcdyh = false;
        StringBuilder result = new StringBuilder();
        StringBuilder msg = new StringBuilder();
        Map<String, String> resultMap = Maps.newHashMap();
        try {
            if (map != null && !map.isEmpty()) {
                Set<Map.Entry<String, List<Object>>> set = map.entrySet();
                if (CollectionUtils.isNotEmpty(set)) {
                    int total = set.size();
                    int failTotal = 0;
                    Map<String, List<Object>> remainMap = Maps.newHashMap();
                    for (Map.Entry<String, List<Object>> entry : set) {
                        if (entry != null) {
                            List<Object> objectList = entry.getValue();
                            if (CollectionUtils.isNotEmpty(objectList)) {
                                List<Object> dataList = Lists.newArrayList();
                                for (Object object : objectList) {
                                    if (object != null && object instanceof ArdBdcXm) {
                                        ArdBdcXm ardBdcXm = (ArdBdcXm) object;
                                        if (StringUtils.isBlank(ardBdcXm.getBdcdyh())) {
                                            String sfscxnbdcdyh = AppConfig.getProperty("sfsc.xnbdcdyh");
                                            if (StringUtils.isNotBlank(sfscxnbdcdyh) && StringUtils.equals(sfscxnbdcdyh, "true")) {
                                                String xnbdcdyh = handleDataService.creatBdcdyh(ardBdcXm, type);
                                                ardBdcXm.setBdcdyh(xnbdcdyh);
                                                sfxnbdcdyh = true;
                                            } else {
                                                break;
                                            }
                                        }
                                        if (StringUtils.isNotBlank(ardBdcXm.getBdcdyh())) {
                                            Map<String, Object> bdcBdcdyMap = initArdBdcBdcdy(ardBdcXm, sfxnbdcdyh);
                                            if ((bdcBdcdyMap != null && bdcBdcdyMap.get("bdcdy") != null && StringUtils.isNoneBlank(bdcBdcdyMap.get("djId").toString())) || sfxnbdcdyh) {
                                                String qllx = bdcZdGlService.parseNameToCode(ardBdcXm.getQllx(), "QLLX");
                                                if (!(StringUtils.equals(qllx, Constants.QLLX_DYAQ) || StringUtils.equals(qllx, Constants.QLLX_CFDJ))) {
                                                    String handleResult = initArdData(ardBdcXm, bdcBdcdyMap, objectList, dataList, type, sfxnbdcdyh);
                                                    if (StringUtils.isNoneBlank(handleResult)) {
                                                        failTotal++;
                                                        msg.append(handleResult);
                                                    }
                                                } else {
                                                    remainMap.put(entry.getKey(), entry.getValue());
                                                    break;
                                                }
                                            } else {
                                                throw new AppException("未找到权籍数据，请检查");
                                            }
                                        }
                                    }
                                }
                            } else {
                                throw new AppException("数据错误");
                            }
                        }
                    }
                    if (!remainMap.isEmpty()) {
                        Set<Map.Entry<String, List<Object>>> remainSet = remainMap.entrySet();
                        for (Map.Entry<String, List<Object>> entry : remainSet) {
                            if (entry != null) {
                                List<Object> dataList = Lists.newArrayList();
                                List<Object> objectList = entry.getValue();
                                if (CollectionUtils.isNotEmpty(objectList)) {
                                    for (Object object : objectList) {
                                        if (object != null && object instanceof ArdBdcXm) {
                                            ArdBdcXm ardBdcXm = (ArdBdcXm) object;
                                            if (StringUtils.isBlank(ardBdcXm.getBdcdyh())) {
                                                break;
                                            } else {
                                                Map<String, Object> bdcBdcdyMap = initArdBdcBdcdy(ardBdcXm, sfxnbdcdyh);
                                                if (bdcBdcdyMap != null && bdcBdcdyMap.get("bdcdy") != null && StringUtils.isNoneBlank(bdcBdcdyMap.get("djId").toString())) {
                                                    String handleResult = initArdData(ardBdcXm, bdcBdcdyMap, objectList, dataList, type, sfxnbdcdyh);
                                                    if (StringUtils.isNoneBlank(handleResult)) {
                                                        failTotal++;
                                                        msg.append(handleResult);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    throw new AppException("数据错误");
                                }
                            }
                        }
                    }
                    result.append("共计").append(total).append("套数据，其中导入成功").append(total - failTotal).append("套，失败").append(failTotal).append("套");
                } else {
                    throw new AppException("数据错误");
                }
            }
        } catch (Exception e) {
            result.append(e.toString());
        }
        resultMap.put("result", result.toString());
        resultMap.put("msg", msg.toString());
        return resultMap;
    }

    private String initArdData(ArdBdcXm ardBdcXm, Map<String, Object> bdcBdcdyMap, List<Object> objectList, List<Object> dataList, String type, Boolean sfxnbdcdyh) {
        StringBuilder resultBuilder = new StringBuilder();
        BdcXm bdcXm = initArdBdcXmInfo(ardBdcXm, (BdcBdcdy) bdcBdcdyMap.get("bdcdy"), objectList, bdcBdcdyMap.get("djId").toString(), dataList);
        if (bdcXm != null) {
            String cqQllx = ReadXmlProps.getQllx(StringUtils.substring(ardBdcXm.getBdcdyh(), 12, 14), StringUtils.substring(ardBdcXm.getBdcdyh(), 19, 20));
            if (StringUtils.equals(bdcXm.getQllx(), cqQllx) || StringUtils.equals(bdcXm.getQllx(), Constants.QLLX_DYAQ) || StringUtils.equals(bdcXm.getQllx(), Constants.QLLX_CFDJ) || sfxnbdcdyh) {
                QllxVo qllxVo = initArdQllxVoInfo(ardBdcXm, bdcXm, objectList, dataList, type);
                if (qllxVo != null) {
                    List<BdcQlr> bdcQlrList = initArdBdcQlrInfo(bdcXm, objectList, dataList);
                    initArdBdcZsInfo(ardBdcXm, bdcXm, bdcQlrList, objectList, dataList);
                    try {
                        handleDataService.saveData(dataList);
                        logService.saveExcelLog(dataList.toArray());
                    } catch (Exception e) {
                        resultBuilder.append("业务号:").append(ardBdcXm.getYwh()).append(", 状态:导入失败, 失败原因:");
                        if (e.getCause() != null) {
                            resultBuilder.append(StringUtils.deleteWhitespace(e.getCause().getMessage())).append("<hr>");
                        } else {
                            resultBuilder.append(StringUtils.deleteWhitespace(e.getMessage())).append("<hr>");
                        }
                    }
                }
            } else {
                resultBuilder.append("业务号:").append(ardBdcXm.getYwh()).append(", 状态:导入失败, 失败原因:所属不动产单元无法录入指定产权！");
            }
        }
        return resultBuilder.toString();
    }


    private Map<String, Object> initArdBdcBdcdy(ArdBdcXm ardBdcXm, Boolean sfxnbdcdyh) {
        Map<String, Object> map = Maps.newHashMap();
        BdcBdcdy bdcBdcdy = null;
        String djId = StringUtils.EMPTY;
        if (ardBdcXm != null && StringUtils.isNoneBlank(ardBdcXm.getBdcdyh(), ardBdcXm.getBdclx())) {
            Map<String, String> djsjMap = bdcdyService.getDjsjBdcdy(ardBdcXm.getBdcdyh(), bdcZdGlService.parseNameToCode(ardBdcXm.getBdclx(), "BDCLX"));
            if (djsjMap != null && !djsjMap.isEmpty() && StringUtils.isNoneBlank(djsjMap.get("ID"))) {
                bdcBdcdy = bdcdyService.initDjBdcdy(djsjMap.get("ID"), ardBdcXm.getBdcdyh(), bdcZdGlService.parseNameToCode(ardBdcXm.getBdclx(), "BDCLX"), djsjMap.get("BDCDYFWLX"));
                djId = djsjMap.get("ID");
            }
            if (sfxnbdcdyh) {
                bdcBdcdy = bdcdyService.initBdcdy(ardBdcXm.getBdcdyh(), bdcZdGlService.parseNameToCode(ardBdcXm.getBdclx(), "BDCLX"), "", null);
                if (bdcBdcdy != null && StringUtils.isNoneBlank(bdcBdcdy.getBdcdyid())) {
                    bdcBdcdy.setDjbid(UUIDGenerator.generate18());
                    entityMapper.saveOrUpdate(bdcBdcdy, bdcBdcdy.getBdcdyid());
                }
            }
        }
        map.put("bdcdy", bdcBdcdy);
        map.put("djId", djId);
        return map;
    }

    private BdcXm initArdBdcXmInfo(ArdBdcXm ardBdcXm, BdcBdcdy bdcBdcdy, List<Object> list, String djId, List<Object> dataList) {
        BdcXm bdcXm = null;
        if (ardBdcXm != null && StringUtils.isNoneBlank(ardBdcXm.getYwh())) {
            Boolean flag = true;
            String yproid = StringUtils.EMPTY;
            String qllx = bdcZdGlService.parseNameToCode(ardBdcXm.getQllx(), "QLLX");
            if (StringUtils.equals(qllx, Constants.QLLX_CFDJ) || StringUtils.equals(qllx, Constants.QLLX_DYAQ)) {
                if (StringUtils.isNoneBlank(bdcBdcdy.getBdcdyh()) && StringUtils.length(bdcBdcdy.getBdcdyh()) == 28) {
                    String tempQllx = ReadXmlProps.getQllx(StringUtils.substring(bdcBdcdy.getBdcdyh(), 12, 14), StringUtils.substring(bdcBdcdy.getBdcdyh(), 19, 20));
                    if (StringUtils.isNoneBlank(tempQllx)) {
                        QllxVo qllxVo = qllxService.queryQllxVoByBdcdyh(bdcBdcdy.getBdcdyh(), tempQllx);
                        if (qllxVo != null) {
                            yproid = qllxVo.getProid();
                        } else {
                            flag = false;
                        }
                    }
                }
            }
            if (flag) {
                bdcXm = bdcXmService.createBdcXm();
                if (bdcXm != null && StringUtils.isNoneBlank(bdcXm.getProid())) {
                    bdcXm.setQllx(bdcZdGlService.parseNameToCode(ardBdcXm.getQllx(), "QLLX"));
                    bdcXm.setBdclx(bdcZdGlService.parseNameToCode(ardBdcXm.getBdclx(), "BDCLX"));
                    bdcXm.setDjlx(bdcZdGlService.parseNameToCode(ardBdcXm.getDjlx(), "DJLX"));
                    bdcXm.setSqlx(bdcZdGlService.parseNameToCode(ardBdcXm.getSqlx(), "SQLX"));
                    bdcXm.setDjyy(ardBdcXm.getDjyy());
                    bdcXm.setSqzsbs(ardBdcXm.getSqzsbs());
                    bdcXm.setSqfbcz(ardBdcXm.getSqfbcz());
                    bdcXm.setBz(ardBdcXm.getBz());
                    bdcXm.setSqrsm(ardBdcXm.getSqrsm());
                    bdcXm.setDwdm(ardBdcXm.getDwdm());
                    bdcXm.setCjsj(ardBdcXm.getCjsj());
                    bdcXm.setCjr(ardBdcXm.getCjr());
                    bdcXm.setBjsj(ardBdcXm.getBjsj());
                    bdcXm.setLsh(ardBdcXm.getLsh());
                    bdcXm.setNf(ardBdcXm.getNf());
                    bdcXm.setXmmc(ardBdcXm.getXmmc());
                    bdcXm.setDjsy(bdcZdGlService.parseNameToCode(ardBdcXm.getDjsy(), "DJSY"));
                    bdcXm.setDydjlx(bdcZdGlService.parseNameToCode(ardBdcXm.getDydjlx(), "DJLX"));
                    bdcXm.setZl(ardBdcXm.getZl());
                    bdcXm.setYbdcqzh(ardBdcXm.getYbdcqzh());
                    bdcXm.setCqgs(ardBdcXm.getCqgs());
                    bdcXm.setDjjg(ardBdcXm.getDjjg());
                    bdcXm.setBdcdyid(bdcBdcdy.getBdcdyid());
                    dataList.add(bdcXm);
                    BdcXmRel bdcXmRel = new BdcXmRel();
                    bdcXmRel.setRelid(UUIDGenerator.generate18());
                    bdcXmRel.setProid(bdcXm.getProid());
                    bdcXmRel.setQjid(djId);
                    bdcXmRel.setYdjxmly(Constants.XMLY_BDC);
                    bdcXmRel.setYproid(yproid);
                    dataList.add(bdcXmRel);
                    BdcSpxx bdcSpxx = new BdcSpxx();
                    bdcSpxx.setSpxxid(UUIDGenerator.generate18());
                    bdcSpxx.setProid(bdcXm.getProid());
                    bdcSpxx.setMj(ardBdcXm.getMj());
                    bdcSpxx.setZl(ardBdcXm.getZl());
                    bdcSpxx.setYt(bdcZdGlService.parseNameToCode(ardBdcXm.getYt(), "FWYT"));
                    bdcSpxx.setYhlx(bdcZdGlService.parseNameToCode(ardBdcXm.getYhlx(), "YHLX"));
                    bdcSpxx.setYhlxb(bdcZdGlService.parseNameToCode(ardBdcXm.getYhlxb(), "YHLX"));
                    bdcSpxx.setGzwlx(bdcZdGlService.parseNameToCode(ardBdcXm.getGzwlx(), "GJZWLX"));
                    bdcSpxx.setLz(bdcZdGlService.parseNameToCode(ardBdcXm.getLz(), "LZ"));
                    bdcSpxx.setMjdw(bdcZdGlService.parseNameToCode(ardBdcXm.getMjdw(), "MJDW"));
                    if (StringUtils.indexOf(bdcXm.getBdclx(), Constants.BDCLX_HY) >= 0) {
                        bdcSpxx.setZdzhyt(bdcZdGlService.parseNameToCode(ardBdcXm.getZdzhyt(), "HDYT"));
                        bdcSpxx.setZdzhyt2(bdcZdGlService.parseNameToCode(ardBdcXm.getZdzhyt2(), "HDYT"));
                        bdcSpxx.setZdzhyt3(bdcZdGlService.parseNameToCode(ardBdcXm.getZdzhyt3(), "HDYT"));
                    } else {
                        bdcSpxx.setZdzhyt(bdcZdGlService.parseNameToCode(ardBdcXm.getZdzhyt(), "DLDM"));
                        bdcSpxx.setZdzhyt2(bdcZdGlService.parseNameToCode(ardBdcXm.getZdzhyt2(), "DLDM"));
                        bdcSpxx.setZdzhyt3(bdcZdGlService.parseNameToCode(ardBdcXm.getZdzhyt3(), "DLDM"));
                    }
                    bdcSpxx.setZdzhqlxz(bdcZdGlService.parseNameToCode(ardBdcXm.getZdzhqlxz(), "QLXZ"));
                    bdcSpxx.setYt2(bdcZdGlService.parseNameToCode(ardBdcXm.getYt2(), "FWYT"));
                    bdcSpxx.setYt3(bdcZdGlService.parseNameToCode(ardBdcXm.getYt3(), "FWYT"));
                    bdcSpxx.setBdclx(bdcZdGlService.parseNameToCode(ardBdcXm.getBdclx(), "BDCLX"));
                    bdcSpxx.setBdcdyh(bdcBdcdy.getBdcdyh());
                    bdcSpxx.setZdzhmj(ardBdcXm.getZdzhmj());
                    bdcSpxx.setYhspdw(ardBdcXm.getYhspdw());
                    bdcSpxx.setPzwh(ardBdcXm.getPzwh());
                    dataList.add(bdcSpxx);
                }
            }
        }
        return bdcXm;
    }

    private QllxVo initArdQllxVoInfo(ArdBdcXm ardBdcXm, BdcXm bdcXm, List<Object> list, List<Object> dataList, String type) {
        QllxVo qllxVo = qllxService.newQllxVo(bdcXm, bdcXm.getBdcdyid(), null);
        if (qllxVo != null) {
            qllxVo.setQlid(UUIDGenerator.generate18());
            qllxVo.setProid(bdcXm.getProid());
            qllxVo.setBdcdyid(bdcXm.getBdcdyid());
            qllxVo.setQllx(bdcXm.getQllx());
            qllxVo.setYwh(bdcXm.getBh());
            if (!(StringUtils.equals(bdcXm.getQllx(), Constants.QLLX_DYAQ) || StringUtils.equals(bdcXm.getQllx(), Constants.QLLX_CFDJ))) {
                if (StringUtils.equals(type, "HY")) {
                    for (Object object : list) {
                        if (object != null && object instanceof ArdBdcHysyq && qllxVo instanceof BdcHysyq) {
                            ArdBdcHysyq ardBdcHysyq = (ArdBdcHysyq) object;
                            BdcHysyq bdcHysyq = (BdcHysyq) qllxVo;
                            bdcHysyq.setXmmc(ardBdcHysyq.getXmmc());
                            bdcHysyq.setDjsj(ardBdcHysyq.getDjsj());
                            bdcHysyq.setDbr(ardBdcHysyq.getDbr());
                            bdcHysyq.setQlqssj(ardBdcHysyq.getQlqssj());
                            bdcHysyq.setQljssj(ardBdcHysyq.getQljssj());
                            bdcHysyq.setSyksqx(ardBdcHysyq.getSyksqx());
                            bdcHysyq.setSyjsqx(ardBdcHysyq.getSyjsqx());
                            bdcHysyq.setSyjjnqk(ardBdcHysyq.getSyjjnqk());
                            bdcHysyq.setSyzje(ardBdcHysyq.getSyzje());
                            bdcHysyq.setSyjyj(ardBdcHysyq.getSyjyj());
                            bdcHysyq.setSyqmj(ardBdcHysyq.getSyqmj());
                            bdcHysyq.setFj(ardBdcHysyq.getFj());
                            dataList.add(bdcHysyq);
                        }
                    }
                }
                if (StringUtils.equals(type, "LM")) {
                    for (Object object : list) {
                        if (object != null && object instanceof ArdBdcLq && qllxVo instanceof BdcLq) {
                            ArdBdcLq ardBdcLq = (ArdBdcLq) object;
                            BdcLq bdcLq = (BdcLq) qllxVo;
                            bdcLq.setDjsj(ardBdcLq.getDjsj());
                            bdcLq.setDbr(ardBdcLq.getDbr());
                            bdcLq.setQlqssj(ardBdcLq.getQlqssj());
                            bdcLq.setQljssj(ardBdcLq.getQljssj());
                            bdcLq.setSyqmj(ardBdcLq.getSyqmj());
                            bdcLq.setLdsyksqx(ardBdcLq.getLdsyksqx());
                            bdcLq.setLdsyjsqx(ardBdcLq.getLdsyjsqx());
                            bdcLq.setFbfmc(ardBdcLq.getFbfmc());
                            bdcLq.setZysz(ardBdcLq.getZysz());
                            if (ardBdcLq.getZs() != null) {
                                bdcLq.setZs(ardBdcLq.getZs());
                            }
                            bdcLq.setLz(bdcZdGlService.parseNameToCode(ardBdcLq.getLz(), "LZ"));
                            bdcLq.setQy(bdcZdGlService.parseNameToCode(ardBdcLq.getQy(), "QY"));
                            bdcLq.setZlnd(ardBdcLq.getZlnd());
                            bdcLq.setXdm(ardBdcLq.getXdm());
                            bdcLq.setLb(ardBdcLq.getLb());
                            bdcLq.setXb(ardBdcLq.getXb());
                            bdcLq.setLdsyqxz(ardBdcLq.getLdsyqxz());
                            bdcLq.setLmsyqr(ardBdcLq.getLmsyqr());
                            bdcLq.setLmsuqr(ardBdcLq.getLmsuqr());
                            bdcLq.setFj(ardBdcLq.getFj());
                            dataList.add(bdcLq);
                        }
                    }
                }
                if (StringUtils.equals(type, "CD") && StringUtils.equals(type, "NYD")) {
                    for (Object object : list) {
                        if (object != null && object instanceof ArdBdcTdcbnydsyq && qllxVo instanceof BdcTdcbnydsyq) {
                            ArdBdcTdcbnydsyq ardBdcTdcbnydsyq = (ArdBdcTdcbnydsyq) object;
                            BdcTdcbnydsyq bdcTdcbnydsyq = (BdcTdcbnydsyq) qllxVo;
                            bdcTdcbnydsyq.setDjsj(ardBdcTdcbnydsyq.getDjsj());
                            bdcTdcbnydsyq.setDbr(ardBdcTdcbnydsyq.getDbr());
                            bdcTdcbnydsyq.setQlqssj(ardBdcTdcbnydsyq.getQlqssj());
                            bdcTdcbnydsyq.setQljssj(ardBdcTdcbnydsyq.getQljssj());
                            bdcTdcbnydsyq.setSyksqx(ardBdcTdcbnydsyq.getSyksqx());
                            bdcTdcbnydsyq.setSyjsqx(ardBdcTdcbnydsyq.getSyjsqx());
                            bdcTdcbnydsyq.setSyttlx(ardBdcTdcbnydsyq.getSyttlx());
                            bdcTdcbnydsyq.setYzyfs(ardBdcTdcbnydsyq.getYzyfs());
                            bdcTdcbnydsyq.setCyzl(ardBdcTdcbnydsyq.getCyzl());
                            if (ardBdcTdcbnydsyq.getSyzcl() != null) {
                                bdcTdcbnydsyq.setSyzcl(ardBdcTdcbnydsyq.getSyzcl());
                            }
                            bdcTdcbnydsyq.setTdsyqxz(ardBdcTdcbnydsyq.getTdsyqxz());
                            bdcTdcbnydsyq.setFbfmc(ardBdcTdcbnydsyq.getFbfmc());
                            bdcTdcbnydsyq.setQdcbfs(ardBdcTdcbnydsyq.getQdcbfs());
                            bdcTdcbnydsyq.setCcgd(ardBdcTdcbnydsyq.getCcgd());
                            bdcTdcbnydsyq.setCdysz(ardBdcTdcbnydsyq.getCdysz());
                            bdcTdcbnydsyq.setCdjq(ardBdcTdcbnydsyq.getCdjq());
                            bdcTdcbnydsyq.setCdfgd(ardBdcTdcbnydsyq.getCdfgd());
                            bdcTdcbnydsyq.setFj(ardBdcTdcbnydsyq.getFj());
                            dataList.add(bdcTdcbnydsyq);
                        }
                    }
                }
            } else if (StringUtils.equals(bdcXm.getQllx(), Constants.QLLX_DYAQ)) {
                for (Object object : list) {
                    if (object != null && object instanceof ArdBdcDyaq && qllxVo instanceof BdcDyaq) {
                        ArdBdcDyaq ardBdcDyaq = (ArdBdcDyaq) object;
                        BdcDyaq bdcDyaq = (BdcDyaq) qllxVo;
                        bdcDyaq.setDjsj(ardBdcDyaq.getDjsj());
                        bdcDyaq.setDbr(ardBdcDyaq.getDbr());
                        bdcDyaq.setZwlxksqx(ardBdcDyaq.getZwlxksqx());
                        bdcDyaq.setZwlxjsqx(ardBdcDyaq.getZwlxjsqx());
                        bdcDyaq.setZgzqqdss(ardBdcDyaq.getZgzqqdss());
                        bdcDyaq.setZgzqqdse(ardBdcDyaq.getZgzqqdse());
                        bdcDyaq.setBdbzzqse(ardBdcDyaq.getBdbzzqse());
                        bdcDyaq.setDbfw(ardBdcDyaq.getDbfw());
                        bdcDyaq.setSfgtdb(ardBdcDyaq.getSfgtdb());
                        bdcDyaq.setDw(ardBdcDyaq.getDw());
                        bdcDyaq.setZwr(ardBdcDyaq.getZwr());
                        bdcDyaq.setDyhtbh(ardBdcDyaq.getDyhtbh());
                        bdcDyaq.setYsxkzmh(ardBdcDyaq.getYsxkzmh());
                        if (ardBdcDyaq.getDysw() != null) {
                            bdcDyaq.setDysw(ardBdcDyaq.getDysw());
                        }
                        bdcDyaq.setDkfs(bdcZdGlService.parseNameToCode(ardBdcDyaq.getDkfs(), "DKFS"));
                        bdcDyaq.setDyfs(bdcZdGlService.parseNameToCode(ardBdcDyaq.getDyfs(), "DYFS"));
                        bdcDyaq.setJezl(bdcZdGlService.parseNameToCode(ardBdcDyaq.getJezl(), "JEZL"));
                        bdcDyaq.setQt(ardBdcDyaq.getQt());
                        bdcDyaq.setFj(ardBdcDyaq.getFj());
                        dataList.add(bdcDyaq);
                    }
                }
            } else if (StringUtils.equals(bdcXm.getQllx(), Constants.QLLX_CFDJ)) {
                for (Object object : list) {
                    if (object != null && object instanceof ArdBdcCf && qllxVo instanceof BdcCf) {
                        ArdBdcCf ardBdcCf = (ArdBdcCf) object;
                        BdcCf bdcCf = (BdcCf) qllxVo;
                        bdcCf.setDjsj(ardBdcCf.getDjsj());
                        bdcCf.setDbr(ardBdcCf.getDbr());
                        bdcCf.setCfsqr(ardBdcCf.getCfsqr());
                        bdcCf.setZxsqr(ardBdcCf.getZxsqr());
                        bdcCf.setBzxr(ardBdcCf.getBzxr());
                        bdcCf.setCflx(bdcZdGlService.parseNameToCode(ardBdcCf.getCflx(), "CFLX"));
                        bdcCf.setCfjg(ardBdcCf.getCfjg());
                        bdcCf.setCfwh(ardBdcCf.getCfwh());
                        bdcCf.setCfwj(ardBdcCf.getCfwj());
                        bdcCf.setCffw(ardBdcCf.getCffw());
                        bdcCf.setCfyy(ardBdcCf.getCfyy());
                        bdcCf.setCfsj(ardBdcCf.getCfsj());
                        bdcCf.setCfksqx(ardBdcCf.getCfksqx());
                        bdcCf.setCfjsqx(ardBdcCf.getCfjsqx());
                        if (ardBdcCf.getLhsx() != null) {
                            bdcCf.setLhsx(ardBdcCf.getLhsx());
                        }
                        bdcCf.setLhcfqx(ardBdcCf.getLhcfqx());
                        bdcCf.setFysdr(ardBdcCf.getFysdr());
                        bdcCf.setFysdrzjhm(ardBdcCf.getFysdrzjhm());
                        bdcCf.setFysdrlxfs(ardBdcCf.getFysdrlxfs());
                        bdcCf.setFj(ardBdcCf.getFj());
                        bdcCf.setBz(ardBdcCf.getBz());
                        dataList.add(bdcCf);
                    }
                }
            }
        }
        return qllxVo;
    }

    private List<BdcQlr> initArdBdcQlrInfo(BdcXm bdcXm, List<Object> list, List<Object> dataList) {
        List<BdcQlr> bdcQlrList = Lists.newArrayList();
        for (Object object : list) {
            if (object != null && object instanceof ArdBdcQlr) {
                ArdBdcQlr ardBdcQlr = (ArdBdcQlr) object;
                BdcQlr bdcQlr = new BdcQlr();
                bdcQlr.setProid(bdcXm.getProid());
                bdcQlr.setQlrid(UUIDGenerator.generate18());
                bdcQlr.setQlrmc(ardBdcQlr.getQlrmc());
                bdcQlr.setQlrsfzjzl(bdcZdGlService.parseNameToCode(ardBdcQlr.getQlrsfzjzl(), "ZJLX"));
                bdcQlr.setQlrzjh(ardBdcQlr.getQlrzjh());
                bdcQlr.setQlrtxdz(ardBdcQlr.getQlrtxdz());
                bdcQlr.setQlryb(ardBdcQlr.getQlryb());
                bdcQlr.setQlrlxdh(ardBdcQlr.getQlrlxdh());
                bdcQlr.setQlrfddbr(ardBdcQlr.getQlrfddbr());
                bdcQlr.setQlrfddbrdh(ardBdcQlr.getQlrfddbrdh());
                bdcQlr.setQlrdlr(ardBdcQlr.getQlrdlr());
                bdcQlr.setQlrdlrzjzl(bdcZdGlService.parseNameToCode(ardBdcQlr.getQlrdlrzjzl(), "ZJLX"));
                bdcQlr.setQlrdlrzjh(ardBdcQlr.getQlrdlrzjh());
                bdcQlr.setQlrdlrdh(ardBdcQlr.getQlrdlrdh());
                bdcQlr.setQlrdljg(ardBdcQlr.getQlrdljg());
                bdcQlr.setQlbl(ardBdcQlr.getQlbl());
                bdcQlr.setGyqk(bdcZdGlService.parseNameToCode(ardBdcQlr.getGyqk(), "GYFS"));
                bdcQlr.setQlrxz(bdcZdGlService.parseNameToCode(ardBdcQlr.getQlrxz(), "QLRXZ"));
                bdcQlr.setSshy(ardBdcQlr.getSshy());
                bdcQlr.setBz(ardBdcQlr.getBz());
                bdcQlr.setSfczr((StringUtils.equals(ardBdcQlr.getSfczr(), "是") ? "1" : "0"));
                if (ardBdcQlr.getSxh() != null) {
                    bdcQlr.setSxh(ardBdcQlr.getSxh());
                }
                bdcQlr.setXb(ardBdcQlr.getXb());
                bdcQlr.setQygyr(ardBdcQlr.getQygyr());
                bdcQlr.setQlrlx(bdcZdGlService.parseNameToCode(ardBdcQlr.getQlrlx(), "QLRLX"));
                dataList.add(bdcQlr);
                if (StringUtils.equals(bdcQlr.getQlrlx(), Constants.QLRLX_QLR)) {
                    bdcQlrList.add(bdcQlr);
                }
            }
        }
        return bdcQlrList;
    }

    private void initArdBdcZsInfo(ArdBdcXm ardBdcXm, BdcXm bdcXm, List<BdcQlr> bdcQlrList, List<Object> list, List<Object> dataList) {
        List<BdcZs> bdcZsList = Lists.newArrayList();
        for (Object object : list) {
            if (object != null && object instanceof ArdBdcZs) {
                ArdBdcZs ardBdcZs = (ArdBdcZs) object;
                BdcZs bdcZs = new BdcZs();
                bdcZs.setZsid(UUIDGenerator.generate18());
                bdcZs.setZslx(bdcXm.getQllx());
                if (StringUtils.equals(bdcXm.getQllx(), Constants.QLLX_DYAQ)) {
                    bdcZs.setZstype(Constants.BDCQZM_BH_FONT);
                } else {
                    bdcZs.setZstype(Constants.BDCQZS_BH_FONT);
                }
                bdcZs.setBdcqzh(ardBdcZs.getBdcqzh());
                bdcZs.setZhlsh(ardBdcZs.getZhlsh());
                bdcZs.setNf(ardBdcZs.getNf());
                bdcZs.setCzr(ardBdcZs.getCzr());
                bdcZs.setCzrq(ardBdcZs.getCzrq());
                bdcZs.setBh(ardBdcZs.getBh());
                bdcZs.setQlqtzk(ardBdcZs.getQlqtzk());
                bdcZs.setFj(ardBdcZs.getFj());
                bdcZs.setDwdm(ardBdcZs.getDwdm());
                bdcZs.setSqsjc(ardBdcZs.getSqsjc());
                bdcZs.setSzsxqc(ardBdcZs.getSzsxqc());
                bdcZs.setFzr(ardBdcZs.getFzr());
                bdcZs.setFzrq(ardBdcZs.getFzrq());
                bdcZs.setSzr(ardBdcZs.getSzr());
                bdcZs.setSzrq(ardBdcZs.getSzrq());
                bdcZs.setLzr(ardBdcZs.getLzr());
                bdcZs.setLzrzjzl(ardBdcZs.getLzrzjzl());
                bdcZs.setLzrzjh(ardBdcZs.getLzrzjh());
                bdcZs.setLzrq(ardBdcZs.getLzrq());
                bdcZs.setZmqlsx(ardBdcZs.getZmqlsx());
                bdcZs.setQllx(bdcXm.getQllx());
                dataList.add(bdcZs);
                bdcZsList.add(bdcZs);
            }
        }
        if (CollectionUtils.isNotEmpty(bdcZsList) && CollectionUtils.isNotEmpty(bdcQlrList) && CollectionUtils.size(bdcZsList) == CollectionUtils.size(bdcQlrList) && StringUtils.equals(bdcXm.getSqfbcz(), "是")) {
            for (BdcZs bdcZs : bdcZsList) {
                for (BdcQlr bdcQlr : bdcQlrList) {
                    if (StringUtils.equals(bdcZs.getCzr(), bdcQlr.getQlrmc())) {
                        BdcZsQlrRel bdcZsQlrRel = initBdcZsQlrRel(bdcZs, bdcQlr);
                        dataList.add(bdcZsQlrRel);
                    }
                }
            }
        } else if (CollectionUtils.isNotEmpty(bdcZsList) && CollectionUtils.isNotEmpty(bdcQlrList)) {
            for (BdcZs bdcZs : bdcZsList) {
                for (BdcQlr bdcQlr : bdcQlrList) {
                    BdcZsQlrRel bdcZsQlrRel = initBdcZsQlrRel(bdcZs, bdcQlr);
                    dataList.add(bdcZsQlrRel);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(bdcZsList) && bdcXm != null) {
            for (BdcZs bdcZs : bdcZsList) {
                BdcXmzsRel bdcXmzsRel = new BdcXmzsRel();
                bdcXmzsRel.setXmzsgxid(UUIDGenerator.generate18());
                bdcXmzsRel.setProid(bdcXm.getProid());
                bdcXmzsRel.setZsid(bdcZs.getZsid());
                dataList.add(bdcXmzsRel);
            }
        }
    }

    private BdcZsQlrRel initBdcZsQlrRel(BdcZs bdcZs, BdcQlr bdcQlr) {
        BdcZsQlrRel bdcZsQlrRel = new BdcZsQlrRel();
        bdcZsQlrRel.setGxid(UUIDGenerator.generate18());
        bdcZsQlrRel.setQlrid(bdcQlr.getQlrid());
        bdcZsQlrRel.setZsid(bdcZs.getZsid());
        return bdcZsQlrRel;
    }

}
