package cn.gtmap.estateplat.config.model;

import cn.gtmap.estateplat.config.utils.ArdExcelUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

import java.util.Date;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/9/7
 * @description
 */
public class ArdBdcCf implements ArdInfo {

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 业务号
     */
    private String ywh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 登记时间
     */
    private Date djsj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 登簿人
     */
    private String dbr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 查封申请人
     */
    private String cfsqr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 执行申请人
     */
    private String zxsqr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 被执行人
     */
    private String bzxr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 查封类型
     */
    private String cflx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 查封机关
     */
    private String cfjg;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 查封文号
     */
    private String cfwh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 查封文件
     */
    private String cfwj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 查封范围
     */
    private String cffw;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 查封原因
     */
    private String cfyy;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 查封时间
     */
    private Date cfsj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 查封开始期限
     */
    private Date cfksqx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 查封结束期限
     */
    private Date cfjsqx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 轮候顺序
     */
    private Integer lhsx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 轮候查封期限
     */
    private String lhcfqx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 法院送达人
     */
    private String fysdr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 法院送达人证件号码
     */
    private String fysdrzjhm;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 法院送达人联系方式
     */
    private String fysdrlxfs;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 附记
     */
    private String fj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 备注
     */
    private String bz;

    private ArdBdcCf(Row row, int lineNum) {
        boolean ywhFlag = false;
        boolean djsjFlag = false;
        boolean dbrFlag = false;
        boolean cfsqrFlag = false;
        boolean zxsqrFlag = false;
        boolean bzxrFlag = false;
        boolean cflxFlag = false;
        boolean cfjgFlag = false;
        boolean cfwhFlag = false;
        boolean cfwjFlag = false;
        boolean cffwFlag = false;
        boolean cfyyFlag = false;
        boolean cfsjFlag = false;
        boolean cfjsqxFlag = false;
        boolean cfksqxFlag = false;
        boolean lhsxFlag = false;
        boolean lhcfqxFlag = false;
        boolean fysdrFlag = false;
        boolean fysdrzjhmFlag = false;
        boolean fysdrlxfsFlag = false;
        boolean fjFlag = false;
        boolean bzFlag = false;
        Cell currentCell;
        for (int i = 0; i < lineNum; i++) {
            currentCell = row.getCell(i);
            if (StringUtils.isBlank(this.getYwh()) && !ywhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYwh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                ywhFlag = true;
                continue;
            }
            if (this.getDjsj() == null && !djsjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDjsj(currentCell.getDateCellValue());
                }
                djsjFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDbr()) && !dbrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDbr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                dbrFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getCfsqr()) && !cfsqrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setCfsqr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                cfsqrFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getZxsqr()) && !zxsqrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZxsqr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                zxsqrFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getBzxr()) && !bzxrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setBzxr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                bzxrFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getCflx()) && !cflxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setCflx(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                cflxFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getCfjg()) && !cfjgFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setCfjg(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                cfjgFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getCfwh()) && !cfwhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setCfwh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                cfwhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getCfwj()) && !cfwjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setCfwj(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                cfwjFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getCffw()) && !cffwFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setCffw(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                cffwFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getCfyy()) && !cfyyFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setCfyy(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                cfyyFlag = true;
                continue;
            }
            if (this.getCfsj() == null && !cfsjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setCfsj(currentCell.getDateCellValue());
                }
                cfsjFlag = true;
                continue;
            }
            if (this.getCfksqx() == null && !cfksqxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setCfksqx(currentCell.getDateCellValue());
                }
                cfksqxFlag = true;
                continue;
            }
            if (this.getCfjsqx() == null && !cfjsqxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setCfjsqx(currentCell.getDateCellValue());
                }
                cfjsqxFlag = true;
                continue;
            }
            if (this.getLhsx() == null && !lhsxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLhsx(Integer.parseInt(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell))));
                }
                lhsxFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getLhcfqx()) && !lhcfqxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLhcfqx(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                lhcfqxFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getFysdr()) && !fysdrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setFysdr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                fysdrFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getFysdrzjhm()) && !fysdrzjhmFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setFysdrzjhm(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                fysdrzjhmFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getFysdrlxfs()) && !fysdrlxfsFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setFysdrlxfs(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                fysdrlxfsFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getFj()) && !fjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setFj(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                fjFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getBz()) && !bzFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setBz(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                bzFlag = true;
            }
        }
    }

    public static ArdBdcCf initArdBdcCf(Row row, int lineNum) {
        return new ArdBdcCf(row, lineNum);
    }

    @Override
    public String getYwh() {
        return ywh;
    }

    @Override
    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    public String getCfsqr() {
        return cfsqr;
    }

    public void setCfsqr(String cfsqr) {
        this.cfsqr = cfsqr;
    }

    public String getZxsqr() {
        return zxsqr;
    }

    public void setZxsqr(String zxsqr) {
        this.zxsqr = zxsqr;
    }

    public String getBzxr() {
        return bzxr;
    }

    public void setBzxr(String bzxr) {
        this.bzxr = bzxr;
    }

    public String getCflx() {
        return cflx;
    }

    public void setCflx(String cflx) {
        this.cflx = cflx;
    }

    public String getCfjg() {
        return cfjg;
    }

    public void setCfjg(String cfjg) {
        this.cfjg = cfjg;
    }

    public String getCfwh() {
        return cfwh;
    }

    public void setCfwh(String cfwh) {
        this.cfwh = cfwh;
    }

    public String getCfwj() {
        return cfwj;
    }

    public void setCfwj(String cfwj) {
        this.cfwj = cfwj;
    }

    public String getCffw() {
        return cffw;
    }

    public void setCffw(String cffw) {
        this.cffw = cffw;
    }

    public String getCfyy() {
        return cfyy;
    }

    public void setCfyy(String cfyy) {
        this.cfyy = cfyy;
    }

    public Date getCfsj() {
        return cfsj;
    }

    public void setCfsj(Date cfsj) {
        this.cfsj = cfsj;
    }

    public Date getCfksqx() {
        return cfksqx;
    }

    public void setCfksqx(Date cfksqx) {
        this.cfksqx = cfksqx;
    }

    public Date getCfjsqx() {
        return cfjsqx;
    }

    public void setCfjsqx(Date cfjsqx) {
        this.cfjsqx = cfjsqx;
    }

    public Integer getLhsx() {
        return lhsx;
    }

    public void setLhsx(Integer lhsx) {
        this.lhsx = lhsx;
    }

    public String getLhcfqx() {
        return lhcfqx;
    }

    public void setLhcfqx(String lhcfqx) {
        this.lhcfqx = lhcfqx;
    }

    public String getFysdr() {
        return fysdr;
    }

    public void setFysdr(String fysdr) {
        this.fysdr = fysdr;
    }

    public String getFysdrzjhm() {
        return fysdrzjhm;
    }

    public void setFysdrzjhm(String fysdrzjhm) {
        this.fysdrzjhm = fysdrzjhm;
    }

    public String getFysdrlxfs() {
        return fysdrlxfs;
    }

    public void setFysdrlxfs(String fysdrlxfs) {
        this.fysdrlxfs = fysdrlxfs;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    @Override
    public String toString() {
        return "ArdBdcCf{" +
                "ywh='" + ywh + '\'' +
                ", djsj=" + djsj +
                ", dbr='" + dbr + '\'' +
                ", cfsqr='" + cfsqr + '\'' +
                ", zxsqr='" + zxsqr + '\'' +
                ", bzxr='" + bzxr + '\'' +
                ", cflx='" + cflx + '\'' +
                ", cfjg='" + cfjg + '\'' +
                ", cfwh='" + cfwh + '\'' +
                ", cfwj='" + cfwj + '\'' +
                ", cffw='" + cffw + '\'' +
                ", cfyy='" + cfyy + '\'' +
                ", cfsj=" + cfsj +
                ", cfksqx=" + cfksqx +
                ", cfjsqx=" + cfjsqx +
                ", lhsx=" + lhsx +
                ", lhcfqx='" + lhcfqx + '\'' +
                ", fysdr='" + fysdr + '\'' +
                ", fysdrzjhm='" + fysdrzjhm + '\'' +
                ", fysdrlxfs='" + fysdrlxfs + '\'' +
                ", fj='" + fj + '\'' +
                ", bz='" + bz + '\'' +
                '}';
    }
}
