package cn.gtmap.estateplat.config.model;

import cn.gtmap.estateplat.config.utils.ArdExcelUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

import java.util.Date;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/9/7
 * @description
 */
public class ArdBdcDyaq implements ArdInfo {

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 业务号
     */
    private String ywh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 登记时间
     */
    private Date djsj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 登簿人
     */
    private String dbr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 债务履行开始期限
     */
    private Date zwlxksqx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 债务履行结束期限
     */
    private Date zwlxjsqx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 最高债权确定事实
     */
    private String zgzqqdss;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 最高债权确定数额
     */
    private Double zgzqqdse;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 被担保主债权数额
     */
    private Double bdbzzqse;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 担保范围
     */
    private String dbfw;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 是否共同担保
     */
    private String sfgtdb;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 单位
     */
    private String dw;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 债务人
     */
    private String zwr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 抵押合同编号
     */
    private String dyhtbh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 预售许可证明号
     */
    private String ysxkzmh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 抵押顺位
     */
    private Integer dysw;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 贷款方式
     */
    private String dkfs;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 抵押方式
     */
    private String dyfs;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 金额种类
     */
    private String jezl;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 其他
     */
    private String qt;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 附记
     */
    private String fj;

    private ArdBdcDyaq(Row row, int lineNum) {
        boolean ywhFlag = false;
        boolean djsjFlag = false;
        boolean dbrFlag = false;
        boolean zwlxksqxFlag = false;
        boolean zwlxjsqxFlag = false;
        boolean zgzqqdssFlag = false;
        boolean zgzqqdseFlag = false;
        boolean bdbzzqseFlag = false;
        boolean dbfwFlag = false;
        boolean sfgtdbFlag = false;
        boolean dwFlag = false;
        boolean zwrFlag = false;
        boolean dyhtbhFlag = false;
        boolean ysxkzmhFlag = false;
        boolean dyswFlag = false;
        boolean dkfsFlag = false;
        boolean dyfsFlag = false;
        boolean jezlFlag = false;
        boolean qtFlag = false;
        boolean fjFlag = false;
        Cell currentCell;
        for (int i = 0; i < lineNum; i++) {
            currentCell = row.getCell(i);
            if (StringUtils.isBlank(this.getYwh()) && !ywhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYwh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                ywhFlag = true;
                continue;
            }
            if (this.getDjsj() == null && !djsjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDjsj(currentCell.getDateCellValue());
                }
                djsjFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDbr()) && !dbrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDbr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                dbrFlag = true;
                continue;
            }
            if (this.getZwlxksqx() == null && !zwlxksqxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZwlxksqx(currentCell.getDateCellValue());
                }
                zwlxksqxFlag = true;
                continue;
            }
            if (this.getZwlxjsqx() == null && !zwlxjsqxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZwlxjsqx(currentCell.getDateCellValue());
                }
                zwlxjsqxFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getZgzqqdss()) && !zgzqqdssFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZgzqqdss(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                zgzqqdssFlag = true;
                continue;
            }
            if (this.getZgzqqdse() == null && !zgzqqdseFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZgzqqdse(Double.parseDouble(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell))));
                }
                zgzqqdseFlag = true;
                continue;
            }
            if (this.getBdbzzqse() == null && !bdbzzqseFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setBdbzzqse(Double.parseDouble(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell))));
                }
                bdbzzqseFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDbfw()) && !dbfwFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDbfw(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                dbfwFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getSfgtdb()) && !sfgtdbFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSfgtdb(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                sfgtdbFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDw()) && !dwFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDw(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                dwFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getZwr()) && !zwrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZwr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                zwrFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDyhtbh()) && !dyhtbhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDyhtbh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                dyhtbhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getYsxkzmh()) && !ysxkzmhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYsxkzmh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                ysxkzmhFlag = true;
                continue;
            }
            if (this.getDysw() == null && !dyswFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDysw(Integer.parseInt(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell))));
                }
                dyswFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDkfs()) && !dkfsFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDkfs(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                dkfsFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDyfs()) && !dyfsFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDyfs(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                dyfsFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getJezl()) && !jezlFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setJezl(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                    jezlFlag = true;
                    continue;
                }
            }
            if (StringUtils.isBlank(this.getQt()) && !qtFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQt(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qtFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getFj()) && !fjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setFj(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                fjFlag = true;
            }
        }
    }

    public static ArdBdcDyaq initArdBdcDyaq(Row row, int lineNum) {
        return new ArdBdcDyaq(row, lineNum);
    }

    @Override
    public String getYwh() {
        return ywh;
    }

    @Override
    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    public Date getZwlxksqx() {
        return zwlxksqx;
    }

    public void setZwlxksqx(Date zwlxksqx) {
        this.zwlxksqx = zwlxksqx;
    }

    public Date getZwlxjsqx() {
        return zwlxjsqx;
    }

    public void setZwlxjsqx(Date zwlxjsqx) {
        this.zwlxjsqx = zwlxjsqx;
    }

    public String getZgzqqdss() {
        return zgzqqdss;
    }

    public void setZgzqqdss(String zgzqqdss) {
        this.zgzqqdss = zgzqqdss;
    }

    public Double getZgzqqdse() {
        return zgzqqdse;
    }

    public void setZgzqqdse(Double zgzqqdse) {
        this.zgzqqdse = zgzqqdse;
    }

    public Double getBdbzzqse() {
        return bdbzzqse;
    }

    public void setBdbzzqse(Double bdbzzqse) {
        this.bdbzzqse = bdbzzqse;
    }

    public String getDbfw() {
        return dbfw;
    }

    public void setDbfw(String dbfw) {
        this.dbfw = dbfw;
    }

    public String getSfgtdb() {
        return sfgtdb;
    }

    public void setSfgtdb(String sfgtdb) {
        this.sfgtdb = sfgtdb;
    }

    public String getDw() {
        return dw;
    }

    public void setDw(String dw) {
        this.dw = dw;
    }

    public String getZwr() {
        return zwr;
    }

    public void setZwr(String zwr) {
        this.zwr = zwr;
    }

    public String getDyhtbh() {
        return dyhtbh;
    }

    public void setDyhtbh(String dyhtbh) {
        this.dyhtbh = dyhtbh;
    }

    public String getYsxkzmh() {
        return ysxkzmh;
    }

    public void setYsxkzmh(String ysxkzmh) {
        this.ysxkzmh = ysxkzmh;
    }

    public Integer getDysw() {
        return dysw;
    }

    public void setDysw(Integer dysw) {
        this.dysw = dysw;
    }

    public String getDkfs() {
        return dkfs;
    }

    public void setDkfs(String dkfs) {
        this.dkfs = dkfs;
    }

    public String getDyfs() {
        return dyfs;
    }

    public void setDyfs(String dyfs) {
        this.dyfs = dyfs;
    }

    public String getJezl() {
        return jezl;
    }

    public void setJezl(String jezl) {
        this.jezl = jezl;
    }

    public String getQt() {
        return qt;
    }

    public void setQt(String qt) {
        this.qt = qt;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @Override
    public String toString() {
        return "ArdBdcDyaq{" +
                "ywh='" + ywh + '\'' +
                ", djsj=" + djsj +
                ", dbr='" + dbr + '\'' +
                ", zwlxksqx=" + zwlxksqx +
                ", zwlxjsqx=" + zwlxjsqx +
                ", zgzqqdss='" + zgzqqdss + '\'' +
                ", zgzqqdse=" + zgzqqdse +
                ", bdbzzqse=" + bdbzzqse +
                ", dbfw='" + dbfw + '\'' +
                ", sfgtdb='" + sfgtdb + '\'' +
                ", dw='" + dw + '\'' +
                ", zwr='" + zwr + '\'' +
                ", dyhtbh='" + dyhtbh + '\'' +
                ", ysxkzmh='" + ysxkzmh + '\'' +
                ", dysw=" + dysw +
                ", dkfs='" + dkfs + '\'' +
                ", dyfs='" + dyfs + '\'' +
                ", jezl='" + jezl + '\'' +
                ", qt='" + qt + '\'' +
                ", fj='" + fj + '\'' +
                '}';
    }
}
