package cn.gtmap.estateplat.config.model;

import cn.gtmap.estateplat.config.utils.ArdExcelUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/9/7
 * @description
 */
public class ArdBdcHysyq implements ArdInfo {

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 业务号
     */
    private String ywh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 项目名称
     */
    private String xmmc;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 登记时间
     */
    private Date djsj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 登簿人
     */
    private String dbr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利起始时间
     */
    private Date qlqssj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利结束时间
     */
    private Date qljssj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 使用开始期限
     */
    private Date syksqx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 使用结束期限
     */
    private Date syjsqx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 使用总金额
     */
    private Double syzje;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 使用金标准依据
     */
    private String syjyj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 使用金缴纳情况
     */
    private String syjjnqk;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 使用权面积
     */
    private Double syqmj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 附记
     */
    private String fj;

    private ArdBdcHysyq(Row row, int lineNum) {
        boolean ywhFlag = false;
        boolean xmmcFlag = false;
        boolean djsjFlag = false;
        boolean dbrFlag = false;
        boolean qlqssjFlag = false;
        boolean qljssjFlag = false;
        boolean syksqxFlag = false;
        boolean syjsqxFlag = false;
        boolean syzjeFlag = false;
        boolean syjyjFlag = false;
        boolean syjjnqkFlag = false;
        boolean syqmjFlag = false;
        boolean fjFlag = false;
        Cell currentCell;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < lineNum; i++) {
            currentCell = row.getCell(i);
            if (StringUtils.isBlank(this.getYwh()) && !ywhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYwh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                ywhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getXmmc()) && !xmmcFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setXmmc(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                xmmcFlag = true;
                continue;
            }
            if (this.getDjsj() == null && !djsjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    if (((HSSFCell) currentCell).getCellType() == 0) {
                        this.setDjsj(currentCell.getDateCellValue());
                    } else {
                        try {
                            this.setDjsj(sdf.parse(currentCell.getStringCellValue()));
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                }
                djsjFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDbr()) && !dbrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDbr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                dbrFlag = true;
                continue;
            }
            if (this.getQlqssj() == null && !qlqssjFlag) {
                if (((HSSFCell) currentCell).getCellType() == 0) {
                    this.setQlqssj(currentCell.getDateCellValue());
                } else {
                    try {
                        this.setQlqssj(sdf.parse(currentCell.getStringCellValue()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                qlqssjFlag = true;
                continue;
            }
            if (this.getQljssj() == null && !qljssjFlag) {
                if (((HSSFCell) currentCell).getCellType() == 0) {
                    this.setQljssj(currentCell.getDateCellValue());
                } else {
                    try {
                        this.setQljssj(sdf.parse(currentCell.getStringCellValue()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                qljssjFlag = true;
                continue;
            }
            if (this.getSyksqx() == null && !syksqxFlag) {
                if (((HSSFCell) currentCell).getCellType() == 0) {
                    this.setSyksqx(currentCell.getDateCellValue());
                } else {
                    try {
                        this.setSyksqx(sdf.parse(currentCell.getStringCellValue()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                syksqxFlag = true;
                continue;
            }
            if (this.getSyjsqx() == null && !syjsqxFlag) {
                if (((HSSFCell) currentCell).getCellType() == 0) {
                    this.setSyjsqx(currentCell.getDateCellValue());
                } else {
                    try {
                        this.setSyjsqx(sdf.parse(currentCell.getStringCellValue()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                syjsqxFlag = true;
                continue;
            }
            if (this.getSyzje() == null && !syzjeFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSyzje(Double.parseDouble(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell))));
                }
                syzjeFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getSyjyj()) && !syjyjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSyjyj(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                syjyjFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getSyjjnqk()) && !syjjnqkFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSyjjnqk(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                syjjnqkFlag = true;
                continue;
            }
            if (this.getSyqmj() == null && !syqmjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSyqmj(Double.parseDouble(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell))));
                }
                syqmjFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getFj()) && !fjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setFj(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                fjFlag = true;
            }
        }
    }

    public static ArdBdcHysyq initArdBdcHysyq(Row row, int lineNum) {
        return new ArdBdcHysyq(row, lineNum);
    }

    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    public String getXmmc() {
        return xmmc;
    }

    public void setXmmc(String xmmc) {
        this.xmmc = xmmc;
    }

    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    public Date getQlqssj() {
        return qlqssj;
    }

    public void setQlqssj(Date qlqssj) {
        this.qlqssj = qlqssj;
    }

    public Date getQljssj() {
        return qljssj;
    }

    public void setQljssj(Date qljssj) {
        this.qljssj = qljssj;
    }

    public Date getSyksqx() {
        return syksqx;
    }

    public void setSyksqx(Date syksqx) {
        this.syksqx = syksqx;
    }

    public Date getSyjsqx() {
        return syjsqx;
    }

    public void setSyjsqx(Date syjsqx) {
        this.syjsqx = syjsqx;
    }

    public Double getSyzje() {
        return syzje;
    }

    public void setSyzje(Double syzje) {
        this.syzje = syzje;
    }

    public String getSyjyj() {
        return syjyj;
    }

    public void setSyjyj(String syjyj) {
        this.syjyj = syjyj;
    }

    public String getSyjjnqk() {
        return syjjnqk;
    }

    public void setSyjjnqk(String syjjnqk) {
        this.syjjnqk = syjjnqk;
    }

    public Double getSyqmj() {
        return syqmj;
    }

    public void setSyqmj(Double syqmj) {
        this.syqmj = syqmj;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @Override
    public String toString() {
        return "ArdBdcHysyq{" +
                "ywh='" + ywh + '\'' +
                ", xmmc='" + xmmc + '\'' +
                ", djsj=" + djsj +
                ", dbr='" + dbr + '\'' +
                ", qlqssj=" + qlqssj +
                ", qljssj=" + qljssj +
                ", syksqx=" + syksqx +
                ", syjsqx=" + syjsqx +
                ", syzje=" + syzje +
                ", syjyj='" + syjyj + '\'' +
                ", syjjnqk='" + syjjnqk + '\'' +
                ", syqmj=" + syqmj +
                ", fj='" + fj + '\'' +
                '}';
    }
}
