package cn.gtmap.estateplat.config.model;

import cn.gtmap.estateplat.config.utils.ArdExcelUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

import java.util.Date;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/9/7
 * @description
 */
public class ArdBdcLq implements ArdInfo {

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 业务号
     */
    private String ywh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 登记时间
     */
    private Date djsj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 登簿人
     */
    private String dbr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利起始时间
     */
    private Date qlqssj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利结束时间
     */
    private Date qljssj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 使用权面积
     */
    private Double syqmj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 林地使用开始期限
     */
    private Date ldsyksqx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 林地使用结束期限
     */
    private Date ldsyjsqx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 发包方名称
     */
    private String fbfmc;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 主要树种
     */
    private String zysz;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 株数
     */
    private Integer zs;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 林种
     */
    private String lz;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 造林年度
     */
    private String zlnd;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 小地名
     */
    private String xdm;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 林班
     */
    private String lb;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 小班
     */
    private String xb;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 起源
     */
    private String qy;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 林地使用权性质
     */
    private String ldsyqxz;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 林木使用权人
     */
    private String lmsyqr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 林木所有权人
     */
    private String lmsuqr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 附记
     */
    private String fj;

    private ArdBdcLq(Row row, int lineNum) {
        boolean ywhFlag = false;
        boolean djsjFlag = false;
        boolean dbrFlag = false;
        boolean qlqssjFlag = false;
        boolean qljssjFlag = false;
        boolean syqmjFlag = false;
        boolean ldsyksqxFlag = false;
        boolean ldsyjsqxFlag = false;
        boolean fbfmcFlag = false;
        boolean zyszFlag = false;
        boolean zsFlag = false;
        boolean lzFlag = false;
        boolean zlndFlag = false;
        boolean xdmFlag = false;
        boolean lbFlag = false;
        boolean xbFlag = false;
        boolean qyFlag = false;
        boolean ldsyqxzFlag = false;
        boolean lmsyqrFlag = false;
        boolean lmsuqrFlag = false;
        boolean fjFlag = false;
        Cell currentCell;
        for (int i = 0; i < lineNum; i++) {
            currentCell = row.getCell(i);
            if (StringUtils.isBlank(this.getYwh()) && !ywhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYwh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                ywhFlag = true;
                continue;
            }
            if (this.getDjsj() == null && !djsjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDjsj(currentCell.getDateCellValue());
                }
                djsjFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDbr()) && !dbrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDbr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                dbrFlag = true;
                continue;
            }
            if (this.getQlqssj() == null && !qlqssjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlqssj(currentCell.getDateCellValue());
                }
                qlqssjFlag = true;
                continue;
            }
            if (this.getQljssj() == null && !qljssjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQljssj(currentCell.getDateCellValue());
                }
                qljssjFlag = true;
                continue;
            }
            if (this.getSyqmj() == null && !syqmjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSyqmj(Double.parseDouble(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell))));
                }
                syqmjFlag = true;
                continue;
            }
            if (this.getLdsyksqx() == null && !ldsyksqxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLdsyksqx(currentCell.getDateCellValue());
                }
                ldsyksqxFlag = true;
                continue;
            }
            if (this.getLdsyjsqx() == null && !ldsyjsqxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLdsyjsqx(currentCell.getDateCellValue());
                }
                ldsyjsqxFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getFbfmc()) && !fbfmcFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setFbfmc(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                fbfmcFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getZysz()) && !zyszFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZysz(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                zyszFlag = true;
                continue;
            }
            if (this.getZs() == null && !zsFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZs(Integer.parseInt(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell))));
                }
                zsFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getLz()) && !lzFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLz(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                lzFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getZlnd()) && !zlndFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZlnd(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                zlndFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getXdm()) && !xdmFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setXdm(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                xdmFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getLb()) && !lbFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLb(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                lbFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getXb()) && !xbFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setXb(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                xbFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQy()) && !qyFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQy(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qyFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getLdsyqxz()) && !ldsyqxzFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLdsyqxz(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                ldsyqxzFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getLmsyqr()) && !lmsyqrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLmsyqr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                lmsyqrFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getLmsuqr()) && !lmsuqrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLmsuqr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                lmsuqrFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getFj()) && !fjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setFj(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                fjFlag = true;
            }
        }
    }

    public static ArdBdcLq initArdBdcLq(Row row, int lineNum) {
        return new ArdBdcLq(row, lineNum);
    }

    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    public Date getQlqssj() {
        return qlqssj;
    }

    public void setQlqssj(Date qlqssj) {
        this.qlqssj = qlqssj;
    }

    public Date getQljssj() {
        return qljssj;
    }

    public void setQljssj(Date qljssj) {
        this.qljssj = qljssj;
    }

    public Double getSyqmj() {
        return syqmj;
    }

    public void setSyqmj(Double syqmj) {
        this.syqmj = syqmj;
    }

    public Date getLdsyksqx() {
        return ldsyksqx;
    }

    public void setLdsyksqx(Date ldsyksqx) {
        this.ldsyksqx = ldsyksqx;
    }

    public Date getLdsyjsqx() {
        return ldsyjsqx;
    }

    public void setLdsyjsqx(Date ldsyjsqx) {
        this.ldsyjsqx = ldsyjsqx;
    }

    public String getFbfmc() {
        return fbfmc;
    }

    public void setFbfmc(String fbfmc) {
        this.fbfmc = fbfmc;
    }

    public String getZysz() {
        return zysz;
    }

    public void setZysz(String zysz) {
        this.zysz = zysz;
    }

    public Integer getZs() {
        return zs;
    }

    public void setZs(Integer zs) {
        this.zs = zs;
    }

    public String getLz() {
        return lz;
    }

    public void setLz(String lz) {
        this.lz = lz;
    }

    public String getZlnd() {
        return zlnd;
    }

    public void setZlnd(String zlnd) {
        this.zlnd = zlnd;
    }

    public String getXdm() {
        return xdm;
    }

    public void setXdm(String xdm) {
        this.xdm = xdm;
    }

    public String getLb() {
        return lb;
    }

    public void setLb(String lb) {
        this.lb = lb;
    }

    public String getXb() {
        return xb;
    }

    public void setXb(String xb) {
        this.xb = xb;
    }

    public String getQy() {
        return qy;
    }

    public void setQy(String qy) {
        this.qy = qy;
    }

    public String getLdsyqxz() {
        return ldsyqxz;
    }

    public void setLdsyqxz(String ldsyqxz) {
        this.ldsyqxz = ldsyqxz;
    }

    public String getLmsyqr() {
        return lmsyqr;
    }

    public void setLmsyqr(String lmsyqr) {
        this.lmsyqr = lmsyqr;
    }

    public String getLmsuqr() {
        return lmsuqr;
    }

    public void setLmsuqr(String lmsuqr) {
        this.lmsuqr = lmsuqr;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @Override
    public String toString() {
        return "ArdBdcLq{" +
                "ywh='" + ywh + '\'' +
                ", djsj=" + djsj +
                ", dbr='" + dbr + '\'' +
                ", qlqssj=" + qlqssj +
                ", qljssj=" + qljssj +
                ", syqmj=" + syqmj +
                ", ldsyksqx=" + ldsyksqx +
                ", ldsyjsqx=" + ldsyjsqx +
                ", fbfmc='" + fbfmc + '\'' +
                ", zysz='" + zysz + '\'' +
                ", zs=" + zs +
                ", lz='" + lz + '\'' +
                ", zlnd='" + zlnd + '\'' +
                ", xdm='" + xdm + '\'' +
                ", lb='" + lb + '\'' +
                ", xb='" + xb + '\'' +
                ", qy='" + qy + '\'' +
                ", ldsyqxz='" + ldsyqxz + '\'' +
                ", lmsyqr='" + lmsyqr + '\'' +
                ", lmsuqr='" + lmsuqr + '\'' +
                ", fj='" + fj + '\'' +
                '}';
    }
}
