package cn.gtmap.estateplat.config.model;

import cn.gtmap.estateplat.config.utils.ArdExcelUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/9/6
 * @description
 */
public class ArdBdcQlr implements ArdInfo {

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 业务号
     */
    private String ywh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人类型
     */
    private String qlrlx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人名称
     */
    private String qlrmc;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 身份证件种类
     */
    private String qlrsfzjzl;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 证件号
     */
    private String qlrzjh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人通讯地址
     */
    private String qlrtxdz;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人联系电话
     */
    private String qlrlxdh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人邮编
     */
    private String qlryb;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人法定代表人
     */
    private String qlrfddbr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人法定代表人电话
     */
    private String qlrfddbrdh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人法定代表人证件种类
     */
    private String qlrfddbrzjzl;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人法定代表人证件号
     */
    private String qlrfddbrzjh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人代理人
     */
    private String qlrdlr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人代理人电话
     */
    private String qlrdlrdh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人代理机构
     */
    private String qlrdljg;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人代理人证件种类
     */
    private String qlrdlrzjzl;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人代理人证件号
     */
    private String qlrdlrzjh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利比例
     */
    private String qlbl;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 共有情况
     */
    private String gyqk;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利人性质
     */
    private String qlrxz;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 所属行业
     */
    private String sshy;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 备注
     */
    private String bz;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 是否持证人
     */
    private String sfczr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 顺序号
     */
    private Integer sxh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 性别
     */
    private String xb;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利面积
     */
    private Double qlmj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 其余共有人
     */
    private String qygyr;

    private ArdBdcQlr(Row row, int lineNum) {
        boolean ywhFlag = false;
        boolean qlrlxFlag = false;
        boolean qlrmcFlag = false;
        boolean qlrsfzjzlFlag = false;
        boolean qlrzjhFlag = false;
        boolean qlrtxdzFlag = false;
        boolean qlrlxdhFlag = false;
        boolean qlrybFlag = false;
        boolean qlrfddbrFlag = false;
        boolean qlrfddbrdhFlag = false;
        boolean qlrfddbrzjzlFlag = false;
        boolean qlrfddbrzjhFlag = false;
        boolean qlrdlrFlag = false;
        boolean qlrdlrdhFlag = false;
        boolean qlrdljgFlag = false;
        boolean qlrdlrzjzlFlag = false;
        boolean qlrdlrzjhFlag = false;
        boolean qlblFlag = false;
        boolean gyqkFlag = false;
        boolean qlrxzFlag = false;
        boolean sshyFlag = false;
        boolean bzFlag = false;
        boolean sfczrFlag = false;
        boolean sxhFlag = false;
        boolean xbFlag = false;
        boolean qlmjFlag = false;
        boolean qygyrFlag = false;
        Cell currentCell;
        for (int i = 0; i < lineNum; i++) {
            currentCell = row.getCell(i);
            if (StringUtils.isBlank(this.getYwh()) && !ywhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYwh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                ywhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrlx()) && !qlrlxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrlx(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrlxFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrmc()) && !qlrmcFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrmc(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrmcFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrsfzjzl()) && !qlrsfzjzlFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrsfzjzl(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrsfzjzlFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrzjh()) && !qlrzjhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrzjh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrzjhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrtxdz()) && !qlrtxdzFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrtxdz(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrtxdzFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrlxdh()) && !qlrlxdhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrlxdh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrlxdhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlryb()) && !qlrybFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlryb(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrybFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrfddbr()) && !qlrfddbrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrfddbr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrfddbrFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrfddbrdh()) && !qlrfddbrdhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrfddbrdh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrfddbrdhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrfddbrzjzl()) && !qlrfddbrzjzlFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrfddbrzjzl(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrfddbrzjzlFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrfddbrzjh()) && !qlrfddbrzjhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrfddbrzjh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrfddbrzjhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrdlr()) && !qlrdlrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrdlr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrdlrFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrdlrdh()) && !qlrdlrdhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrdlrdh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrdlrdhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrdljg()) && !qlrdljgFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrdljg(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrdljgFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrdlrzjzl()) && !qlrdlrzjzlFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrdlrzjzl(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrdlrzjzlFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrdlrzjh()) && !qlrdlrzjhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrdlrzjh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrdlrzjhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlbl()) && !qlblFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlbl(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlblFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getGyqk()) && !gyqkFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setGyqk(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                gyqkFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlrxz()) && !qlrxzFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlrxz(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlrxzFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getSshy()) && !sshyFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSshy(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                sshyFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getBz()) && !bzFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setBz(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                bzFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getSfczr()) && !sfczrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSfczr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                sfczrFlag = true;
                continue;
            }
            if (this.getSxh() == null && !sxhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSxh(Integer.parseInt(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell))));
                }
                sxhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getXb()) && !xbFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setXb(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                xbFlag = true;
                continue;
            }
            if (this.getQlmj() == null && !qlmjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlmj(Double.valueOf(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell))));
                }
                qlmjFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQygyr()) && !qygyrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQygyr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qygyrFlag = true;
            }
        }
    }

    public static ArdBdcQlr initArdBdcQlr(Row row, int lineNum) {
        return new ArdBdcQlr(row, lineNum);
    }

    @Override
    public String getYwh() {
        return ywh;
    }

    @Override
    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    public String getQlrlx() {
        return qlrlx;
    }

    public void setQlrlx(String qlrlx) {
        this.qlrlx = qlrlx;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    public String getQlrsfzjzl() {
        return qlrsfzjzl;
    }

    public void setQlrsfzjzl(String qlrsfzjzl) {
        this.qlrsfzjzl = qlrsfzjzl;
    }

    public String getQlrzjh() {
        return qlrzjh;
    }

    public void setQlrzjh(String qlrzjh) {
        this.qlrzjh = qlrzjh;
    }

    public String getQlrtxdz() {
        return qlrtxdz;
    }

    public void setQlrtxdz(String qlrtxdz) {
        this.qlrtxdz = qlrtxdz;
    }

    public String getQlrlxdh() {
        return qlrlxdh;
    }

    public void setQlrlxdh(String qlrlxdh) {
        this.qlrlxdh = qlrlxdh;
    }

    public String getQlryb() {
        return qlryb;
    }

    public void setQlryb(String qlryb) {
        this.qlryb = qlryb;
    }

    public String getQlrfddbr() {
        return qlrfddbr;
    }

    public void setQlrfddbr(String qlrfddbr) {
        this.qlrfddbr = qlrfddbr;
    }

    public String getQlrfddbrdh() {
        return qlrfddbrdh;
    }

    public void setQlrfddbrdh(String qlrfddbrdh) {
        this.qlrfddbrdh = qlrfddbrdh;
    }

    public String getQlrfddbrzjzl() {
        return qlrfddbrzjzl;
    }

    public void setQlrfddbrzjzl(String qlrfddbrzjzl) {
        this.qlrfddbrzjzl = qlrfddbrzjzl;
    }

    public String getQlrfddbrzjh() {
        return qlrfddbrzjh;
    }

    public void setQlrfddbrzjh(String qlrfddbrzjh) {
        this.qlrfddbrzjh = qlrfddbrzjh;
    }

    public String getQlrdlr() {
        return qlrdlr;
    }

    public void setQlrdlr(String qlrdlr) {
        this.qlrdlr = qlrdlr;
    }

    public String getQlrdlrdh() {
        return qlrdlrdh;
    }

    public void setQlrdlrdh(String qlrdlrdh) {
        this.qlrdlrdh = qlrdlrdh;
    }

    public String getQlrdljg() {
        return qlrdljg;
    }

    public void setQlrdljg(String qlrdljg) {
        this.qlrdljg = qlrdljg;
    }

    public String getQlrdlrzjzl() {
        return qlrdlrzjzl;
    }

    public void setQlrdlrzjzl(String qlrdlrzjzl) {
        this.qlrdlrzjzl = qlrdlrzjzl;
    }

    public String getQlrdlrzjh() {
        return qlrdlrzjh;
    }

    public void setQlrdlrzjh(String qlrdlrzjh) {
        this.qlrdlrzjh = qlrdlrzjh;
    }

    public String getQlbl() {
        return qlbl;
    }

    public void setQlbl(String qlbl) {
        this.qlbl = qlbl;
    }

    public String getGyqk() {
        return gyqk;
    }

    public void setGyqk(String gyqk) {
        this.gyqk = gyqk;
    }

    public String getQlrxz() {
        return qlrxz;
    }

    public void setQlrxz(String qlrxz) {
        this.qlrxz = qlrxz;
    }

    public String getSshy() {
        return sshy;
    }

    public void setSshy(String sshy) {
        this.sshy = sshy;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getSfczr() {
        return sfczr;
    }

    public void setSfczr(String sfczr) {
        this.sfczr = sfczr;
    }

    public Integer getSxh() {
        return sxh;
    }

    public void setSxh(Integer sxh) {
        this.sxh = sxh;
    }

    public String getXb() {
        return xb;
    }

    public void setXb(String xb) {
        this.xb = xb;
    }

    public Double getQlmj() {
        return qlmj;
    }

    public void setQlmj(Double qlmj) {
        this.qlmj = qlmj;
    }

    public String getQygyr() {
        return qygyr;
    }

    public void setQygyr(String qygyr) {
        this.qygyr = qygyr;
    }

    @Override
    public String toString() {
        return "ArdBdcQlr{" +
                "ywh='" + ywh + '\'' +
                ", qlrlx='" + qlrlx + '\'' +
                ", qlrmc='" + qlrmc + '\'' +
                ", qlrsfzjzl='" + qlrsfzjzl + '\'' +
                ", qlrzjh='" + qlrzjh + '\'' +
                ", qlrtxdz='" + qlrtxdz + '\'' +
                ", qlrlxdh='" + qlrlxdh + '\'' +
                ", qlryb='" + qlryb + '\'' +
                ", qlrfddbr='" + qlrfddbr + '\'' +
                ", qlrfddbrdh='" + qlrfddbrdh + '\'' +
                ", qlrfddbrzjzl='" + qlrfddbrzjzl + '\'' +
                ", qlrfddbrzjh='" + qlrfddbrzjh + '\'' +
                ", qlrdlr='" + qlrdlr + '\'' +
                ", qlrdlrdh='" + qlrdlrdh + '\'' +
                ", qlrdljg='" + qlrdljg + '\'' +
                ", qlrdlrzjzl='" + qlrdlrzjzl + '\'' +
                ", qlrdlrzjh='" + qlrdlrzjh + '\'' +
                ", qlbl='" + qlbl + '\'' +
                ", gyqk='" + gyqk + '\'' +
                ", qlrxz='" + qlrxz + '\'' +
                ", sshy='" + sshy + '\'' +
                ", bz='" + bz + '\'' +
                ", sfczr='" + sfczr + '\'' +
                ", sxh=" + sxh +
                ", xb='" + xb + '\'' +
                ", qlmj=" + qlmj +
                ", qygyr='" + qygyr + '\'' +
                '}';
    }
}
