package cn.gtmap.estateplat.config.model;

import cn.gtmap.estateplat.config.utils.ArdExcelUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/9/6
 * @description
 */
public class ArdBdcXm implements ArdInfo {

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 业务号
     */
    private String ywh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 不动产单元号
     */
    private String bdcdyh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利类型
     */
    private String qllx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 不动产类型
     */
    private String bdclx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 登记类型
     */
    private String djlx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 申请类型
     */
    private String sqlx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 登记原因
     */
    private String djyy;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 申请证书板式
     */
    private String sqzsbs;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 申请分别持证
     */
    private String sqfbcz;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 备注
     */
    private String bz;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 申请人说明
     */
    private String sqrsm;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 单位代码
     */
    private String dwdm;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 创建时间
     */
    private Date cjsj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 创建人
     */
    private String cjr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 办结时间
     */
    private Date bjsj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 流水号
     */
    private String lsh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 年份
     */
    private String nf;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 项目名称
     */
    private String xmmc;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 登记事由
     */
    private String djsy;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 抵押登记类型
     */
    private String dydjlx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 坐落
     */
    private String zl;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 原不动产权证号
     */
    private String ybdcqzh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 产权归属
     */
    private String cqgs;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 登记机构
     */
    private String djjg;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 面积
     */
    private Double mj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 用途
     */
    private String yt;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 用海类型
     */
    private String yhlx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 用海类型B
     */
    private String yhlxb;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 构筑物类型
     */
    private String gzwlx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 林种
     */
    private String lz;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 面积单位
     */
    private String mjdw;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 宗地宗海面积
     */
    private Double zdzhmj;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 宗地宗海用途
     */
    private String zdzhyt;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 宗地宗海权利性质
     */
    private String zdzhqlxz;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 宗地宗海用途2
     */
    private String zdzhyt2;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 宗地宗海用途3
     */
    private String zdzhyt3;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 定着物用途2
     */
    private String yt2;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 定着物用途3
     */
    private String yt3;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 用海审批单位
     */
    private String yhspdw;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 批准文号
     */
    private String pzwh;

    private ArdBdcXm(Row row, int lineNum) {
        boolean ywhFlag = false;
        boolean bdcdyhFlag = false;
        boolean qllxFlag = false;
        boolean bdclxFlag = false;
        boolean djlxFlag = false;
        boolean sqlxFlag = false;
        boolean djyyFlag = false;
        boolean sqzsbsFlag = false;
        boolean sqfbczFlag = false;
        boolean bzFlag = false;
        boolean sqrsmFlag = false;
        boolean dwdmFlag = false;
        boolean cjsjFlag = false;
        boolean cjrFlag = false;
        boolean bjsjFlag = false;
        boolean lshFlag = false;
        boolean nfFlag = false;
        boolean xmmcFlag = false;
        boolean djsyFlag = false;
        boolean dydjlxFlag = false;
        boolean zlFlag = false;
        boolean ybdcqzhFlag = false;
        boolean cqgsFlag = false;
        boolean djjgFlag = false;
        boolean mjFlag = false;
        boolean ytFlag = false;
        boolean yhlxFlag = false;
        boolean yhlxbFlag = false;
        boolean gzwlxFlag = false;
        boolean lzFlag = false;
        boolean mjdwFlag = false;
        boolean zdzhmjFlag = false;
        boolean zdzhytFlag = false;
        boolean zdzhqlxzFlag = false;
        boolean zdzhyt2Flag = false;
        boolean zdzhyt3Flag = false;
        boolean yt2Flag = false;
        boolean yt3Flag = false;
        boolean yhspdwFlag = false;
        boolean pzwhFlag = false;
        Cell currentCell;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < lineNum; i++) {
            currentCell = row.getCell(i);
            if (StringUtils.isBlank(this.getYwh()) && !ywhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYwh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                ywhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getBdcdyh()) && !bdcdyhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setBdcdyh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                bdcdyhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQllx()) && !qllxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQllx(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qllxFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getBdclx()) && !bdclxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setBdclx(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                bdclxFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDjlx()) && !djlxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDjlx(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                djlxFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getSqlx()) && !sqlxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSqlx(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                sqlxFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDjyy()) && !djyyFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDjyy(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                djyyFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getSqzsbs()) && !sqzsbsFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSqzsbs(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                sqzsbsFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getSqfbcz()) && !sqfbczFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSqfbcz(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                sqfbczFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getBz()) && !bzFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setBz(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                bzFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getSqrsm()) && !sqrsmFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSqrsm(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                sqrsmFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDwdm()) && !dwdmFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDwdm(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                dwdmFlag = true;
                continue;
            }
            if (this.getCjsj() == null && !cjsjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    if (((HSSFCell) currentCell).getCellType() == 0) {
                        this.setCjsj(currentCell.getDateCellValue());
                    } else {
                        try {
                            this.setCjsj(sdf.parse(currentCell.getStringCellValue()));
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                }
                cjsjFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getCjr()) && !cjrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setCjr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                cjrFlag = true;
                continue;
            }
            if (this.getBjsj() == null && !bjsjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    if (((HSSFCell) currentCell).getCellType() == 0) {
                        this.setBjsj(currentCell.getDateCellValue());
                    } else {
                        try {
                            this.setBjsj(sdf.parse(currentCell.getStringCellValue()));
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                }
                bjsjFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getLsh()) && !lshFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLsh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                lshFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getNf()) && !nfFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setNf(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                nfFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getXmmc()) && !xmmcFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setXmmc(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                xmmcFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDjsy()) && !djsyFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDjsy(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                djsyFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDydjlx()) && !dydjlxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDydjlx(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                dydjlxFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getZl()) && !zlFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZl(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                zlFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getYbdcqzh()) && !ybdcqzhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYbdcqzh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                ybdcqzhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getCqgs()) && !cqgsFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setCqgs(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                cqgsFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDjjg()) && !djjgFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDjjg(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                djjgFlag = true;
                continue;
            }
            if (this.getMj() == null && !mjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setMj(Double.parseDouble(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell))));
                }
                mjFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getYt()) && !ytFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYt(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                ytFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getYhlx()) && !yhlxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYhlx(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                yhlxFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getYhlxb()) && !yhlxbFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYhlxb(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                yhlxbFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getGzwlx()) && !gzwlxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setGzwlx(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                gzwlxFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getLz()) && !lzFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLz(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                lzFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getMjdw()) && !mjdwFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setMjdw(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                mjdwFlag = true;
                continue;
            }
            if (this.getZdzhmj() == null && !zdzhmjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZdzhmj(Double.valueOf(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell))));
                }
                zdzhmjFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getZdzhyt()) && !zdzhytFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZdzhyt(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                zdzhytFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getZdzhqlxz()) && !zdzhqlxzFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZdzhqlxz(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                zdzhqlxzFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getZdzhyt2()) && !zdzhyt2Flag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZdzhyt2(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                zdzhyt2Flag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getZdzhyt3()) && !zdzhyt3Flag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZdzhyt3(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                zdzhyt3Flag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getYt2()) && !yt2Flag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYt2(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                yt2Flag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getYt3()) && !yt3Flag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYt3(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                yt3Flag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getYhspdw()) && !yhspdwFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYhspdw(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                yhspdwFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getPzwh()) && !pzwhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setPzwh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                pzwhFlag = true;
            }
        }
    }

    public static ArdBdcXm initArdBdcXm(Row row, int lineNum) {
        return new ArdBdcXm(row, lineNum);
    }

    @Override
    public String getYwh() {
        return ywh;
    }

    @Override
    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    public String getBdclx() {
        return bdclx;
    }

    public void setBdclx(String bdclx) {
        this.bdclx = bdclx;
    }

    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    public String getSqlx() {
        return sqlx;
    }

    public void setSqlx(String sqlx) {
        this.sqlx = sqlx;
    }

    public String getDjyy() {
        return djyy;
    }

    public void setDjyy(String djyy) {
        this.djyy = djyy;
    }

    public String getSqzsbs() {
        return sqzsbs;
    }

    public void setSqzsbs(String sqzsbs) {
        this.sqzsbs = sqzsbs;
    }

    public String getSqfbcz() {
        return sqfbcz;
    }

    public void setSqfbcz(String sqfbcz) {
        this.sqfbcz = sqfbcz;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getSqrsm() {
        return sqrsm;
    }

    public void setSqrsm(String sqrsm) {
        this.sqrsm = sqrsm;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public Date getCjsj() {
        return cjsj;
    }

    public void setCjsj(Date cjsj) {
        this.cjsj = cjsj;
    }

    public String getCjr() {
        return cjr;
    }

    public void setCjr(String cjr) {
        this.cjr = cjr;
    }

    public String getLsh() {
        return lsh;
    }

    public void setLsh(String lsh) {
        this.lsh = lsh;
    }

    public Date getBjsj() {
        return bjsj;
    }

    public void setBjsj(Date bjsj) {
        this.bjsj = bjsj;
    }

    public String getNf() {
        return nf;
    }

    public void setNf(String nf) {
        this.nf = nf;
    }

    public String getXmmc() {
        return xmmc;
    }

    public void setXmmc(String xmmc) {
        this.xmmc = xmmc;
    }

    public String getDjsy() {
        return djsy;
    }

    public void setDjsy(String djsy) {
        this.djsy = djsy;
    }

    public String getDydjlx() {
        return dydjlx;
    }

    public void setDydjlx(String dydjlx) {
        this.dydjlx = dydjlx;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getYbdcqzh() {
        return ybdcqzh;
    }

    public void setYbdcqzh(String ybdcqzh) {
        this.ybdcqzh = ybdcqzh;
    }

    public String getCqgs() {
        return cqgs;
    }

    public void setCqgs(String cqgs) {
        this.cqgs = cqgs;
    }

    public String getDjjg() {
        return djjg;
    }

    public void setDjjg(String djjg) {
        this.djjg = djjg;
    }

    public Double getMj() {
        return mj;
    }

    public void setMj(Double mj) {
        this.mj = mj;
    }

    public String getYt() {
        return yt;
    }

    public void setYt(String yt) {
        this.yt = yt;
    }

    public String getYhlx() {
        return yhlx;
    }

    public void setYhlx(String yhlx) {
        this.yhlx = yhlx;
    }

    public String getYhlxb() {
        return yhlxb;
    }

    public void setYhlxb(String yhlxb) {
        this.yhlxb = yhlxb;
    }

    public String getGzwlx() {
        return gzwlx;
    }

    public void setGzwlx(String gzwlx) {
        this.gzwlx = gzwlx;
    }

    public String getLz() {
        return lz;
    }

    public void setLz(String lz) {
        this.lz = lz;
    }

    public String getMjdw() {
        return mjdw;
    }

    public void setMjdw(String mjdw) {
        this.mjdw = mjdw;
    }


    public Double getZdzhmj() {
        return zdzhmj;
    }

    public void setZdzhmj(Double zdzhmj) {
        this.zdzhmj = zdzhmj;
    }

    public String getZdzhyt() {
        return zdzhyt;
    }

    public void setZdzhyt(String zdzhyt) {
        this.zdzhyt = zdzhyt;
    }

    public String getZdzhqlxz() {
        return zdzhqlxz;
    }

    public void setZdzhqlxz(String zdzhqlxz) {
        this.zdzhqlxz = zdzhqlxz;
    }

    public String getZdzhyt2() {
        return zdzhyt2;
    }

    public void setZdzhyt2(String zdzhyt2) {
        this.zdzhyt2 = zdzhyt2;
    }

    public String getZdzhyt3() {
        return zdzhyt3;
    }

    public void setZdzhyt3(String zdzhyt3) {
        this.zdzhyt3 = zdzhyt3;
    }

    public String getYt2() {
        return yt2;
    }

    public void setYt2(String yt2) {
        this.yt2 = yt2;
    }

    public String getYt3() {
        return yt3;
    }

    public void setYt3(String yt3) {
        this.yt3 = yt3;
    }

    public String getYhspdw() {
        return yhspdw;
    }

    public void setYhspdw(String yhspdw) {
        this.yhspdw = yhspdw;
    }

    public String getPzwh() {
        return pzwh;
    }

    public void setPzwh(String pzwh) {
        this.pzwh = pzwh;
    }

    @Override
    public String toString() {
        return "ArdBdcXm{" +
                "ywh='" + ywh + '\'' +
                ", bdcdyh='" + bdcdyh + '\'' +
                ", qllx='" + qllx + '\'' +
                ", bdclx='" + bdclx + '\'' +
                ", djlx='" + djlx + '\'' +
                ", sqlx='" + sqlx + '\'' +
                ", djyy='" + djyy + '\'' +
                ", sqzsbs='" + sqzsbs + '\'' +
                ", sqfbcz='" + sqfbcz + '\'' +
                ", bz='" + bz + '\'' +
                ", sqrsm='" + sqrsm + '\'' +
                ", dwdm='" + dwdm + '\'' +
                ", cjsj=" + cjsj +
                ", cjr='" + cjr + '\'' +
                ", bjsj=" + bjsj +
                ", lsh='" + lsh + '\'' +
                ", nf='" + nf + '\'' +
                ", xmmc='" + xmmc + '\'' +
                ", djsy='" + djsy + '\'' +
                ", dydjlx='" + dydjlx + '\'' +
                ", zl='" + zl + '\'' +
                ", ybdcqzh='" + ybdcqzh + '\'' +
                ", cqgs='" + cqgs + '\'' +
                ", djjg='" + djjg + '\'' +
                ", mj=" + mj +
                ", yt='" + yt + '\'' +
                ", yhlx='" + yhlx + '\'' +
                ", yhlxb='" + yhlxb + '\'' +
                ", gzwlx='" + gzwlx + '\'' +
                ", lz='" + lz + '\'' +
                ", mjdw='" + mjdw + '\'' +
                ", zdzhmj=" + zdzhmj +
                ", zdzhyt='" + zdzhyt + '\'' +
                ", zdzhqlxz='" + zdzhqlxz + '\'' +
                ", zdzhyt2='" + zdzhyt2 + '\'' +
                ", zdzhyt3='" + zdzhyt3 + '\'' +
                ", yt2='" + yt2 + '\'' +
                ", yt3='" + yt3 + '\'' +
                ", yhspdw='" + yhspdw + '\'' +
                ", pzwh='" + pzwh + '\'' +
                '}';
    }
}
