package cn.gtmap.estateplat.config.model;

import cn.gtmap.estateplat.config.utils.ArdExcelUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

import java.util.Date;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/9/12
 * @description
 */
public class ArdBdcZs implements ArdInfo {

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 业务号
     */
    private String ywh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 不动产权证号
     */
    private String bdcqzh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 证明权利或事项
     */
    private String zmqlsx;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 证号流水号
     */
    private String zhlsh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 年份
     */
    private String nf;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 持证人
     */
    private String czr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 持证日期
     */
    private Date czrq;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 编号
     */
    private String bh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 权利其他状况
     */
    private String qlqtzk;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 单位代码
     */
    private String dwdm;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 省区市简称
     */
    private String sqsjc;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 所在市县全称
     */
    private String szsxqc;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 发证日期
     */
    private Date fzrq;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 发证人
     */
    private String fzr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 缮证人
     */
    private String szr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 缮证日期
     */
    private Date szrq;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 领证人
     */
    private String lzr;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 领证人证件种类
     */
    private String lzrzjzl;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 领证人证件号
     */
    private String lzrzjh;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 领证日期
     */
    private Date lzrq;

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 附记
     */
    private String fj;

    private ArdBdcZs(Row row, int lineNum) {
        boolean ywhFlag = false;
        boolean bdcqzhFlag = false;
        boolean zmqlsxFlag = false;
        boolean zhlshFlag = false;
        boolean nfFlag = false;
        boolean czrFlag = false;
        boolean czrqFlag = false;
        boolean bhFlag = false;
        boolean qlqtzkFlag = false;
        boolean dwdmFlag = false;
        boolean sqsjcFlag = false;
        boolean szsxqcFlag = false;
        boolean fzrqFlag = false;
        boolean fzrFlag = false;
        boolean szrFlag = false;
        boolean szrqFlag = false;
        boolean lzrFlag = false;
        boolean lzrzjzlFlag = false;
        boolean lzrzjhFlag = false;
        boolean lzrqFlag = false;
        boolean fjFlag = false;
        Cell currentCell;
        for (int i = 0; i < lineNum; i++) {
            currentCell = row.getCell(i);
            if (StringUtils.isBlank(this.getYwh()) && !ywhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setYwh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                ywhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getBdcqzh()) && !bdcqzhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setBdcqzh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                bdcqzhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getZmqlsx()) && !zmqlsxFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZmqlsx(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                zmqlsxFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getZhlsh()) && !zhlshFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setZhlsh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                zhlshFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getNf()) && !nfFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setNf(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                nfFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getCzr()) && !czrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setCzr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                czrFlag = true;
                continue;
            }
            if (this.getCzrq() == null && !czrqFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setCzrq(currentCell.getDateCellValue());
                }
                czrqFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getBh()) && !bhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setBh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                bhFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getQlqtzk()) && !qlqtzkFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setQlqtzk(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                qlqtzkFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getDwdm()) && !dwdmFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setDwdm(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                dwdmFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getSqsjc()) && !sqsjcFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSqsjc(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                sqsjcFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getSzsxqc()) && !szsxqcFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSzsxqc(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                szsxqcFlag = true;
                continue;
            }
            if (this.getFzrq() == null && !fzrqFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setFzrq(currentCell.getDateCellValue());
                }
                fzrqFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getFzr()) && !fzrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setFzr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                fzrFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getSzr()) && !szrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSzr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                szrFlag = true;
                continue;
            }
            if (this.getSzrq() == null && !szrqFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setSzrq(currentCell.getDateCellValue());
                }
                szrqFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getLzr()) && !lzrFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLzr(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                lzrFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getLzrzjzl()) && !lzrzjzlFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLzrzjzl(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                lzrzjzlFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getLzrzjh()) && !lzrzjhFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLzrzjh(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                lzrzjhFlag = true;
                continue;
            }
            if (this.getLzrq() == null && !lzrqFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setLzrq(currentCell.getDateCellValue());
                }
                lzrqFlag = true;
                continue;
            }
            if (StringUtils.isBlank(this.getFj()) && !fjFlag) {
                if (currentCell != null && StringUtils.isNotBlank(currentCell.toString())) {
                    this.setFj(StringUtils.deleteWhitespace(ArdExcelUtil.getValue(currentCell)));
                }
                fjFlag = true;
            }
        }
    }

    public static ArdBdcZs initArdBdcZs(Row row, int lineNum) {
        return new ArdBdcZs(row, lineNum);
    }

    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    public String getZmqlsx() {
        return zmqlsx;
    }

    public void setZmqlsx(String zmqlsx) {
        this.zmqlsx = zmqlsx;
    }

    public String getZhlsh() {
        return zhlsh;
    }

    public void setZhlsh(String zhlsh) {
        this.zhlsh = zhlsh;
    }

    public String getNf() {
        return nf;
    }

    public void setNf(String nf) {
        this.nf = nf;
    }

    public String getCzr() {
        return czr;
    }

    public void setCzr(String czr) {
        this.czr = czr;
    }

    public Date getCzrq() {
        return czrq;
    }

    public void setCzrq(Date czrq) {
        this.czrq = czrq;
    }

    public String getBh() {
        return bh;
    }

    public void setBh(String bh) {
        this.bh = bh;
    }

    public String getQlqtzk() {
        return qlqtzk;
    }

    public void setQlqtzk(String qlqtzk) {
        this.qlqtzk = qlqtzk;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getSqsjc() {
        return sqsjc;
    }

    public void setSqsjc(String sqsjc) {
        this.sqsjc = sqsjc;
    }

    public String getSzsxqc() {
        return szsxqc;
    }

    public void setSzsxqc(String szsxqc) {
        this.szsxqc = szsxqc;
    }

    public Date getFzrq() {
        return fzrq;
    }

    public void setFzrq(Date fzrq) {
        this.fzrq = fzrq;
    }

    public String getFzr() {
        return fzr;
    }

    public void setFzr(String fzr) {
        this.fzr = fzr;
    }

    public String getSzr() {
        return szr;
    }

    public void setSzr(String szr) {
        this.szr = szr;
    }

    public Date getSzrq() {
        return szrq;
    }

    public void setSzrq(Date szrq) {
        this.szrq = szrq;
    }

    public String getLzr() {
        return lzr;
    }

    public void setLzr(String lzr) {
        this.lzr = lzr;
    }

    public String getLzrzjzl() {
        return lzrzjzl;
    }

    public void setLzrzjzl(String lzrzjzl) {
        this.lzrzjzl = lzrzjzl;
    }

    public String getLzrzjh() {
        return lzrzjh;
    }

    public void setLzrzjh(String lzrzjh) {
        this.lzrzjh = lzrzjh;
    }

    public Date getLzrq() {
        return lzrq;
    }

    public void setLzrq(Date lzrq) {
        this.lzrq = lzrq;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @Override
    public String toString() {
        return "ArdBdcZs{" +
                "ywh='" + ywh + '\'' +
                ", bdcqzh='" + bdcqzh + '\'' +
                ", zmqlsx='" + zmqlsx + '\'' +
                ", zhlsh='" + zhlsh + '\'' +
                ", nf='" + nf + '\'' +
                ", czr='" + czr + '\'' +
                ", czrq=" + czrq +
                ", bh='" + bh + '\'' +
                ", qlqtzk='" + qlqtzk + '\'' +
                ", dwdm='" + dwdm + '\'' +
                ", sqsjc='" + sqsjc + '\'' +
                ", szsxqc='" + szsxqc + '\'' +
                ", fzrq=" + fzrq +
                ", fzr='" + fzr + '\'' +
                ", szr='" + szr + '\'' +
                ", szrq=" + szrq +
                ", lzr='" + lzr + '\'' +
                ", lzrzjzl='" + lzrzjzl + '\'' +
                ", lzrzjh='" + lzrzjh + '\'' +
                ", lzrq=" + lzrq +
                ", fj='" + fj + '\'' +
                '}';
    }
}
