package cn.gtmap.estateplat.config.rabbitmq.service.impl;
/*
 * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
 * @version 1.0, 2019-02-22
 * @description rabbitmq发送消息服务
 */

import cn.gtmap.estateplat.config.core.service.BdcMessageLogService;
import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.model.BdcMessageLog;
import cn.gtmap.estateplat.config.rabbitmq.service.RabbitmqSendMessageService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;

@Service
public class RabbitmqSendMessageServiceImpl implements RabbitmqSendMessageService {
    @Resource(name = "bdcAmqpTemplate")
    private RabbitTemplate bdcAmqpTemplate;
    @Autowired
    private BdcMessageLogService bdcMessageLogService;
    @Autowired
    private BdcXmService bdcXmService;

    protected final Logger logger = LoggerFactory.getLogger(RabbitmqSendMessageServiceImpl.class);

    @Override
    public void sendMsg(String proid,String routingKey, String messageJson, cn.gtmap.estateplat.config.model.CorrelationData correlationData) {
        if(StringUtils.isNotBlank(messageJson) && StringUtils.isNotBlank(proid)) {
//            Integer xmCount = 0;
//            BdcXm bdcXm = bdcXmService.getBdcXmByProid(proid);
//            if(bdcXm != null && StringUtils.isNotBlank(bdcXm.getWiid())){
//                String wiid = bdcXm.getWiid();
//                List<BdcXm> list = bdcXmService.getBdcXmListByWiid(wiid);
//                if(CollectionUtils.isNotEmpty(list)){
//                    xmCount = list.size();
//                }
//            }
//            if(xmCount > 0 && xmCount < 3){
//                Date curHMSDate = CalendarUtil.getCurHMSDate();
//                BdcMessageLog bdcMessageLog = new BdcMessageLog();
//                bdcMessageLog.setId(correlationData.getId());
//                bdcMessageLog.setProid(proid);
//                bdcMessageLog.setCjsj(curHMSDate);
//                bdcMessageLog.setXxdlm(routingKey);
//                bdcMessageLog.setXxt(messageJson);
//                bdcMessageLog.setFszt(Constants.MESSAGE_FSZT_WFS);
//                bdcMessageLog.setXfzt(Constants.MESSAGE_XFZT_WXF);
//                bdcMessageLog.setGxsj(curHMSDate);
//                logger.error("insert message send status ==="+ JSON.toJSONString(bdcMessageLog));
//                bdcMessageLogService.saveOrUpdateBdcMessageLog(bdcMessageLog);
//            }
            Message message = null;
            byte[] bytes = null;
            try {
                bytes = messageJson.getBytes("UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if(bytes != null){
                message = MessageBuilder.withBody(bytes)
                        .setContentType(MessageProperties.CONTENT_TYPE_JSON)
                        //.setDeliveryMode(MessageDeliveryMode.PERSISTENT) //消息默认是持久化的
                        .setCorrelationId(correlationData.getId().getBytes()).build();
                bdcAmqpTemplate.convertAndSend(routingKey, message, correlationData);
            }
        }
    }

}
