package cn.gtmap.estateplat.config.rabbitmq.service.impl;

import cn.gtmap.estateplat.config.core.service.BdcMessageLogService;
import cn.gtmap.estateplat.config.model.BdcMessageLog;
import cn.gtmap.estateplat.config.model.CorrelationData;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.MessageFormat;
import java.util.Date;

/**
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 2019/7/19
 * @description 消息发送失败返回监听器
 */
@Service
public class ReturnCallBackListener implements RabbitTemplate.ReturnCallback {
    @Resource(name = "bdcAmqpTemplate")
    private RabbitTemplate bdcAmqpTemplate;
    @Autowired
    private BdcMessageLogService bdcMessageLogService;

    private Logger logger = LoggerFactory.getLogger(ReturnCallBackListener.class);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param message
     * @param replyCode
     * @param replyText
     * @param exchange
     * @param routingKey
     * @return
     * @description 当消息从交换机到队列失败时，该方法被调用。（若成功，则不调用）,需要注意的是：该方法调用后，MsgSendConfirmCallBack中的confirm方法也会被调用，且ack = true
     */
    @Override
    public void returnedMessage(Message message, int replyCode, String replyText, String exchange, String routingKey) {
        try{
            logger.info(MessageFormat.format("return--message:ReturnCallback:{0},{1},{2},{3},{4},{5}", message, replyCode, replyText, exchange, routingKey));
            String correlationId = new String(message.getMessageProperties().getCorrelationId(),"UTF-8");
            BdcMessageLog bdcMessageLog = bdcMessageLogService.getBdcMessageLogById(correlationId);
            Date curHMSDate = CalendarUtil.getCurHMSDate();
            if(bdcMessageLog != null){
                bdcMessageLog.setFszt(Constants.MESSAGE_FSZT_WFS);
                bdcMessageLog.setGxsj(curHMSDate);
                bdcMessageLogService.saveOrUpdateBdcMessageLog(bdcMessageLog);
                logger.info("update message send status ==="+ JSON.toJSONString(bdcMessageLog));
            }
        }catch (Exception e) {
            logger.error("message return callback exception："+e);
        }
    }
}
