package cn.gtmap.estateplat.config.service.core;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.model.server.core.Xmxx;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/4/20
 * @description 通用操作
 */
public interface ProjectGeneralService {
    /**
     * @param xmxx 项目信息
     * @return 返回工作流实例
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/27
     * @description 根据项目信息创建工作流项目
     */
    PfWorkFlowInstanceVo createWorkflowInstance(Xmxx xmxx);

    /**
     * @param wiid 工作流实例ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/27
     * @description 删除工作流实例
     */
    void deleteWorkflowInstance(String wiid);

    /**
     * @param xmxx
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 创建不动产登记项目，包括项目信息BDC_XM,收件信息BDC_SJXX,收件材料BDC_SJCL,审批信息BDC_SPXX,
     */
    void createProject(Xmxx xmxx);

    /**
     * @param wiid   工作流实例ID
     * @param taskId 任务ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/27
     * @description 自动生成项目审批签名
     */
    void createProjectSignature(String wiid, String taskId);

    /**
     * @param proid 工作流实例ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/27
     * @description 删除生成项目审批签名
     */
    void deleteProjectSignature(String proid);


    /**
     * @param wiid       工作流项目ID
     * @param activityId 退回后活动ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 撤回或取回不动产登记项目，
     * 如果已生成证书，返回到缮证前，则删除证书、更新占用的证书编号信息（使用状态、使用人和使用时间等），上一手权利权属状态。
     * 如果已生成电子签名，返回到审核前，则删除签名
     * 如果已登簿，返回到登簿前，则删除登簿信息
     */
    void retreatProject(String wiid, String activityId);


    /**
     * @param wiid 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 流转不动产登记项目，证书编号使用情况和状态，不动产登记项目状态，创建项目证书、登簿情况（人和时间）、
     * 缮证人和时间、抵押注销登簿人和注销登簿时间
     */
    void transmitProject(String wiid, String taskid, String userid);

    /**
     * @param wiid 工作流项目ID
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/27
     * @description 对不动产登记项目的证书进行缮证，生成证书编号，缮证人和时间等
     */
    void certificateProject(String wiid, String userid);

    /**
     * @param wiid 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 办完不动产登记项目，更新项目状态、项目权属状态、上一手权属状态（包括过渡数据权属状态）、权利附记信息、
     * 证书编号使用情况、自动归档
     */
    void completeProject(String wiid, String userid);


    /**
     * @param wiid 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 删除项目信息，包括项目所涉及的BDC_XM,BDC_SJXX,BDC_SJCL,BDC_SPXX，BDC_QLR,BDC_ZS,BDC_BDCDY,BDC_DJB
     */
    void deleteProject(String wiid);

    /**
     * @param wiid 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 更新项目状态，主要是项目办理状态
     */
    void updateProjectStatus(String wiid);

    /**
     * @param wiid 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 生成项目的证书信息
     */
    void generateProjectZs(String wiid);


    /**
     * @param wiid   工作流项目ID
     * @param taskId 当前工作流活动任务ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 验证不动产登记项目，包括必填项，存储值的正确性和限制条件等
     */
    String validateProject(String wiid, String taskId, String activityid) throws AppException;

    /**
     * @param wiid 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/27
     * @description 对不动产登记项目的证书发证，生成发证人和时间等
     */
    void takeProject(String wiid, String userid);

    /**
     * @param wiid 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/27
     * @description 更新项目状态
     */
    void takeProjectXmzt(String wiid);

    /**
     * @param project
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @rerutn Project
     * @description 初始化不动产数据
     */
    Project initBdcDataToBdcXmRel(Project project);

    /**
     * @param wiid 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/27
     * @description 撤回项目状态
     */
    void retreatProjectXmzt(String wiid);

    /**
     * @param wiid 退回后活动ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 撤回或取回登簿，
     * 如果已生成证书，返回到缮证前，则删除证书、更新占用的证书编号信息（使用状态、使用人和使用时间等）。
     * 如果已登簿，返回到登簿前，则删除登簿信息
     */
    void retreatCertificateProject(String wiid);


    /**
     * @param wiid   工作流id
     * @param userid 用户id
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 登簿人登簿时间更新
     */
    void turnProjectEventDbr(String wiid, String userid);


    /**
     * @param
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 选择不动产单元验证
     */
    List<Map<String, Object>> validateBdcXm(Project project);

    /**
     * @param
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 更新工作流
     */
    void updateWorkFlow(final Xmxx xmxx);


    /**
     * @param proid                项目ID
     * @param userid               用户ID
     * @param activityid           当前活动ID
     * @param targetActivityDefids 目标活动定义ID
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 针对工作流活动取回或退回的签名意见处理
     */
    void handleRetreatSign(final String proid, final String userid, final String activityid, final String targetActivityDefids);

}
