package cn.gtmap.estateplat.config.service.core.impl;

import cn.gtmap.estateplat.config.core.service.BdcXmRelService;
import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.core.service.BdcZsService;
import cn.gtmap.estateplat.config.service.core.ProjectCustomService;
import cn.gtmap.estateplat.config.service.core.ProjectGeneralService;
import cn.gtmap.estateplat.config.service.core.ProjectLifeManageService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.config.utils.PlatformUtil;
import cn.gtmap.estateplat.config.utils.WorkFlowXml;
import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.model.server.core.*;

import cn.gtmap.estateplat.service.config.RedundantFieldService;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;


/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/4/20
 * @description 项目生命周期管理服务
 */
@Service
public class ProjectLifeManageServiceImpl implements ProjectLifeManageService {
    @Autowired
    private ProjectCustomServiceContext projectCustomServiceContext;
    @Autowired
    ProjectGeneralService projectGeneralService;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    BdcZsService bdcZsService;
    @Autowired
    BdcXmRelService bdcXmRelService;
    @Autowired
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    private PlatformUtil platformUtil;
    @Autowired
    private RedundantFieldService  redundantFieldService;


    /**
     * @param xmxx 项目信息
     * @return 返回工作流实例
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/27
     * @description 根据项目信息创建工作流项目
     */
    @Override
    public PfWorkFlowInstanceVo createWorkflowInstance(Xmxx xmxx) {
        //创建工作流项目前先验证是否所有限制条件都不满足
//        if (validateProject("", "")) {
//
//        }
        return null;
    }

    /**
     * @param xmxx 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 创建不动产登记项目
     */
    @Override
    public void createProject(Xmxx xmxx) {
        projectGeneralService.createProject(xmxx);
    }

    /**
     * @param taskInfo 项目信息
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 初始化不动产登记项目
     */
    @Override
    public void initializeProject(TaskInfo taskInfo) {

        Project project = new Project();
        bdcXmService.getProjectFromTaskInfo(taskInfo, project);
        //初始化不动产数据
        project = projectGeneralService.initBdcDataToBdcXmRel(project);

        bdcXmService.getTaskInfoFromProject(taskInfo, project);
        ProjectCustomService projectCustomService = projectCustomServiceContext.getDjServiceByWiid(project.getWiid());
        if (projectCustomService != null) {
            projectCustomService.initializeProject(taskInfo);
        }
    }


    /**
     * @param wiid       工作流项目ID
     * @param activityId 退回后活动ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 撤回或取回不动产登记项目，
     * 如果已生成证书，返回到缮证前，则删除证书、更新占用的证书编号信息（使用状态、使用人和使用时间等），上一手权利权属状态。
     * 如果已生成电子签名，返回到审核前，则删除签名
     * 如果已登簿，返回到登簿前，则删除登簿信息
     */
    @Override
    public void retreatProject(String wiid, String activityId, String taskid, String userid, String targetActivityDefids) {
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(wiid);
        if (pfWorkFlowInstanceVo != null) {
            //获取转发时节点描述
            WorkFlowXml xml = platformUtil.getWorkFlowInstanceModel(pfWorkFlowInstanceVo);
            PfActivityVo pfActivityVo = platformUtil.getPfActivityVoByActivitId(activityId);
            String activitDescribeName = platformUtil.getPfActivityDescribeByXml(xml, pfActivityVo.getActivityDefinitionId());

            //String activityName = platformUtil.getPfActivityNameByActivitId(activityId);
            if (CommonUtil.indexOfStrs(Constants.WORKFLOW_SZDB, activitDescribeName)) {
                //撤回上一手权利状态
                ProjectCustomService projectCustomService = projectCustomServiceContext.getDjServiceByWiid(wiid);
                if (projectCustomService != null) {
                    projectCustomService.revertProjectQszt(wiid);
                }
                //撤回项目状态
                projectGeneralService.retreatProjectXmzt(wiid);
                //如果已登簿，返回到登簿前，则删除登簿信息
                projectGeneralService.retreatCertificateProject(wiid);
            } else if (StringUtils.equals(activitDescribeName, Constants.WORKFLOW_FZ)) {
                //发证退回删除证书表缮证人、缮证日期、发证人、发证日期，领证人、领证人证件号
                bdcZsService.backDelSzrByWiid(wiid);
            }
            //如果已生成电子签名，返回到审核前，则删除签名
            projectGeneralService.handleRetreatSign(pfWorkFlowInstanceVo.getProId(), userid, activityId, targetActivityDefids);
        }
        //通用操作
        projectGeneralService.retreatProject(wiid, activityId);
    }

    /**
     * @param wiid 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 流转不动产登记项目，证书编号使用情况和状态，不动产登记项目状态，创建项目证书、登簿情况（人和时间）、
     * 缮证人和时间、抵押注销登簿人和注销登簿时间以及验证项目
     */
    @Override
    public void transmitProject(String proid,String wiid, String taskid, String targetActivityDefids, String userid, String activityid) throws Exception {


        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(wiid);
        if (pfWorkFlowInstanceVo != null) {
            //获取转发后节点描述
            WorkFlowXml xml = platformUtil.getWorkFlowInstanceModel(pfWorkFlowInstanceVo);
            String targetActivitDescribeName = platformUtil.getPfActivityDescribeByXml(xml, targetActivityDefids);

            //获取转发时节点描述
            PfActivityVo pfActivityVo = platformUtil.getPfActivityVoByActivitId(activityid);
            String activitDescribeName = platformUtil.getPfActivityDescribeByXml(xml, pfActivityVo.getActivityDefinitionId());

            if (StringUtils.isNotBlank(targetActivitDescribeName) && CommonUtil.indexOfStrs(Constants.WORKFLOW_SZDB, targetActivitDescribeName)) {
                // 转发到缮证节点
                //生成证书
                generateProjectZs(wiid);
                //更新登簿操作
                registerProject(wiid, userid);
                //调用处理冗余字段方法
                redundantFieldService.synchronizationBdcField(proid);

            } else if (StringUtils.isNotBlank(targetActivitDescribeName) && StringUtils.equals(targetActivitDescribeName, Constants.WORKFLOW_FZ)) {
                //更新缮证人和时间
                certificateProject(wiid, userid);

            }
            if (StringUtils.equals(activitDescribeName, Constants.WORKFLOW_FZ)) {
                //更新发证人
                projectGeneralService.takeProject(wiid, userid);
            }
            //通用操作
            projectGeneralService.transmitProject(wiid, taskid, userid);
        }

    }

    /**
     * @param wiid   工作流项目ID
     * @param taskId 当前工作流活动任务ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 验证不动产登记项目，包括必填项，存储值的正确性和限制条件等
     */
    @Override
    public String validateProject(String wiid, String taskId, String activityid) throws AppException {
        return projectGeneralService.validateProject(wiid, taskId, activityid);
    }

    /**
     * @param wiid 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/27
     * @description 对不动产登记项目进行登簿操作，包括修改不动产权利权属状态、上一手权属状态，登簿人和时间等
     */
    @Override
    public void registerProject(String wiid, String userid) throws Exception {
        ProjectCustomService projectCustomService = projectCustomServiceContext.getDjServiceByWiid(wiid);
        //更新权属状态、上一手权属状态（包括过渡数据权属状态）
        projectCustomService.updateProjectQszt(wiid, userid);
//        对不动产登记项目的证书发证，生成发证人和时间等
//        projectGeneralService.takeProject(wiid);
        //更新项目状态
//        projectGeneralService.takeProjectXmzt(wiid);
        //更新登簿人/时间
        projectGeneralService.turnProjectEventDbr(wiid, userid);
    }

    /**
     * @param wiid 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/27
     * @description 对不动产登记项目的证书进行缮证，生成证书编号，缮证人和时间等
     */
    @Override
    public void certificateProject(String wiid, String userid) {
        projectGeneralService.certificateProject(wiid, userid);
    }

    /**
     * @param wiid 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 办完不动产登记项目，更新项目状态、项目权属状态、上一手权属状态（包括过渡数据权属状态）、权利附记信息、
     * 证书编号使用情况、自动归档
     */
    @Override
    public void completeProject(String wiid, String userid) throws Exception {
        //办完不动产登记项目，更新项目状态、项目权属状态
        projectGeneralService.completeProject(wiid, userid);
        //更新权属状态、上一手权属状态（包括过渡数据权属状态）
        ProjectCustomService projectCustomService = projectCustomServiceContext.getDjServiceByWiid(wiid);
        projectCustomService.updateProjectQszt(wiid, userid);
    }

    /**
     * @param wiid 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 删除不动产登记项目，包括项目所占用的证书编号，上一手权属状态（包括过渡数据权属状态），不动产项目项目，BDC_XM,BDC_SJXX,BDC_SJCL,
     * BDC_SPXX,不动产权利信息，BDC_QLR,BDC_ZS,BDC_BDCDY,BDC_DJB，不动产项目附件信息、工作流项目信息
     */
    @Override
    public void deleteProject(String wiid) {
        //根据类型删除，改变上一手权属状态，删除本项目权利信息
        ProjectCustomService projectCustomService = projectCustomServiceContext.getDjServiceByWiid(wiid);
        projectCustomService.revertYqlxx(wiid);
        projectCustomService.deleteProjectQlxx(wiid);
        //删除统一的项目相关信息
        projectGeneralService.deleteProject(wiid);
    }

    /**
     * @param wiid 工作流项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 生成项目的证书信息
     */
    @Override
    public void generateProjectZs(String wiid) throws AppException {
        projectGeneralService.generateProjectZs(wiid);
    }

    @Override
    public List<Map<String, Object>> validateBdcXm(Project project) {
        return projectGeneralService.validateBdcXm(project);

    }

    @Override
    public void updateWorkFlow(final Xmxx xmxx) {
        projectGeneralService.updateWorkFlow(xmxx);
    }


}
