package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.BdcZjjzwxxService;
import cn.gtmap.estateplat.config.core.service.BdcdyService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.model.server.core.BdcBdcdy;
import cn.gtmap.estateplat.model.server.core.BdcZjjzwxx;
import cn.gtmap.estateplat.model.server.core.Project;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:songhaowen@gtmap.cn">ray</a>
 * @version 1.0, ${date}
 * @description 不动产登记服务
 */
public class BdcFwOfTdHasZjgcdyValidateServiceImpl implements ProjectValidateService {
    @Autowired
    private BdcZjjzwxxService bdcZjjzwxxService;
    @Autowired
    private BdcdyService bdcdyService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        Map<String, Object> map = new HashMap<String, Object>();
        Map<String, Object> queryParam = new HashMap<String, Object>();
        List<String> proidList = null;
        if (project != null && StringUtils.isNotBlank(project.getBdcdyh())) {
            List<BdcZjjzwxx> bdcZjjzwxxLst = null;
            String zdzhh = project.getBdcdyh().substring(0, 19);
            List<BdcBdcdy> bdcBdcdyList = bdcdyService.getBdcdyByZdzhh(zdzhh, Constants.BDCLX_TDZJGZW);
            if (CollectionUtils.isNotEmpty(bdcBdcdyList)) {
                for (BdcBdcdy bdcBdcdy : bdcBdcdyList) {
                    bdcZjjzwxxLst = bdcZjjzwxxService.getBdcZjjzwxxByBdcdyh(bdcBdcdy.getBdcdyh());
                    if (CollectionUtils.isNotEmpty(bdcZjjzwxxLst)) {
                        proidList = new LinkedList<String>();
                        for (BdcZjjzwxx bdcZjjzwxx : bdcZjjzwxxLst) {
                            proidList.add(bdcZjjzwxx.getProid());
                        }
                        break;
                    }
                }
            }

        }
        map.put("info", CollectionUtils.isNotEmpty(proidList) ? proidList : null);
        return map;
    }

    @Override
    public String getCode() {
        return "139";
    }

    @Override
    public String getDescription() {
        return "验证土地对应的房屋是否有在建工程抵押";
    }
}
