package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.BdcZsSdService;
import cn.gtmap.estateplat.config.core.service.BdcZsService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.model.server.core.BdcBdcZsSd;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.model.server.core.Project;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:lijian@gtmap.cn">lijian</a>
 * @version 1.0, 2016/9/21
 * @description 证书证明锁定验证
 */
public class BdcZsSdValidateServiceImpl implements ProjectValidateService {
    @Autowired
    private BdcZsService bdcZsService;
    @Autowired
    private BdcZsSdService bdcZsSdService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        Map<String, Object> map = new HashMap<String, Object>();
        List<String> proidList = null;
        String xzyy = "";
        if (project != null && StringUtils.isNotBlank(project.getYxmid())) {
            List<BdcZs> bdcZsList = bdcZsService.getBdcZsByProid(project.getYxmid());
            List<BdcBdcZsSd> list = null;
            if (CollectionUtils.isNotEmpty(bdcZsList)) {
                List<String> zsids = new ArrayList<String>();
                for (BdcZs bdcZs : bdcZsList) {
                    zsids.add(bdcZs.getZsid());
                }
                HashMap queryMap = new HashMap();
                queryMap.put("zsids", zsids);
                queryMap.put("xzzt", Constants.XZZT_SD);
                list = bdcZsSdService.getBdcZsSdList(queryMap);
            }
            if (list != null && list.size() > 0) {
                proidList = new ArrayList<String>();
                for (int i = 0; i < list.size(); i++) {
                    proidList.add(list.get(i).getProid());
                }
                xzyy = list.get(0).getXzyy();
            }
        }
        map.put("info", proidList);
        map.put("tsinfo", xzyy);
        return map;
    }

    /**
     * @return 获取此验证逻辑的代码编号
     * @author <a href="mailto:lijian@gtmap.cn">lijian</a>
     * @version 1.0, 2016/9/21
     * @description 获取此验证逻辑的代码编号
     */
    @Override
    public String getCode() {
        return "204";
    }

    /**
     * @return 获取此验证逻辑的描述信息
     * @author <a href="mailto:lijian@gtmap.cn">lijian</a>
     * @version 1.0, 2016/9/21
     * @description 获取此验证逻辑的描述信息
     */
    @Override
    public String getDescription() {
        return "验证产权证是否锁定";
    }
}
