package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.BdcCfService;
import cn.gtmap.estateplat.config.core.service.BdcXmRelService;
import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.model.server.core.BdcCf;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXmRel;
import cn.gtmap.estateplat.model.server.core.Project;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hqz
 * @version 1.0, 2016/12/26
 * @description 验证不动产单元是否裁定
 */
public class BdcdyCdQxValidateServiceImpl implements ProjectValidateService {

    @Autowired
    BdcXmService bdcXmService;

    @Autowired
    private BdcXmRelService bdcXmRelService;

    @Autowired
    private BdcCfService bdcCfService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        Map<String, Object> map = new HashMap<String, Object>();
        List<String> proidList = new ArrayList<String>();
        List<String> cdProidList = new ArrayList<String>();
        if (StringUtils.isNotBlank(project.getBdcdyh())) {
            String bdcdyh = project.getBdcdyh();
            List<BdcXm> bdcXmList = bdcXmService.getBdcXmByBdcdyh(bdcdyh);
            if (CollectionUtils.isNotEmpty(bdcXmList)) {
                for (BdcXm bdcXm : bdcXmList) {
                    if (StringUtils.isNotBlank(bdcXm.getSqlx()) && StringUtils.equals(bdcXm.getSqlx(), Constants.SQLX_SFCD)) {
                        cdProidList.add(bdcXm.getProid());
                    }
                }
                if (CollectionUtils.isNotEmpty(cdProidList)) {
                    for (String cdProid : cdProidList) {
                        if (StringUtils.isNotBlank(cdProid)) {
                            BdcCf bdcCf = bdcCfService.getXsBdcCfByProid(cdProid);
                            if (bdcCf != null)
                                proidList.add(bdcCf.getProid());
                            List<BdcXmRel> bdcXmRelList = bdcXmRelService.getBdcXmRelByProid(cdProid);
                            if (CollectionUtils.isNotEmpty(bdcXmRelList)) {
                                for (BdcXmRel bdcXmRel : bdcXmRelList) {
                                    String yproid = bdcXmRel.getYproid();
                                    if (StringUtils.isNotBlank(yproid)) {
                                        bdcCf = bdcCfService.getXsBdcCfByProid(cdProid);
                                        if (bdcCf != null)
                                            proidList.add(bdcCf.getProid());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(proidList))
            map.put("info", proidList.get(0));
        else
            map.put("info", null);
        return map;
    }

    /**
     * @return 获取此验证逻辑的代码编号
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的代码编号
     */
    @Override
    public String getCode() {
        return "136";
    }

    /**
     * @return 获取此验证逻辑的描述信息
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的描述信息
     */
    @Override
    public String getDescription() {
        return "验证不动产单元是否是裁定状态";
    }
}
