package cn.gtmap.estateplat.config.service.core.impl.validator;
/*
 * @author <a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
 * @version 1.0, 2017/3/15
 * @description 验证当依据法律文书转移时的权利人是否是裁定的被转移人
 */

import cn.gtmap.estateplat.config.core.service.BdcQlrService;
import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.Project;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BdcdyCdZyrValidateServiceImpl implements ProjectValidateService {
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    BdcQlrService bdcQlrService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        Map<String, Object> map = new HashMap<String, Object>();
        List<String> ProidList = new ArrayList<String>();
        if (StringUtils.isNotBlank(project.getBdcdyh())) {
            String bdcdyh = project.getBdcdyh();
            // 获取申请裁定转移登记项目的proid
            String cdzyproid = project.getProid();
            //获取最后一次的裁定解封项目的proid
            List<BdcXm> bdcXmList = bdcXmService.getCdBdcXmByBdcdyh(bdcdyh);
            if (CollectionUtils.isNotEmpty(bdcXmList)) {
                //获取最后一次裁定解封的义务人
                List<Map> bdcYwrList = bdcQlrService.getQlrMcAndQlrZjhByProid(bdcXmList.get(0).getProid(), Constants.QLRLX_YWR);
                if (CollectionUtils.isNotEmpty(bdcYwrList)) {
                    //获取裁定转移登记的权利人
                    if (StringUtils.isNotBlank(cdzyproid)) {
                        //判断裁定转移的权利人是否存在裁定解封的义务人
                        List<Map> bdcQlrList = bdcQlrService.getQlrMcAndQlrZjhByProid(cdzyproid, Constants.QLRLX_QLR);
                        boolean contains = bdcQlrList.containsAll(bdcYwrList);
                        if (!contains) {
                            ProidList.add(bdcXmList.get(0).getProid());
                        }
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(ProidList))
            map.put("info", ProidList.get(0));
        else
            map.put("info", null);
        return map;
    }

    @Override
    public String getCode() {
        return "140";
    }

    @Override
    public String getDescription() {
        return "验证当依据法律文书转移时的权利人是否是裁定的被转移人";
    }
}
