package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.BdcCfService;
import cn.gtmap.estateplat.config.core.service.BdcXmRelService;
import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.core.service.GdCfService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcCf;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.GdCf;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.utils.CommonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
 * @version 1.0, 2016/7/29
 * @description 查封期限验证服务，只在任务转发验证
 */
public class BdcdyCfQxValidateServiceImpl implements ProjectValidateService {


    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    GdCfService gdCfService;
    @Autowired
    private BdcXmRelService bdcXmRelService;
    @Autowired
    private BdcCfService bdcCfService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        Map<String, Object> map = new HashMap<String, Object>();
        List<String> proidList = new ArrayList<String>();
        String msg = "";
        if (project != null && StringUtils.isNotBlank(project.getProid()) && StringUtils.equals(project.getDjzx(), Constants.DJZX_XF)) {
            BdcCf bdcCf = null;
            BdcCf ybdccf = null;
            String proid = project.getProid();
            //不动产现势查封
            BdcXm bdcXm = entityMapper.selectByPrimaryKey(BdcXm.class, proid);
            if (bdcXm != null) {
                bdcCf = bdcCfService.getXsBdcCfByProid(bdcXm.getProid());
            }
            String yProid = bdcXmRelService.getYproid(proid);
            //获取不动产原不动产现势查封
            if (StringUtils.isNotBlank(yProid)) {
                ybdccf = bdcCfService.getBdcCfByProid(yProid);
            }

            //获取过渡不动产查封权利
            List<GdCf> gdCfList = gdCfService.getGdCfByProid(yProid, null);

            if (bdcCf != null && ybdccf != null) {
                if (bdcCf.getCfjsqx() != null && bdcCf.getCfksqx() != null && ybdccf.getCfjsqx() != null && ybdccf.getCfksqx() != null) {
                    Long daycf = CommonUtil.getDaySub(bdcCf.getCfksqx(), bdcCf.getCfjsqx());
                    Long dayycf = CommonUtil.getDaySub(ybdccf.getCfksqx(), ybdccf.getCfjsqx());
                    int daysIntCf = daycf.intValue() - 1;
                    int daysIntyCf = dayycf.intValue() - 1;
                    if (daysIntCf > daysIntyCf) {
                        proidList.add(ybdccf.getProid());
                    }
                }
            } else if (bdcCf != null && CollectionUtils.isNotEmpty(gdCfList)) {
                GdCf gdCf = gdCfList.get(0);
                if (bdcCf.getCfjsqx() != null && bdcCf.getCfksqx() != null && gdCf.getCfjsrq() != null && gdCf.getCfksrq() != null) {
                    Long daycf = CommonUtil.getDaySub(bdcCf.getCfksqx(), bdcCf.getCfjsqx());
                    Long dayycf = CommonUtil.getDaySub(gdCf.getCfksrq(), gdCf.getCfjsrq());
                    int daysIntCf = daycf.intValue() - 1;
                    int daysIntyCf = dayycf.intValue() - 1;
                    if (daysIntCf > daysIntyCf) {
                        proidList.add(gdCf.getCfid());
                    }
                }
            }
            if (StringUtils.isNotBlank(msg)) {
                proidList.add(msg);
            }
        }
        if (CollectionUtils.isNotEmpty(proidList))
            map.put("info", proidList);
        else
            map.put("info", null);
        return map;
    }

    /**
     * @return 获取此验证逻辑的代码编号
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的代码编号
     */
    @Override
    public String getCode() {
        return "101";
    }

    /**
     * @return 获取此验证逻辑的描述信息
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的描述信息
     */
    @Override
    public String getDescription() {
        return "验证不动产单元是否查封";
    }
}
