package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.BdcComplexFgHbHzService;
import cn.gtmap.estateplat.config.core.service.QllxParentService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.model.server.core.BdcCf;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.model.server.core.QllxParent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/7/29
 * @description 不动产单元查封验证服务
 */
public class BdcdyCfValidateServiceImpl implements ProjectValidateService {
    /**
     * @param project 项目信息
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 验证项目有效性，使用不动产单元验证不动产登记库
     */

    @Autowired
    private QllxParentService qllxParentService;
    @Autowired
    private BdcComplexFgHbHzService bdcComplexFgHbHzService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        Map<String, Object> map = new HashMap<String, Object>();
        List<String> proidList = null;
        List<QllxParent> list = null;
        if (project != null && StringUtils.isNotBlank(project.getBdcdyh())) {
            //jiangganzhi 土地分割、合并换证登记，分割前的证书已经查封了，选择分割后的不动产单元进行登记需要验证查封
            if (StringUtils.isNotBlank(project.getSqlx()) && StringUtils.equals(project.getSqlx(), Constants.SQLX_TDFGHBHZ_DM))
                list = bdcComplexFgHbHzService.getYzdCf(project.getBdcdyh());

            if (CollectionUtils.isEmpty(list))
                list = qllxParentService.queryLogcfQllxVo(new BdcCf(), project.getBdcdyh(), "", "false");
            if (list != null && list.size() > 0) {
                proidList = new ArrayList<String>();
                for (QllxParent qllxParent : list) {
                    proidList.add(qllxParent.getProid());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(proidList))
            map.put("info", proidList);
        else
            map.put("info", null);
        return map;
    }

    /**
     * @return 获取此验证逻辑的代码编号
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的代码编号
     */
    @Override
    public String getCode() {
        return "101";
    }

    /**
     * @return 获取此验证逻辑的描述信息
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的描述信息
     */
    @Override
    public String getDescription() {
        return "验证不动产单元是否查封";
    }
}
