package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.GdBdcQlRelService;
import cn.gtmap.estateplat.config.core.service.GdDyService;
import cn.gtmap.estateplat.config.core.service.GdFwService;
import cn.gtmap.estateplat.config.core.service.QllxParentService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.model.server.core.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:wangming@gtmap.cn">  wangming </a>
 * @version 1.0, 2016/10/19
 * @description 带抵押转移，必须存在抵押情况
 */
public class BdcdyCreatDDyzyValidateServiceImpl implements ProjectValidateService {

    @Autowired
    GdBdcQlRelService gdBdcQlRelService;
    @Autowired
    GdDyService gdDyService;
    @Autowired
    private QllxParentService qllxParentService;
    @Autowired
    private GdFwService gdFwService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        Map<String, Object> map = new HashMap<String, Object>();
        List<String> proidList = null;
        if (project != null && StringUtils.isNotBlank(project.getBdcdyh())) {
            //查找正式库的抵押数据
            List<QllxParent> bdcDyaqList = null;
            if (StringUtils.isNotBlank(project.getBdcdyh())) {
                HashMap queryMap = new HashMap();
                queryMap.put("bdcdyh", project.getBdcdyh());
                queryMap.put("qszt", "1");
                bdcDyaqList = qllxParentService.queryQllxVo(new BdcDyaq(), queryMap);
            }
            //查过过渡库的抵押数据
            List<GdDy> gdDyList = null;
            if (StringUtils.isNotBlank(project.getGdproid()) || StringUtils.isNotBlank(project.getYxmid())) {
                List<GdFwsyq> gdFwsyqList = gdFwService.getGdFwsyqListByGdproid(project.getGdproid(), null);
                if (CollectionUtils.isEmpty(gdFwsyqList)) {
                    gdFwsyqList = gdFwService.getGdFwsyqListByGdproid(project.getYxmid(), null);
                }
                if (CollectionUtils.isNotEmpty(gdFwsyqList)) {
                    gdDyList = new ArrayList<GdDy>();
                    if (StringUtils.isNotBlank(gdFwsyqList.get(0).getQlid())) {
                        List<GdBdcQlRel> gdBdcQlRelList = gdBdcQlRelService.queryGdBdcQlListByQlid(gdFwsyqList.get(0).getQlid());
                        if (CollectionUtils.isNotEmpty(gdBdcQlRelList)) {
                            GdBdcQlRel gdBdcQlRel = gdBdcQlRelList.get(0);
                            List<GdBdcQlRel> gdBdcQlRelList1 = gdBdcQlRelService.getGdBdcQlRelListByBdcid(gdBdcQlRel.getBdcid());
                            if (CollectionUtils.isNotEmpty(gdBdcQlRelList1)) {
                                for (GdBdcQlRel gdBdcQlRel1 : gdBdcQlRelList1) {
                                    GdDy gdDy = gdDyService.getGdDyByQlidAndIsjy(gdBdcQlRel1.getQlid(), "0");
                                    if (gdDy != null)
                                        gdDyList.add(gdDy);
                                }
                            }
                        }
                    }
                }
            }
            if (CollectionUtils.isEmpty(bdcDyaqList) && CollectionUtils.isEmpty(gdDyList)) {
                proidList = new ArrayList<String>();
                if (CollectionUtils.isNotEmpty(bdcDyaqList)) {
                    proidList.add(bdcDyaqList.get(0).getProid());
                } else {
                    proidList.add("false");
                }
                map.put("infos", "false");
            }
        }
        return map;
    }

    @Override
    public String getCode() {
        return "129";
    }

    @Override
    public String getDescription() {
        return "带抵押转移，必须存在抵押情况";
    }
}
