package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.DjsjService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.model.server.core.DjsjFwYcHs;
import cn.gtmap.estateplat.model.server.core.Project;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:wangming@gtmap.cn">  wangming </a>
 * @version 1.0, 2016/10/20
 * @description 验证在建工程抵押，权籍数据是否处于抵押状态
 */
public class BdcdyFwYcHsIsDyValidateServiceImpl implements ProjectValidateService {

    @Autowired
    private DjsjService djsjService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Map<String, Object> map = new HashMap<String, Object>();
        Project project = (Project) param.get("project");
        List<String> proidList = new ArrayList<String>();
        HashMap temparam = new HashMap();
        param.put("bdcdyh", project.getBdcdyh());
        List<DjsjFwYcHs> ycFwHsList = djsjService.getDjsjFwYcHsListByBdcdyh(project.getBdcdyh());
        if (CollectionUtils.isNotEmpty(ycFwHsList)) {
            String zjgcdy = ycFwHsList.get(0).getZjgcdy();
            if (StringUtils.equals(zjgcdy, "0")) {
                proidList.add(ycFwHsList.get(0).getFwHsIndex());
            }
            if (CollectionUtils.isNotEmpty(proidList))
                map.put("info", proidList.get(0));
            else
                map.put("info", null);
        }
        return map;
    }

    @Override
    public String getCode() {
        return "134";
    }

    @Override
    public String getDescription() {
        return "验证在建工程抵押，权籍数据是否处于抵押状态";
    }
}
