package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
 * @version 1.0, 2016/7/29
 * @description 过渡房屋是否存在查封登记
 */
public class BdcdyGdCfValidateServiceImpl implements ProjectValidateService {
    @Autowired
    BdcZjjzwxxService bdcZjjzwxxService;
    @Autowired
    GdFwService gdFwService;
    @Autowired
    GdBdcQlRelService gdBdcQlRelService;
    /**
     * @param project 项目信息
     * @return
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @version 1.0, 2016/7/29
     * @description 验证项目有效性
     */

    @Autowired
    private BdcXmRelService bdcXmRelService;
    @Autowired
    private BdcCfService bdcCfService;
    @Autowired
    private GdXmService gdXmService;
    @Autowired
    private BdcGdDyhRelService bdcGdDyhRelService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private GdTdService gdTdService;
    @Autowired
    private GdCfService gdCfService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        Map<String, Object> map = new HashMap<String, Object>();
        List<String> proidList = new ArrayList<String>();
        String bdcid = "";
        String gdproid = "";
        if (project != null && StringUtils.isNotBlank(project.getGdproid())) {
            gdproid = project.getGdproid();
            List<String> bdcidList = gdXmService.getGdBdcidByProid(project.getGdproid());
            if (CollectionUtils.isNotEmpty(bdcidList))
                bdcid = bdcidList.get(0);
        }
        if (project != null && StringUtils.isNotBlank(bdcid)) {
            /**
             * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
             * @description 重新写了g根据不动产id查询过度查封、抵押
             */
            List<GdCf> gdCfList = gdCfService.getGdCfListByBdcidAndZxzt(bdcid, "0");
            if (CollectionUtils.isNotEmpty(gdCfList)) {
                proidList.add(gdCfList.get(0).getCfid());
            }
        }
        /**
         * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
         * @description 考虑匹配界面查封可能不匹配不动产单元创建，下面代码则是判断没有匹配不动产单元验证是否有查封
         */
        if (CollectionUtils.isEmpty(proidList) && StringUtils.isNotBlank(gdproid)) {
            List<BdcGdDyhRel> bdcGdDyhRelList = bdcGdDyhRelService.getGdDyhRelByGdproid(gdproid);
            for (BdcGdDyhRel bdcGdDyhRel : bdcGdDyhRelList) {
                if (StringUtils.isBlank(bdcGdDyhRel.getBdcdyh())) {
                    List<BdcXmRel> bdcXmRelList = bdcXmRelService.getBdcXmRelByYproidAndBdcdyh(gdproid, null);
                    if (CollectionUtils.isNotEmpty(bdcXmRelList)) {
                        for (BdcXmRel bdcXmRel : bdcXmRelList) {
                            BdcCf bdcCf = bdcCfService.getBdcCfByProid(bdcXmRel.getProid());
                            if (bdcCf != null && bdcCf.getJfdjsj() == null) {
                                proidList.add(bdcCf.getQlid());
                            }
                        }
                    }
                }
            }
        }

        //判断已匹配的房屋土地证是否被查封
        String gdProid = project.getGdproid();
        if (StringUtils.isNotBlank(gdProid)) {
            List<String> qlidList = gdFwService.getGdFwQlidsByProid(gdProid);
            if (CollectionUtils.isNotEmpty(qlidList)) {
                for (String qlid : qlidList) {
                    List<GdBdcQlRel> gdBdcQlRelList = gdBdcQlRelService.queryGdBdcQlListByQlid(qlid);

                    if (CollectionUtils.isNotEmpty(gdBdcQlRelList)) {
                        for (GdBdcQlRel gdBdcQlRel : gdBdcQlRelList) {
                            List<BdcGdDyhRel> bdcGdDyhRelList = bdcGdDyhRelService.getGdDyhRelListByGdid(gdBdcQlRel.getBdcid());
                            if (CollectionUtils.isNotEmpty(bdcGdDyhRelList)) {
                                for (BdcGdDyhRel bdcGdDyhRel : bdcGdDyhRelList) {
                                    if (StringUtils.isNotBlank(bdcGdDyhRel.getTdid())) {
                                        //查询gd_cf
                                        List<GdCf> gdCfList = gdCfService.getGdCfListByBdcidAndZxzt(bdcGdDyhRel.getTdid(), "0");
                                        if (CollectionUtils.isNotEmpty(gdCfList)) {
                                            proidList.add(gdCfList.get(0).getCfid());
                                        }

                                        //查询bdc_cf
                                        Example exampleXmRel = new Example(BdcXmRel.class);
                                        List<GdTdsyq> gdTdsyqList = gdTdService.queryTdsyqByTdid(bdcGdDyhRel.getTdid());

                                        if (CollectionUtils.isNotEmpty(gdTdsyqList)) {
                                            for (GdTdsyq gdTdsyq : gdTdsyqList) {
                                                if (gdTdsyq.getQlid() != null) {
                                                    exampleXmRel.createCriteria().andEqualTo("yqlid", gdTdsyq.getQlid());
                                                    List<BdcXmRel> bdcXmRel = entityMapper.selectByExample(BdcXmRel.class, exampleXmRel);
                                                    if (CollectionUtils.isNotEmpty(bdcXmRel)) {
                                                        for (BdcXmRel bdcXmRel1 : bdcXmRel) {
                                                            BdcCf bdcCf = bdcCfService.getBdcCfByProid(bdcXmRel1.getProid());
                                                            if (bdcCf != null && bdcCf.getQszt() != Constants.QLLX_QSZT_HR) {
                                                                proidList.add(bdcCf.getQlid());
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(proidList)) {
            map.put("info", proidList);
        } else {
            map.put("info", null);
        }
        return map;
    }

    /**
     * @return 获取此验证逻辑的代码编号
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的代码编号
     */
    @Override
    public String getCode() {
        return "102";
    }

    /**
     * @return 获取此验证逻辑的描述信息
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的描述信息
     */
    @Override
    public String getDescription() {
        return "过渡房屋是否存在查封登记";
    }
}
