package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:wangming@gtmap.cn">  wangming </a>
 * @version 1.0, 2016/10/20
 * @description
 */
public class BdcdyGdFwDyValidateServiceImpl implements ProjectValidateService {

    @Autowired
    GdFwService gdFwService;
    @Autowired
    GdBdcQlRelService gdBdcQlRelService;
    @Autowired
    private GdXmService gdXmService;
    @Autowired
    private BdcXmRelService bdcXmRelService;
    @Autowired
    private BdcDyaqService bdcDyaqService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private GdTdService gdTdService;
    @Autowired
    private BdcGdDyhRelService bdcBdcGdDyhRelService;
    @Autowired
    private GdDyService gdDyService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Map<String, Object> map = new HashMap<String, Object>();
        Project project = (Project) param.get("project");
        if (project == null)
            return map;
        List<String> proidList = new ArrayList<String>();
        String bdcid = "";
        if (StringUtils.isNotBlank(project.getGdproid())) {
            List<String> bdcidList = gdXmService.getGdBdcidByProid(project.getGdproid());
            if (CollectionUtils.isNotEmpty(bdcidList))
                bdcid = bdcidList.get(0);
        }
        if (StringUtils.isNotBlank(bdcid)) {
            /**
             * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
             * @description 重新写了g根据不动产id查询过度查封、抵押
             */
            List<GdDy> gdDyList = gdDyService.getGdDyListByBdcidAndZxzt(bdcid, "0");
            //他项证换证不提示
            if (CollectionUtils.isNotEmpty(gdDyList) && !StringUtils.equals(gdDyList.get(0).getDyid(), project.getGdproid()))
                proidList.add(gdDyList.get(0).getDyid());
        }
        /**
         * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
         * @description 考虑匹配界面查封可能不匹配不动产单元创建，下面代码则是判断没有匹配不动产单元验证是否有抵押
         */
        if (CollectionUtils.isEmpty(proidList) && StringUtils.isNotBlank(project.getGdproid())) {
            HashMap map1 = new HashMap();
            map1.put("yproid", project.getGdproid());
            List<BdcXmRel> bdcXmRelList = bdcXmRelService.getBdcXmRelByYproidAndBdcdyh(project.getGdproid(), null);
            if (CollectionUtils.isNotEmpty(bdcXmRelList)) {
                for (BdcXmRel bdcXmRel : bdcXmRelList) {
                    List<BdcDyaq> bdcDyaqList = bdcDyaqService.getBdcDyaqListByProid(bdcXmRel.getProid(), null);
                    if (CollectionUtils.isNotEmpty(bdcDyaqList)) {
                        for (BdcDyaq bdcDyaq : bdcDyaqList) {
                            if (bdcDyaq.getQszt() != null && !Constants.QLLX_QSZT_LS.equals(bdcDyaq.getQszt())) {
                                proidList.add(bdcDyaq.getProid());
                            }
                        }
                    }
                }
            }
        }
        //判断已匹配的房屋土地证是否被查封
        String gdProid = project.getGdproid();
        if (StringUtils.isNotBlank(gdProid)) {
            List<String> qlidList = gdFwService.getGdFwQlidsByProid(gdProid);
            if (CollectionUtils.isNotEmpty(qlidList)) {
                for (String qlid : qlidList) {
                    List<GdBdcQlRel> gdBdcQlRelList = gdBdcQlRelService.queryGdBdcQlListByQlid(qlid);

                    if (CollectionUtils.isNotEmpty(gdBdcQlRelList)) {
                        for (GdBdcQlRel gdBdcQlRel : gdBdcQlRelList) {
                            List<BdcGdDyhRel> bdcGdDyhRelList = bdcBdcGdDyhRelService.getGdDyhRelListByGdid(gdBdcQlRel.getBdcid());
                            if (CollectionUtils.isNotEmpty(bdcGdDyhRelList)) {
                                for (BdcGdDyhRel bdcGdDyhRel : bdcGdDyhRelList) {
                                    if (StringUtils.isNotBlank(bdcGdDyhRel.getTdid())) {
                                        //查询gd_dy
                                        List<GdDy> gdDyList = gdDyService.getGdDyListByBdcidAndZxzt(bdcid, "0");
                                        if (CollectionUtils.isNotEmpty(gdDyList)) {
                                            proidList.add(gdDyList.get(0).getDyid());
                                        }
                                        //查询bdc_dy
                                        Example exampleXmRel = new Example(BdcXmRel.class);
                                        List<GdTdsyq> gdTdsyqList = gdTdService.queryTdsyqByTdid(bdcGdDyhRel.getTdid());

                                        if (CollectionUtils.isNotEmpty(gdTdsyqList)) {
                                            for (GdTdsyq gdTdsyq : gdTdsyqList) {
                                                if (gdTdsyq.getQlid() != null) {
                                                    exampleXmRel.createCriteria().andEqualTo("yqlid", gdTdsyq.getQlid());
                                                    List<BdcXmRel> bdcXmRelList = entityMapper.selectByExample(BdcXmRel.class, exampleXmRel);
                                                    if (CollectionUtils.isNotEmpty(bdcXmRelList)) {
                                                        for (BdcXmRel bdcXmRel : bdcXmRelList) {
                                                            List<BdcDyaq> bdcDyaqList = bdcDyaqService.getBdcDyaqListByProidAndNotQszt(bdcXmRel.getProid(), Constants.QLLX_QSZT_HR.toString());
                                                            if (CollectionUtils.isNotEmpty(bdcDyaqList)) {
                                                                proidList.add(bdcDyaqList.get(0).getQlid());
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        if (CollectionUtils.isNotEmpty(proidList))
            map.put("info", proidList.get(0));
        else
            map.put("info", null);
        return map;
    }

    @Override
    public String getCode() {
        return "107";
    }

    @Override
    public String getDescription() {
        return "验证过渡房屋 是否处于抵押状态";
    }
}
