package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.QllxParentService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.model.server.core.BdcDyaq;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.model.server.core.QllxParent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
 * @version 1.0, 2016/7/29
 * @description 批量验证是否抵押
 */
public class BdcdyPlDjDyValidateServiceImpl implements ProjectValidateService {
    /**
     * @param project 项目信息
     * @return
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @version 1.0, 2016/7/29
     * @description 验证项目有效性
     */

    @Autowired
    private QllxParentService qllxParentService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        Map<String, Object> map = new HashMap<String, Object>();
        List<String> proidList = new ArrayList<String>();
        if (project != null && StringUtils.isBlank(project.getZdzhh())) {
            if (project.getBdcdyhs() != null && project.getBdcdyhs().size() > 0) {
                project.setZdzhh(project.getBdcdyhs().get(0).substring(0, 19));
            }
        }
        if (project != null && StringUtils.isNotBlank(project.getZdzhh())) {
            HashMap<String, Object> querymap = new HashMap<String, Object>();
            querymap.put("zdzhh", project.getZdzhh());
            List<QllxParent> qllxParentList = qllxParentService.queryZtzcQllxVo(new BdcDyaq(), querymap);
            if (StringUtils.isNotBlank(project.getDcbIndex())) {
                if (qllxParentList != null && qllxParentList.size() > 0) {
                    for (QllxParent qllxParent : qllxParentList) {
                        proidList.add(qllxParent.getProid());
                    }
                }
            } else if (project.getBdcdyhs() != null && project.getBdcdyhs().size() > 0) {
                List<String> bdcdyhs = project.getBdcdyhs();
                querymap = new HashMap<String, Object>();
                String zdzhh = project.getZdzhh();
                querymap.put("zdzhh", zdzhh);
                List<Map> qllxMapParentList = qllxParentService.queryZtzcQllxMap(new BdcDyaq(), querymap);
                if (qllxMapParentList != null && qllxMapParentList.size() > 0) {
                    for (Map qllxMap : qllxMapParentList) {
                        String tempBdcdyh = "";
                        if (qllxMap.containsKey("BDCDYH") && qllxMap.get("BDCDYH") != null)
                            tempBdcdyh = qllxMap.get("BDCDYH").toString();
                        if (bdcdyhs.contains(tempBdcdyh) && qllxMap.containsKey("PROID") && qllxMap.get("PROID") != null)
                            proidList.add(qllxMap.get("PROID").toString());
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(proidList))
            map.put("info", proidList.get(0));
        else
            map.put("info", null);
        return map;
    }

    /**
     * @return 获取此验证逻辑的代码编号
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的代码编号
     */
    @Override
    public String getCode() {
        return "109";
    }

    /**
     * @return 获取此验证逻辑的描述信息
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的描述信息
     */
    @Override
    public String getDescription() {
        return "验证批量发证的不动产单元是否抵押（只针对批量选择楼盘表或者选择逻辑幢）";
    }
}
