package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.BdcZjjzwxxService;
import cn.gtmap.estateplat.config.core.service.BdcdySdService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.model.server.core.BdcBdcdySd;
import cn.gtmap.estateplat.model.server.core.Project;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
 * @version 1.0, 2016/7/29
 * @description 验证不动产单元是否锁定
 */
public class BdcdySfSdValidateServiceImpl implements ProjectValidateService {
    @Autowired
    BdcZjjzwxxService bdcZjjzwxxService;
    /**
     * @param project 项目信息
     * @return
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @version 1.0, 2016/7/29
     * @description 验证项目有效性
     */
    @Autowired
    private BdcdySdService bdcdySdService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        Map<String, Object> map = new HashMap<String, Object>();
        List<String> proidList = null;
        String xzyy = "";
        if (project != null && StringUtils.isNotBlank(project.getBdcdyh())) {
            List<BdcBdcdySd> list = bdcdySdService.queryBdcdySdByBdcdyh(project.getBdcdyh(), Constants.XZZT_SD);
            if (list != null && list.size() > 0) {
                proidList = new ArrayList<String>();
                for (int i = 0; i < list.size(); i++) {
                    proidList.add(list.get(i).getBdcdyid());
                }
                xzyy = list.get(0).getXzyy();
            }
        }
        map.put("info", proidList);
        map.put("tsinfo", xzyy);
        return map;
    }

    /**
     * @return 获取此验证逻辑的代码编号
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的代码编号
     */
    @Override
    public String getCode() {
        return "106";
    }

    /**
     * @return 获取此验证逻辑的描述信息
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的描述信息
     */
    @Override
    public String getDescription() {
        return "验证不动产单元是否锁定";
    }
}
