package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.BdcFdcqService;
import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.core.service.BdcYgService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcFdcq;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcYg;
import cn.gtmap.estateplat.model.server.core.Project;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:songhaowen@gtmap.cn">ray</a>
 * @version 1.0, ${date}
 * @description 不动产登记服务
 */
public class BdcdyYgBdcqzValidateServiceImpl implements ProjectValidateService {
    /**
     * @param project 项目信息
     * @return
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @version 1.0, 2016/7/29
     * @description 验证项目有效性
     */
    @Autowired
    private BdcYgService bdcYgService;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcFdcqService bdcFdcqService;
    @Autowired
    private EntityMapper entityMapper;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        Map<String, Object> map = new HashMap<String, Object>();
        List<String> proidList = null;
        if (project != null && StringUtils.isNotBlank(project.getProid())) {
            BdcXm bdcXm = entityMapper.selectByPrimaryKey(BdcXm.class, project.getProid());
            String xmly = bdcXm.getXmly();
            HashMap<String, Object> querymap = new HashMap<String, Object>();
            List<BdcYg> bdcYgList = null;
            if (xmly.equals("1")) {
                List<BdcXm> xmList = bdcXmService.getBdcXmListByWiid(project.getWiid());
                if (CollectionUtils.isNotEmpty(xmList)) {
                    for (BdcXm xm : xmList) {
                        if (StringUtils.isNotBlank(xm.getBdcdyid())) {
                            querymap.put("bdcdyid", xm.getBdcdyid());
                            querymap.put("qszt", Constants.QLLX_QSZT_XS);
                            bdcYgList = bdcYgService.getBdcYgList(querymap);
                            if (CollectionUtils.isNotEmpty(bdcYgList)) {
                                //验证预告是否发不动产权证
                                List<BdcFdcq> fdcqList = bdcFdcqService.getBdcFdcqListByProid(xm.getProid());
                                if (CollectionUtils.isNotEmpty(fdcqList)) {
                                    BdcFdcq bdcFdcq = fdcqList.get(0);
                                    if (StringUtils.equals(bdcFdcq.getFzlx(), Constants.FZLX_FZS)) {
                                        break;
                                    } else {
                                        bdcYgList.clear();
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(bdcYgList)) {
                proidList = new LinkedList<String>();
                for (BdcYg bdcYg : bdcYgList) {
                    proidList.add(bdcYg.getProid());
                }
            }
        }
        map.put("info", CollectionUtils.isNotEmpty(proidList) ? proidList : null);
        return map;
    }

    /**
     * @return 获取此验证逻辑的代码编号
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的代码编号
     */
    @Override
    public String getCode() {
        return "138";
    }

    /**
     * @return 获取此验证逻辑的描述信息
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的描述信息
     */
    @Override
    public String getDescription() {
        return "验证存在预告登记的不动产单元办理不动产权证书";
    }
}
