package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.BdcXmRelService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXmRel;
import cn.gtmap.estateplat.model.server.core.Project;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
 * @version 1.0, 2016/7/29
 * @description 验证原项目是否正在办理
 */
public class BdcdyYxmSfblValidateServiceImpl implements ProjectValidateService {
    @Autowired
    EntityMapper entityMapper;
    /**
     * @param project 项目信息
     * @return
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @version 1.0, 2016/7/29
     * @description 验证项目有效性
     */

    @Autowired
    private BdcXmRelService bdcXmRelService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        Map<String, Object> map = new HashMap<String, Object>();
        List<String> proidList = new ArrayList<String>();
        if (project != null && StringUtils.isNotBlank(project.getYxmid())) {
            List<BdcXmRel> list = bdcXmRelService.getBdcXmRelByYproidAndBdcdyh(project.getYxmid(), project.getBdcdyh());
            if (list != null && list.size() > 0) {
                for (BdcXmRel bdcXmRel : list) {
                    //zdd 排除当前项目
                    if (!bdcXmRel.getProid().equals(project.getProid())) {
                        BdcXm bdcXm = entityMapper.selectByPrimaryKey(BdcXm.class, bdcXmRel.getProid());
                        if (bdcXm != null && !bdcXm.getWiid().equals(project.getWiid()) && StringUtils.isNotBlank(bdcXm.getXmzt()) && bdcXm.getXmzt().equals("0")) {
                            proidList.add(bdcXm.getProid());
                        }

                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(proidList))
            map.put("info", proidList.get(0));
        else
            map.put("info", null);
        return map;
    }

    /**
     * @return 获取此验证逻辑的代码编号
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的代码编号
     */
    @Override
    public String getCode() {
        return "117";
    }

    /**
     * @return 获取此验证逻辑的描述信息
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的描述信息
     */
    @Override
    public String getDescription() {
        return "验证原项目是否正在办理";
    }
}
