package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.core.service.BdcZjjzwxxService;
import cn.gtmap.estateplat.config.core.service.BdcdyService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.model.server.core.BdcBdcdy;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.Project;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
 * @version 1.0, 2016/7/29
 * @description 验证不动产单元号是否处于活动状态 即不动产单元号是否在办理其他登记
 */
public class BdcdyZzblValidateServiceImpl implements ProjectValidateService {
    @Autowired
    BdcZjjzwxxService bdcZjjzwxxService;
    /**
     * @param project 项目信息
     * @return
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @version 1.0, 2016/7/29
     * @description 验证项目有效性
     */

    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcdyService bdcdyService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        Map<String, Object> map = new HashMap<String, Object>();
        List<String> proidList = new ArrayList<String>();
        if (project != null && StringUtils.isNotBlank(project.getBdcdyh())) {
            BdcBdcdy bdcdy = bdcdyService.getBdcdyByBdcdyh(project.getBdcdyh());
            if (bdcdy != null) {
                List<BdcXm> bdcXmList = bdcXmService.getBdcXmByBdcdyid(bdcdy.getBdcdyid());
                if (bdcXmList != null && bdcXmList.size() > 0) {
                    for (BdcXm ybdcXm : bdcXmList) {
                        //zdd 排除当前项目
                        if (StringUtils.isNotBlank(ybdcXm.getWiid()) && !ybdcXm.getWiid().equals(project.getWiid()) && StringUtils.isNotBlank(ybdcXm.getProid()) && !ybdcXm.getProid().equals(project.getProid())) {
                            if (StringUtils.equals("0",ybdcXm.getXmzt()) || StringUtils.equals("2",ybdcXm.getXmzt())) {
                                proidList.add(ybdcXm.getProid());
                            }
                        }
                    }
                }

            }
        }
        if (CollectionUtils.isNotEmpty(proidList))
            map.put("info", proidList.get(0));
        else
            map.put("info", null);
        return map;
    }

    /**
     * @return 获取此验证逻辑的代码编号
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的代码编号
     */
    @Override
    public String getCode() {
        return "124";
    }

    /**
     * @return 获取此验证逻辑的描述信息
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的描述信息
     */
    @Override
    public String getDescription() {
        return "验证不动产单元号是否处于活动状态 即不动产单元号是否在办理其他登记";
    }
}
