package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.core.service.QllxParentService;
import cn.gtmap.estateplat.config.core.service.QllxService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.model.server.core.QllxParent;
import cn.gtmap.estateplat.model.server.core.QllxVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/7/29
 * @description 判断选择产权证的权利状态 是否为现势状态 即正常状态
 */
public class QlZtCheckValidateServiceImpl implements ProjectValidateService {
    /**
     * @param project 项目信息
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 验证项目有效性
     */

    @Autowired
    private QllxParentService qllxParentService;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private QllxService qllxService;
    @Autowired
    private EntityMapper entityMapper;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        Map<String, Object> map = new HashMap<String, Object>();
        String proid = null;
        QllxVo xQllxVo = StringUtils.isNotBlank(project.getProid()) ? qllxService.getQllxVoByProid(project.getProid()) : null;
        if (null == xQllxVo && StringUtils.isNotBlank(project.getYxmid())) {
            BdcXm ybdcxm = entityMapper.selectByPrimaryKey(BdcXm.class, project.getYxmid());
            QllxVo qllxVo = qllxService.makeSureQllx(ybdcxm);
            HashMap mapQuery = new HashMap();
            mapQuery.put("proid", project.getYxmid());
            mapQuery.put("bdcdyh", project.getBdcdyh());
            mapQuery.put("qszt", Constants.QLLX_QSZT_HR);
            mapQuery.put("xmzt", Constants.XMZT_BJ);
            List<QllxParent> list = qllxParentService.queryQllxVo(qllxVo, mapQuery);
            if (list != null && list.size() > 0) {
                proid = list.get(0).getProid();
            }
        }
        map.put("info", proid);
        return map;
    }

    /**
     * @return 获取此验证逻辑的代码编号
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的代码编号
     */
    @Override
    public String getCode() {
        return "203";
    }

    /**
     * @return 获取此验证逻辑的描述信息
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的描述信息
     */
    @Override
    public String getDescription() {
        return "判断选择产权证的权利状态 是否为现势状态 即正常状态";
    }
}
