package cn.gtmap.estateplat.config.service.core.impl.validator;

import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.core.service.BdcZsService;
import cn.gtmap.estateplat.config.core.service.BdcZsbhService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.model.server.core.BdcZsbh;
import cn.gtmap.estateplat.model.server.core.Project;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
 * @version 1.0, 2016/7/29
 * @description 验证证书编号填写是否正确
 */
public class QtZsbhValidateServiceImpl implements ProjectValidateService {
    /**
     * @param project 项目信息
     * @return
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @version 1.0, 2016/7/29
     * @description 验证项目有效性
     */

    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcZsService bdcZsService;
    @Autowired
    private BdcZsbhService bdcZsbhService;

    @Override
    public Map<String, Object> validate(HashMap param) {
        Project project = (Project) param.get("project");
        boolean isadd = true;
        Map<String, Object> map = new HashMap<String, Object>();
        List<String> proidList = null;
        if (project != null && StringUtils.isNotBlank(project.getWiid())) {
            /**
             * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
             * @description 先根据wiid获取所有的项目，获取所有的证书
             */
            List<BdcXm> bdcXmList = bdcXmService.getBdcXmListByWiid(project.getWiid());
            if (CollectionUtils.isNotEmpty(bdcXmList)) {
                List<BdcZs> bdcZsList = new ArrayList<BdcZs>();
                for (BdcXm bdcXm : bdcXmList) {
                    List<BdcZs> bdcZsListTemp = bdcZsService.getBdcZsByProid(bdcXm.getProid());
                    if (CollectionUtils.isNotEmpty(bdcZsListTemp)) {
                        bdcZsList.addAll(bdcZsListTemp);
                    }
                }
                if (CollectionUtils.isNotEmpty(bdcZsList)) {
                    for (BdcZs bdcZs : bdcZsList) {
                        /**
                         * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
                         * @description 证书编号为空直接弹出验证失败
                         */
                        if (StringUtils.isBlank(bdcZs.getBh())) {
                            isadd = false;
                            break;
                        }
                        /**
                         * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
                         * @description 根据证书id获取所有的证书编号（可能是点击按钮获取、可能是自己手填的）
                         */
                        HashMap zsBhMap = new HashMap();
                        zsBhMap.put("zsid", bdcZs.getZsid());
                        if (StringUtils.equals(bdcZs.getZstype(), Constants.BDCQZS_BH_FONT))
                            zsBhMap.put("zslx", Constants.BDCQZS_BH_DM);
                        else if (StringUtils.equals(bdcZs.getZstype(), Constants.BDCQZM_BH_FONT))
                            zsBhMap.put("zslx", Constants.BDCQZM_BH_DM);
                        List<BdcZsbh> bdcZsbhList = bdcZsbhService.getBdcZsBhListByBhfw(zsBhMap);
                        if (CollectionUtils.isNotEmpty(bdcZsbhList)) {
                            for (BdcZsbh bdcZsbh : bdcZsbhList) {
                                if (StringUtils.equals(bdcZsbh.getZsbh(), bdcZs.getBh())) {
                                    if (StringUtils.equals(bdcZsbh.getSyqk(), Constants.BDCZSBH_SYQK_ZF)) {
                                        isadd = false;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (isadd == false) {
            proidList = new ArrayList<String>();
            proidList.add(project.getProid());
        }

        if (CollectionUtils.isNotEmpty(proidList))
            map.put("info", proidList.get(0));
        else
            map.put("info", null);
        return map;
    }

    /**
     * @return 获取此验证逻辑的代码编号
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的代码编号
     */
    @Override
    public String getCode() {
        return "906";
    }

    /**
     * @return 获取此验证逻辑的描述信息
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/7/29
     * @description 获取此验证逻辑的描述信息
     */
    @Override
    public String getDescription() {
        return "验证证书编号填写是否正确";
    }
}
