package cn.gtmap.estateplat.config.service.impl;

import cn.gtmap.estateplat.config.model.*;
import cn.gtmap.estateplat.config.service.ArdExcelService;
import cn.gtmap.estateplat.core.ex.AppException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/9/7
 * @description
 */
@Service
public class ArdExcelServiceImpl implements ArdExcelService {

    public Map<String, List<Object>> getExcelAsInputStream(InputStream inputStream, String type) {
        InputStream ins = null;
        Workbook wb = null;
        Map<String, List<Object>> map = Maps.newHashMap();
        try {
            //获取文件的输入流
            ins = inputStream;
            //创建工作簿
            wb = WorkbookFactory.create(ins);
            //关闭输入流
            ins.close();
            //循环获取Excel的Sheet
            Boolean validateTrue = false;
            Sheet nameSheet = wb.getSheetAt(0);
            if (StringUtils.equals(type, "HY") && StringUtils.equals(nameSheet.getSheetName(), "海域项目基本信息")) {
                validateTrue = true;
            } else if (StringUtils.equals(type, "LM") && StringUtils.equals(nameSheet.getSheetName(), "林木项目基本信息")) {
                validateTrue = true;
            } else if (StringUtils.equals(type, "CD") && StringUtils.equals(nameSheet.getSheetName(), "草地项目基本信息")) {
                validateTrue = true;
            } else if (StringUtils.equals(type, "NYD") && StringUtils.equals(nameSheet.getSheetName(), "农用地项目基本信息")) {
                validateTrue = true;
            }
            if (validateTrue) {
                for (int i = 0; i < wb.getNumberOfSheets(); i++) {
                    Sheet sheet = wb.getSheetAt(i);
                    //获取第一行
                    Row topRow = sheet.getRow(0);
                    //获取第一行的列数,即这个sheet的最大列数
                    int lineNum = topRow.getLastCellNum();
                    //获取行的迭代器,通过循环每一行进行赋值操作
                    Iterator<Row> rowIterator = sheet.rowIterator();
                    switch (i) {
                        //第一个sheet存放的是ArdBdcXm的信息,初始化ArdBdcXm,并存放至map
                        case 0:
                            int j = 0;
                            while (rowIterator.hasNext()) {
                                Row row = rowIterator.next();
                                row.getLastCellNum();
                                //因为Excel第一行存放的是列名,跳过第一行数据,从第二行开始初始化ArdBdcXm
                                if (j == 0) {
                                    j++;
                                    continue;
                                }
                                ArdBdcXm ardBdcXm = ArdBdcXm.initArdBdcXm(row, lineNum);
                                handleArdMap(map, ardBdcXm);
                            }
                            break;
                        case 1:
                            if (StringUtils.equals(type, "HY")) {
                                //第二个sheet存放的是ArdBdcHysyq的信息,初始化ArdBdcHysyq,并存放至map
                                int k = 0;
                                while (rowIterator.hasNext()) {
                                    Row row = rowIterator.next();
                                    row.getLastCellNum();
                                    //因为Excel第一行存放的是列名,跳过第一行数据,从第二行开始初始换ArdBdcHysyq
                                    if (k == 0) {
                                        k++;
                                        continue;
                                    }
                                    ArdBdcHysyq ardBdcHysyq = ArdBdcHysyq.initArdBdcHysyq(row, lineNum);
                                    handleArdMap(map, ardBdcHysyq);
                                }
                            } else if (StringUtils.equals(type, "LM")) {
                                //第二个sheet存放的是ArdBdcHysyq的信息,初始化ArdLq,并存放至map
                                int l = 0;
                                while (rowIterator.hasNext()) {
                                    Row row = rowIterator.next();
                                    row.getLastCellNum();
                                    //因为Excel第一行存放的是列名,跳过第一行数据,从第二行开始初始换ArdLq
                                    if (l == 0) {
                                        l++;
                                        continue;
                                    }
                                    ArdBdcLq ardBdcLq = ArdBdcLq.initArdBdcLq(row, lineNum);
                                    handleArdMap(map, ardBdcLq);
                                }
                            } else if (StringUtils.equals(type, "CD")) {
                                //第二个sheet存放的是ArdBdcHysyq的信息,初始化ArdBdcTdcbnydsyq,并存放至map
                                int m = 0;
                                while (rowIterator.hasNext()) {
                                    Row row = rowIterator.next();
                                    row.getLastCellNum();
                                    //因为Excel第一行存放的是列名,跳过第一行数据,从第二行开始初始换ArdBdcTdcbnydsyq
                                    if (m == 0) {
                                        m++;
                                        continue;
                                    }
                                    ArdBdcTdcbnydsyq ardBdcTdcbnydsyq = ArdBdcTdcbnydsyq.initArdBdcTdcbnydsyq(row, lineNum);
                                    handleArdMap(map, ardBdcTdcbnydsyq);
                                }
                            } else if (StringUtils.equals(type, "NYD")) {
                                //第二个sheet存放的是ArdBdcHysyq的信息,初始化ArdBdcTdcbnydsyq,并存放至map
                                int m = 0;
                                while (rowIterator.hasNext()) {
                                    Row row = rowIterator.next();
                                    row.getLastCellNum();
                                    //因为Excel第一行存放的是列名,跳过第一行数据,从第二行开始初始换ArdBdcTdcbnydsyq
                                    if (m == 0) {
                                        m++;
                                        continue;
                                    }
                                    ArdBdcTdcbnydsyq ardBdcTdcbnydsyq = ArdBdcTdcbnydsyq.initArdBdcTdcbnydsyq(row, lineNum);
                                    handleArdMap(map, ardBdcTdcbnydsyq);
                                }
                            }
                            break;
                        //第三个sheet存放的是ardBdcDyaq的信息,初始化ardBdcDyaq
                        case 2:
                            int n = 0;
                            while (rowIterator.hasNext()) {
                                Row row = rowIterator.next();
                                row.getLastCellNum();
                                //因为Excel第一行存放的是列名,跳过第一行数据,从第二行开始初始换ardBdcDyaq
                                if (n == 0) {
                                    n++;
                                    continue;
                                }
                                ArdBdcDyaq ardBdcDyaq = ArdBdcDyaq.initArdBdcDyaq(row, lineNum);
                                handleArdMap(map, ardBdcDyaq);
                            }
                            break;
                        //第四个sheet存放的是ArdBdcCf的信息,初始化ArdBdcCf
                        case 3:
                            int o = 0;
                            while (rowIterator.hasNext()) {
                                Row row = rowIterator.next();
                                row.getLastCellNum();
                                //因为Excel第一行存放的是列名,跳过第一行数据,从第二行开始初始换ArdBdcCf
                                if (o == 0) {
                                    o++;
                                    continue;
                                }
                                ArdBdcCf ardBdcCf = ArdBdcCf.initArdBdcCf(row, lineNum);
                                handleArdMap(map, ardBdcCf);
                            }
                            break;
                        //第五个sheet存放的是ArdBdcQlr的信息,初始化ArdBdcQlr
                        case 4:
                            int p = 0;
                            while (rowIterator.hasNext()) {
                                Row row = rowIterator.next();
                                row.getLastCellNum();
                                //因为Excel第一行存放的是列名,跳过第一行数据,从第二行开始初始换ArdBdcQlr
                                if (p == 0) {
                                    p++;
                                    continue;
                                }
                                ArdBdcZs ardBdcZs = ArdBdcZs.initArdBdcZs(row, lineNum);
                                handleArdMap(map, ardBdcZs);
                            }
                            break;
                        //第六个sheet存放的是ArdBdcQlr的信息,初始化ArdBdcQlr
                        case 5:
                            int q = 0;
                            while (rowIterator.hasNext()) {
                                Row row = rowIterator.next();
                                row.getLastCellNum();
                                //因为Excel第一行存放的是列名,跳过第一行数据,从第二行开始初始换ArdBdcQlr
                                if (q == 0) {
                                    q++;
                                    continue;
                                }
                                ArdBdcQlr ardBdcQlr = ArdBdcQlr.initArdBdcQlr(row, lineNum);
                                handleArdMap(map, ardBdcQlr);
                            }
                            break;
                    }
                }
            } else {
                throw new AppException("无效的格式!");
            }
        } catch (IOException e) {
            throw new AppException("创建工作簿出错!");
        } catch (InvalidFormatException e) {
            throw new AppException("无效的格式!");
        }
        return map;
    }

    private void handleArdMap(Map<String, List<Object>> map, ArdInfo ardInfo) {
        if (StringUtils.isNoneBlank(ardInfo.getYwh())) {
            List<Object> objectList = map.get(ardInfo.getYwh());
            if (CollectionUtils.isNotEmpty(objectList)) {
                objectList.add(ardInfo);
            } else {
                objectList = Lists.newArrayList();
                objectList.add(ardInfo);
            }
            map.put(ardInfo.getYwh(), objectList);
        }
    }
}