package cn.gtmap.estateplat.config.service.impl;

import cn.gtmap.estateplat.config.core.service.BdcQlrService;
import cn.gtmap.estateplat.config.core.service.BdcZsService;
import cn.gtmap.estateplat.config.core.service.LogService;
import cn.gtmap.estateplat.config.service.ManageCertificateService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import com.google.common.collect.Lists;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/11/22
 * @description
 */
@Service
public class ManageCertificateServiceImpl implements ManageCertificateService {

    @Autowired
    private EntityMapper entityMapper;

    @Autowired
    private BdcQlrService bdcQlrService;

    @Autowired
    private BdcZsService bdcZsService;

    @Autowired
    private LogService logService;

    @Override
    @Transactional
    public void generateSingleCertificateRel(BdcZs bdcZs, String proid) {
        List<BdcQlr> bdcQlrList = bdcQlrService.queryBdcQlrByProid(proid);
        if (CollectionUtils.isNotEmpty(bdcQlrList) && bdcZs != null) {
            deleteBdcZsQlrRelByZsid(bdcZs.getZsid());
            deleteBdcXmzsRelByProid(proid);
            generateBdcXmzsRel(bdcZs, proid);
            for (BdcQlr bdcQlr : bdcQlrList) {
                generateBdcZsQlrRel(bdcZs, bdcQlr);
                if (StringUtils.equals(bdcQlr.getSfczr(), Constants.FLAG_YES_CHINESE)) {
                    bdcZs.setCzr(bdcQlr.getQlrmc());
                    bdcZs.setCzrid(bdcQlr.getQlrid());
                    logService.saveOrUpdateLog(bdcZs);
                    entityMapper.saveOrUpdate(bdcZs, bdcZs.getZsid());
                }
                if (CollectionUtils.size(bdcQlrList) == 1) {
                    bdcZs.setCzr(bdcQlr.getQlrmc());
                    bdcZs.setCzrid(bdcQlr.getQlrid());
                    logService.saveOrUpdateLog(bdcZs);
                    entityMapper.saveOrUpdate(bdcZs, bdcZs.getZsid());
                }
            }
        }
    }

    @Override
    @Transactional
    public void generateSingleCertificateRel(BdcZs bdcZs, BdcQlr bdcQlr) {
        if (bdcQlr != null && bdcZs != null) {
            generateBdcZsRel(bdcZs, bdcQlr);
        }
    }

    @Override
    public void deleteBdcZsQlrRelByZsid(String zsid) {
        Example example = new Example(BdcZsQlrRel.class);
        example.createCriteria().andEqualTo("zsid", zsid);
        entityMapper.deleteByExampleNotNull(example);
    }

    @Override
    public void deleteBdcXmzsRelByProid(String proid) {
        Example example = new Example(BdcXmzsRel.class);
        example.createCriteria().andEqualTo("proid", proid);
        entityMapper.deleteByExampleNotNull(example);
    }

    private void generateBdcZsRel(BdcZs bdcZs, BdcQlr bdcQlr) {
        BdcZs tempBdcZs = new BdcZs();
        BeanUtils.copyProperties(bdcZs, tempBdcZs);
        tempBdcZs.setZsid(UUIDGenerator.generate18());
        tempBdcZs.setBdcqzh(StringUtils.EMPTY);
        tempBdcZs.setBh(StringUtils.EMPTY);
        tempBdcZs.setCzr(bdcQlr.getQlrmc());
        tempBdcZs.setCzrid(bdcQlr.getQlrid());
        logService.saveOrUpdateLog(tempBdcZs);
        entityMapper.saveOrUpdate(tempBdcZs, tempBdcZs.getZsid());
        BdcZsQlrRel bdcZsQlrRel = new BdcZsQlrRel();
        bdcZsQlrRel.setGxid(UUIDGenerator.generate18());
        bdcZsQlrRel.setQlrid(bdcQlr.getQlrid());
        bdcZsQlrRel.setZsid(tempBdcZs.getZsid());
        logService.saveOrUpdateLog(bdcZsQlrRel);
        entityMapper.saveOrUpdate(bdcZsQlrRel, bdcZsQlrRel.getGxid());
        BdcXmzsRel bdcXmzsRel = new BdcXmzsRel();
        bdcXmzsRel.setXmzsgxid(UUIDGenerator.generate18());
        bdcXmzsRel.setProid(bdcQlr.getProid());
        bdcXmzsRel.setZsid(tempBdcZs.getZsid());
        logService.saveOrUpdateLog(bdcXmzsRel);
        entityMapper.saveOrUpdate(bdcXmzsRel, bdcXmzsRel.getXmzsgxid());
    }

    @Override
    public void generateMultiCertificateRel(BdcXm bdcXm, BdcZs bdcZs) {
        if (StringUtils.equals(bdcXm.getSqfbcz(), Constants.FLAG_YES_CHINESE)) {
            List<BdcQlr> bdcQlrList = bdcQlrService.queryBdcQlrByProid(bdcXm.getProid());
            List<BdcZs> bdcZsList = bdcZsService.getBdcZsByProid(bdcXm.getProid());
            if (CollectionUtils.isNotEmpty(bdcQlrList) && CollectionUtils.isNotEmpty(bdcZsList) && !(CollectionUtils.size(bdcQlrList) == CollectionUtils.size(bdcZsList))) {
                deleteBdcZs(bdcXm.getProid());
                for (BdcQlr bdcQlr : bdcQlrList) {
                    generateBdcZsRel(bdcZs, bdcQlr);
                }
            }
        }
    }

    private List<BdcZsQlrRel> getBdcZsQlrRelByProid(String proid) {
        List<BdcZsQlrRel> bdcZsQlrRelList = Lists.newArrayList();
        List<BdcQlr> bdcQlrList = bdcQlrService.queryBdcQlrByProid(proid);
        if (CollectionUtils.isNotEmpty(bdcQlrList)) {
            for (BdcQlr bdcQlr : bdcQlrList) {
                Example example = new Example(BdcZsQlrRel.class);
                example.createCriteria().andEqualTo("qlrid", bdcQlr.getQlrid());
                List<BdcZsQlrRel> tempBdcZsQlrRelList = entityMapper.selectByExampleNotNull(example);
                if (CollectionUtils.isNotEmpty(tempBdcZsQlrRelList)) {
                    bdcZsQlrRelList.addAll(tempBdcZsQlrRelList);
                }
            }
        }
        return bdcZsQlrRelList;
    }

    private void generateBdcZsQlrRel(BdcZs bdcZs, BdcQlr bdcQlr) {
        BdcZsQlrRel bdcZsQlrRel = new BdcZsQlrRel();
        bdcZsQlrRel.setGxid(UUIDGenerator.generate18());
        bdcZsQlrRel.setZsid(bdcZs.getZsid());
        bdcZsQlrRel.setQlrid(bdcQlr.getQlrid());
        entityMapper.saveOrUpdate(bdcZsQlrRel, bdcZsQlrRel.getGxid());
    }

    private void generateBdcXmzsRel(BdcZs bdcZs, String proid) {
        BdcXmzsRel bdcXmzsRel = new BdcXmzsRel();
        bdcXmzsRel.setXmzsgxid(UUIDGenerator.generate18());
        bdcXmzsRel.setZsid(bdcZs.getZsid());
        bdcXmzsRel.setProid(proid);
        entityMapper.saveOrUpdate(bdcXmzsRel, bdcXmzsRel.getXmzsgxid());
    }

    private void deleteBdcZs(String proid) {
        Example example = new Example(BdcXmzsRel.class);
        example.createCriteria().andEqualTo("proid", proid);
        entityMapper.deleteByExampleNotNull(example);
        List<BdcZsQlrRel> bdcZsQlrRelList = getBdcZsQlrRelByProid(proid);
        if (CollectionUtils.isNotEmpty(bdcZsQlrRelList)) {
            for (BdcZsQlrRel bdcZsQlrRel : bdcZsQlrRelList) {
                if (bdcZsQlrRel != null && StringUtils.isNoneBlank(bdcZsQlrRel.getZsid())) {
                    entityMapper.deleteByPrimaryKey(BdcZs.class, bdcZsQlrRel.getZsid());
                    entityMapper.deleteByPrimaryKey(BdcZsQlrRel.class, bdcZsQlrRel.getGxid());
                }
            }
        }
    }

    @Override
    public void deleteBdcZs(BdcZs... bdcZs) {
        for (BdcZs tempBdcZs : bdcZs) {
            if (StringUtils.isNoneBlank(tempBdcZs.getZsid())) {
                Example example = new Example(BdcXmzsRel.class);
                example.createCriteria().andEqualTo("zsid", tempBdcZs.getZsid());
                entityMapper.deleteByExampleNotNull(example);
                example = new Example(BdcZsQlrRel.class);
                example.createCriteria().andEqualTo("zsid", tempBdcZs.getZsid());
                entityMapper.deleteByExampleNotNull(example);
                entityMapper.deleteByPrimaryKey(BdcZs.class, tempBdcZs.getZsid());
            }
        }
    }
}
