package cn.gtmap.estateplat.config.service.impl;

import cn.gtmap.estateplat.config.core.model.BdcForceValidate;
import cn.gtmap.estateplat.config.core.service.BdcXmRelService;
import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.core.service.BdcXtCheckInfoService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.service.ProjectCheckInfoService;
import cn.gtmap.estateplat.config.service.core.ProjectValidateService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcXtCheckinfo;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description 验证service实现
 */
@Service
public class ProjectCheckInfoServiceImpl implements ProjectCheckInfoService {

    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    BdcXmRelService bdcXmRelService;
    @Autowired
    BdcXtCheckInfoService bdcXtCheckInfoService;
    @Autowired
    BdcXmService bdcXmService;

    //Spring 注入流程验证数据
    private Map<String, ProjectValidateService> projectValidateMap;
    //注入流程强制验证内容
    private Map<String, BdcForceValidate> projectForceValidateMap;


    /**
     * @param checkList 验证项
     * @param project   不动产登记项目
     * @return 验证结果
     * @description 根据验证项，验证当前项目是否符合要求
     */
    public List<Map<String, Object>> checkXmNew(List<BdcXtCheckinfo> checkList, Project project) {
        List<Map<String, Object>> resultList = Lists.newArrayList();
        if (checkList != null) {
            checkList = initForceValidateDm(checkList, project);
            for (int i = 0; i < checkList.size(); i++) {
                Map<String, Object> returnMap = new HashMap<String, Object>();
                BdcXtCheckinfo bdcXtCheckinfo = checkList.get(i);
                ProjectValidateService projectValidateService = null;
                if (bdcXtCheckinfo.getCheckCode() != null) {
                    projectValidateService = getProjectValidateServiceByCheckCode(bdcXtCheckinfo.getCheckCode().toString());
                }

                if (projectValidateService == null) {
                    throw new NullPointerException("验证checkcode" + bdcXtCheckinfo.getCheckCode() + "没有对应的实现类！");
                }
                HashMap param = new HashMap();
                param.put("project", project);
                param.put("bdcXtCheckinfo", bdcXtCheckinfo);
                returnMap = projectValidateService.validate(param);
                if (returnMap.containsKey("info") && returnMap.get("info") != null) {
                    returnMap.put("checkModel", bdcXtCheckinfo.getCheckModel());
                    returnMap.put("checkMsg", bdcXtCheckinfo.getCheckMsg());
                    returnMap.put("createSqlxdm", bdcXtCheckinfo.getCreateSqlxdm());
                    returnMap.put("checkPorids", returnMap.get("info"));
                    returnMap.put("checkCode", bdcXtCheckinfo.getCheckCode());
                    if (Boolean.parseBoolean(AppConfig.getProperty("mulBdcdyTip")))
                        //苏州用于多个不动产单元号提示信息展示的区分
                        returnMap.put("bdcdyh", project.getBdcdyh());
                    resultList.add(returnMap);
                    if (!StringUtils.equals(project.getSqlx(), Constants.SQLX_CF)
                            && !StringUtils.equals(project.getSqlx(), Constants.SQLX_PLCF)
                            && !StringUtils.equals(returnMap.get("checkModel").toString(), "confirm")) {
                        break;
                    }

                }
            }
        }
        resultList = checkIsCd(project, resultList);
        return resultList;
    }

    /**
     * 查封和批量查封优先显示裁定
     *
     * @param project
     * @param resultList
     * @return
     */
    public List<Map<String, Object>> checkIsCd(Project project, List<Map<String, Object>> resultList) {
        if (StringUtils.equals(project.getSqlx(), Constants.SQLX_CF)
                || StringUtils.equals(project.getSqlx(), Constants.SQLX_PLCF)) {
            if (CollectionUtils.isNotEmpty(resultList)) {
                List<Map<String, Object>> cdResultList = Lists.newArrayList();
                List<Map<String, Object>> cfResultList = Lists.newArrayList();
                List<Map<String, Object>> restResultList = Lists.newArrayList();
                for (Map<String, Object> resultMap : resultList) {
                    Integer checkCode = (Integer) resultMap.get("checkCode");
                    if (136 == checkCode) {
                        cdResultList.add(resultMap);
                    }
                    if (101 == checkCode) {
                        cfResultList.add(resultMap);
                    }
                    if ((136 != checkCode) && (101 != checkCode)) {
                        if (CollectionUtils.isEmpty(restResultList)) {
                            restResultList.add(resultMap);
                        }
                    }
                }
                resultList = CollectionUtils.isNotEmpty(cdResultList) ?
                        cdResultList : (CollectionUtils.isNotEmpty(cfResultList) ? cfResultList : restResultList);
            }
        }
        return resultList;
    }


    /**
     * @param checkList，project
     * @return List<BdcXtCheckinfo>
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description 初始化强制验证模板
     */
    public List<BdcXtCheckinfo> initForceValidateDm(List<BdcXtCheckinfo> checkList, Project project) {
        if (projectForceValidateMap != null) {
            for (Map.Entry<String, BdcForceValidate> entry : projectForceValidateMap.entrySet()) {
                BdcForceValidate bdcForceValidate = entry.getValue();
                if (bdcForceValidate != null && StringUtils.isNotBlank(bdcForceValidate.getEsqlxdm())
                        && !CommonUtil.indexOfStrs(bdcForceValidate.getEsqlxdm().split(","), project.getSqlx())
                        && !CommonUtil.indexOfStrs(bdcForceValidate.getEsqlxdm().split(","), project.getDjzx())) {
                    BdcXtCheckinfo bdcXtCheckinfo = new BdcXtCheckinfo();
                    bdcXtCheckinfo.setSqlxdm(project.getSqlx());
                    bdcXtCheckinfo.setCheckCode(Integer.valueOf(entry.getKey()));
                    bdcXtCheckinfo.setCheckMsg(bdcForceValidate.getCheckmsg());
                    bdcXtCheckinfo.setQllxdm(project.getQllx());
                    bdcXtCheckinfo.setCheckModel(Constants.CHECKMODEL_ALERT);
                    checkList.add(bdcXtCheckinfo);
                }
            }
        }
        checkList = sortCheckListByCheckModel(checkList);
        return checkList;
    }

    /**
     * @param
     * @return
     * @author <a href="mailto:wangming@gtmap.cn">wangming</a>
     * @description 因为验证一条不满足就break, 所以要将confirm都放在后面
     */
    private List<BdcXtCheckinfo> sortCheckListByCheckModel(List<BdcXtCheckinfo> checkList) {
        List<BdcXtCheckinfo> alertCheckList = new ArrayList<BdcXtCheckinfo>();
        List<BdcXtCheckinfo> confirmCheckList = new ArrayList<BdcXtCheckinfo>();
        for (BdcXtCheckinfo checkinfo : checkList) {
            if (StringUtils.equals(Constants.CHECKMODEL_ALERT, checkinfo.getCheckModel())) {
                alertCheckList.add(checkinfo);
            } else {
                confirmCheckList.add(checkinfo);
            }
        }
        checkList = alertCheckList;
        checkList.addAll(confirmCheckList);
        return checkList;
    }

    @Override
    public List<Map<String, Object>> checkByBank(HashMap hashMap) {
        List<Map<String, Object>> resultList = Lists.newArrayList();
        if (hashMap.containsKey("BdcXtCheckinfoList") && hashMap.get("BdcXtCheckinfoList") != null) {
            List<BdcXtCheckinfo> bdcXtCheckinfoList = (List<BdcXtCheckinfo>) hashMap.get("BdcXtCheckinfoList");
            String sqlx = (String) hashMap.get("sqlx");
            for (BdcXtCheckinfo bdcXtCheckinfo : bdcXtCheckinfoList) {
                Map<String, Object> returnMap = new HashMap<String, Object>();
                ProjectValidateService projectValidateService = null;
                if (bdcXtCheckinfo.getCheckCode() != null) {
                    projectValidateService = this.getProjectValidateServiceByCheckCode(bdcXtCheckinfo.getCheckCode().toString());
                }
                if (projectValidateService == null) {
                    throw new NullPointerException("验证checkcode" + bdcXtCheckinfo.getCheckCode() + "没有对应的实现类！");
                }
                hashMap.put("bdcXtCheckinfo", bdcXtCheckinfo);
                returnMap = projectValidateService.validate(hashMap);
                if (returnMap.containsKey("info") && returnMap.get("info") != null) {
                    returnMap.put("checkModel", bdcXtCheckinfo.getCheckModel());
                    returnMap.put("checkMsg", bdcXtCheckinfo.getCheckMsg());
                    returnMap.put("createSqlxdm", bdcXtCheckinfo.getCreateSqlxdm());
                    returnMap.put("checkPorids", returnMap.get("info"));
                    returnMap.put("checkCode", bdcXtCheckinfo.getCheckCode());
                    resultList.add(returnMap);
                    if (!StringUtils.equals(sqlx, Constants.SQLX_CF)
                            && !StringUtils.equals(sqlx, Constants.SQLX_PLCF)
                            && !StringUtils.equals(returnMap.get("checkModel").toString(), "confirm")) {
                        break;
                    }
                    resultList.add(returnMap);
                }
            }
        }
        return resultList;
    }

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 测试方法
     **/
    public Map<String, Object> testCheck(String code, Project project) {
        ProjectValidateService projectValidateService = getProjectValidateServiceByCheckCode(code);
        HashMap param = new HashMap();
        param.put("project", project);
        return projectValidateService.validate(param);
    }

    public ProjectValidateService getProjectValidateServiceByCheckCode(String checkcode) {
        return projectValidateMap.get(checkcode);
    }

    public Map<String, ProjectValidateService> getProjectValidateMap() {
        return projectValidateMap;
    }

    public void setProjectValidateMap(Map<String, ProjectValidateService> projectValidateMap) {
        this.projectValidateMap = projectValidateMap;
    }

    public Map<String, BdcForceValidate> getProjectForceValidateMap() {
        return projectForceValidateMap;
    }

    public void setProjectForceValidateMap(Map<String, BdcForceValidate> projectForceValidateMap) {
        this.projectForceValidateMap = projectForceValidateMap;
    }
}
