package cn.gtmap.estateplat.config.service.impl.redundantfield;

import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.model.redundantfield.RedundantField;
import cn.gtmap.estateplat.config.service.redundantfield.BdcRedundantFieldService;
import cn.gtmap.estateplat.config.utils.Common;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CommonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 2018/3/16
 * @description
 */
@Service
public class BdcRedundantFieldServiceImpl implements BdcRedundantFieldService {
    @Autowired
    private BdcdyService bdcdyService;
    @Autowired
    private BdcQlrService bdcQlrService;
    @Autowired
    private DjsjService djsjService;
    @Autowired
    private BdcZsService bdcZsService;
    @Autowired
    private QllxService qllxService;
    @Autowired
    private BdcFdcqService bdcFdcqService;
    @Autowired
    private BdcFdcqDzService bdcFdcqDzService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private BdcYgService bdcYgService;
    @Autowired
    private BdcJsydzjdsyqService bdcJsydzjdsyqService;
    @Autowired
    private BdcDyaqService bdcDyaqService;
    @Autowired
    private BdcCfService bdcCfService;
    @Autowired
    private BdcYyService bdcYyService;
    @Autowired
    private BdcXmService bdcXmService;


    @Override
    public RedundantField getBdcRedundantField(BdcXm bdcXm) {
        RedundantField redundantField = null;
        if (bdcXm != null) {
            redundantField = new RedundantField();
            if (StringUtils.isNotBlank(bdcXm.getZl())) {
                redundantField.setZl(bdcXm.getZl());
            }

            BdcBdcdy bdcBdcdy = bdcdyService.queryBdcdyById(bdcXm.getBdcdyid());
            if (bdcBdcdy != null && StringUtils.isNotBlank(bdcBdcdy.getBdcdyh())) {
                redundantField.setBdcdyh(bdcBdcdy.getBdcdyh());
                //不动产单元编号:房屋编号或地籍号
                if (StringUtils.equals(bdcBdcdy.getBdclx(), Constants.BDCLX_TD) || StringUtils.indexOf(bdcBdcdy.getBdcdyh(), "W") > -1) {
                    if (bdcBdcdy.getBdcdyh().length() > 19) {
                        String djh = StringUtils.substring(bdcBdcdy.getBdcdyh(), 0, 19);
                        redundantField.setBdcdybh(djh);
                    }
                } else if (StringUtils.equals(bdcBdcdy.getBdclx(), Constants.BDCLX_TDFW) || StringUtils.indexOf(bdcBdcdy.getBdcdyh(), "F") > -1) {
                    List<DjsjFwHs> djsjFwHsList = djsjService.getDjsjFwHsByBdcdyh(bdcBdcdy.getBdcdyh());
                    if (CollectionUtils.isNotEmpty(djsjFwHsList)) {
                        DjsjFwHs djsjFwHs = djsjFwHsList.get(0);
                        if (StringUtils.isNotBlank(djsjFwHs.getFwbm())) {
                            redundantField.setBdcdybh(djsjFwHs.getFwbm());
                        }
                    }
                }
            }

            Map map = bdcQlrService.combinationQlrxxAndYwrxx(bdcXm.getProid());
            if (map != null) {
                redundantField.setQlr(CommonUtil.formatEmptyValue(map.get("qlr")));
                redundantField.setQlrzjzl(CommonUtil.formatEmptyValue(map.get("qlrzjzl")));
                redundantField.setQlrzjh(CommonUtil.formatEmptyValue(map.get("qlrzjh")));
                redundantField.setYwr(CommonUtil.formatEmptyValue(map.get("ywr")));
                redundantField.setYwrzjzl(CommonUtil.formatEmptyValue(map.get("ywrzjzl")));
                redundantField.setYwrzjh(CommonUtil.formatEmptyValue(map.get("ywrzjh")));
                redundantField.setGyfs(CommonUtil.formatObjectToInteger(map.get("gyfs")));
            }

            QllxVo qllxVo = qllxService.makeSureQllx(bdcXm);
            qllxVo = qllxService.queryQllxVo(qllxVo, bdcXm.getProid());
            if (qllxVo != null) {
                redundantField.setDjsj(qllxVo.getDjsj());
                redundantField.setDbr(qllxVo.getDbr());
                redundantField.setQszt(qllxVo.getQszt());
            }
            StringBuilder bdcqzhStringBuilder = new StringBuilder();
            List<BdcZs> bdcZsList = bdcZsService.getBdcZsByProid(bdcXm.getProid());
            if (CollectionUtils.isNotEmpty(bdcZsList)) {
                for (BdcZs bdcZs : bdcZsList) {
                    if (StringUtils.isNotBlank(bdcZs.getBdcqzh())) {
                        if (StringUtils.isNotBlank(bdcqzhStringBuilder)) {
                            bdcqzhStringBuilder.append(",").append(bdcZs.getBdcqzh());
                        } else {
                            bdcqzhStringBuilder.append(bdcZs.getBdcqzh());
                        }
                    }
                }
            }

            if (qllxVo instanceof BdcDyaq || qllxVo instanceof BdcYy) {
                redundantField.setBdcqzmh(bdcqzhStringBuilder.toString());
                redundantField.setBdcqzh(bdcXm.getYbdcqzh());
            } else if (qllxVo instanceof BdcCf) {
                redundantField.setBdcqzh(bdcXm.getYbdcqzh());
            } else if (qllxVo instanceof BdcYg) {
                List<BdcYg> bdcYgList = bdcYgService.getBdcYgListByProid(bdcXm.getProid());
                if (CollectionUtils.isNotEmpty(bdcYgList)) {
                    BdcYg bdcYg = bdcYgList.get(0);
                    if (CommonUtil.indexOfStrs(Constants.YG_YGDJZL_DY, bdcYg.getYgdjzl())) {
                        redundantField.setBdcqzmh(bdcqzhStringBuilder.toString());
                        redundantField.setBdcqzh(bdcXm.getYbdcqzh());
                    } else {
                        redundantField.setBdcqzmh(bdcqzhStringBuilder.toString());
                        redundantField.setBdcqzh(bdcqzhStringBuilder.toString());
                    }
                }
            } else {
                redundantField.setBdcqzh(bdcqzhStringBuilder.toString());
            }
            if (StringUtils.isNotBlank(bdcXm.getSqlx())) {
                redundantField.setSqlxdm(bdcXm.getSqlx());
                redundantField.setSqlxmc(bdcZdGlService.getSqlxMcByDm(bdcXm.getSqlx()));
            }
        }
        return redundantField;
    }

    @Override
    public void synchronizationBdcRedundantField(BdcXm bdcXm, RedundantField redundantField) {
        synchronizationBdcXmField(bdcXm, redundantField);
        QllxVo qllxVo = qllxService.makeSureQllx(bdcXm);
        if (qllxVo != null) {
            if (qllxVo instanceof BdcFdcq) {
                synchronizationBdcFdcqField(bdcXm, redundantField);
            } else if (qllxVo instanceof BdcFdcqDz) {
                synchronizationBdcFdcqDzField(bdcXm, redundantField);
            } else if (qllxVo instanceof BdcJsydzjdsyq) {
                synchronizationBdcJsydzjdsyqField(bdcXm, redundantField);
            } else if (qllxVo instanceof BdcTdsyq) {
                synchronizationBdcTdsyqField(bdcXm, redundantField);
            } else if (qllxVo instanceof BdcTdcbnydsyq) {
                synchronizationBdcTdcbnydsyqField(bdcXm, redundantField);
            } else if (qllxVo instanceof BdcJzwsyq) {
                synchronizationBdcJzwsyqField(bdcXm, redundantField);
            } else if (qllxVo instanceof BdcHysyq) {
                synchronizationBdcHysyqField(bdcXm, redundantField);
            } else if (qllxVo instanceof BdcLq) {
                synchronizationBdcLqField(bdcXm, redundantField);
            } else if (qllxVo instanceof BdcYg) {
                synchronizationBdcYgField(bdcXm, redundantField);
            } else if (qllxVo instanceof BdcDyaq) {
                synchronizationBdcDyaqField(bdcXm, redundantField);
            } else if (qllxVo instanceof BdcDyq) {
                synchronizationBdcDyqField(bdcXm, redundantField);
            } else if (qllxVo instanceof BdcYy) {
                synchronizationBdcYyField(bdcXm, redundantField);
            } else if (qllxVo instanceof BdcCf) {
                synchronizationBdcCfField(bdcXm, redundantField);
            }
        }
        synchronizationBdcQlrField(bdcXm, redundantField);
        synchronizationBdcZsField(bdcXm, redundantField);
    }


    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_xm表冗余字段：bdcdyh、bdcdybh
     */
    private void synchronizationBdcXmField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            bdcXm.setBdcdyh(redundantField.getBdcdyh());
            bdcXm.setBdcdybh(redundantField.getBdcdybh());
            bdcXm.setGyfs(redundantField.getGyfs());
            bdcXm.setDjsj(redundantField.getDjsj());
            if (redundantField.getQszt() != null && !CommonUtil.indexOfStrs(Constants.SQLX_NOT_QSZT, bdcXm.getSqlx())) {
                bdcXm.setQszt(redundantField.getQszt());
            }
            bdcXm.setDbr(redundantField.getDbr());

            QllxVo qllxVo = qllxService.makeSureQllx(bdcXm);
            if (qllxVo instanceof BdcDyaq || qllxVo instanceof BdcYy) {
                bdcXm.setBdcqzh(redundantField.getBdcqzmh());
            } else if (qllxVo instanceof BdcYg) {
                List<BdcYg> bdcYgList = bdcYgService.getBdcYgListByProid(bdcXm.getProid());
                if (CollectionUtils.isNotEmpty(bdcYgList)) {
                    BdcYg bdcYg = bdcYgList.get(0);
                    if (CommonUtil.indexOfStrs(Constants.YG_YGDJZL_DY, bdcYg.getYgdjzl())) {
                        bdcXm.setBdcqzh(redundantField.getBdcqzmh());
                    } else {
                        bdcXm.setBdcqzh(redundantField.getBdcqzh());
                    }
                }
            } else {
                bdcXm.setBdcqzh(redundantField.getBdcqzh());
            }
            bdcXm.setQlr(redundantField.getQlr());
            bdcXm.setQlrzjh(redundantField.getQlrzjh());
            bdcXmService.updateBdcXmRedundantField(bdcXm);
        }
    }

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_fdcq表冗余字段：qlrzjzl、qlrzjh、ywr、ywrzjzl、ywrzjh、bdcdyh、bdcqzh、bdcdybh、zl
     */
    private void synchronizationBdcFdcqField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            List<BdcFdcq> bdcFdcqList = bdcFdcqService.getBdcFdcqListByProid(bdcXm.getProid());
            if (CollectionUtils.isNotEmpty(bdcFdcqList)) {
                for (BdcFdcq bdcFdcq : bdcFdcqList) {
                    bdcFdcq.setQlrzjzl(redundantField.getQlrzjzl());
                    bdcFdcq.setQlrzjh(redundantField.getQlrzjh());
                    bdcFdcq.setYwr(redundantField.getYwr());
                    bdcFdcq.setYwrzjzl(redundantField.getYwrzjzl());
                    bdcFdcq.setYwrzjh(redundantField.getYwrzjh());
                    bdcFdcq.setBdcdyh(redundantField.getBdcdyh());
                    bdcFdcq.setBdcqzh(redundantField.getBdcqzh());
                    bdcFdcq.setBdcdybh(redundantField.getBdcdybh());
                    bdcFdcq.setZl(redundantField.getZl());
                    bdcFdcqService.updateBdcfdcqRedundantField(bdcFdcq);
                }
            }

        }
    }

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_fdcq_dz表冗余字段：qlrzjzl、qlrzjh、ywr、ywrzjzl、ywrzjh、bdcdyh、bdcqzh、bdcdybh、zl
     */
    private void synchronizationBdcFdcqDzField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            BdcFdcqDz bdcFdcqDz = bdcFdcqDzService.getBdcFdcqDzByProid(bdcXm.getProid());
            if (bdcFdcqDz != null) {
                bdcFdcqDz.setQlrzjzl(redundantField.getQlrzjzl());
                bdcFdcqDz.setQlrzjh(redundantField.getQlrzjh());
                bdcFdcqDz.setYwr(redundantField.getYwr());
                bdcFdcqDz.setYwrzjzl(redundantField.getYwrzjzl());
                bdcFdcqDz.setYwrzjh(redundantField.getYwrzjh());
                bdcFdcqDz.setBdcdyh(redundantField.getBdcdyh());
                bdcFdcqDz.setBdcqzh(redundantField.getBdcqzh());
                bdcFdcqDz.setZl(redundantField.getZl());
                bdcFdcqDzService.updateBdcfdcqDzRedundantField(bdcFdcqDz);
                synchronizationBdcFwfzxxField(bdcFdcqDz, redundantField);
            }
        }
    }

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_fwfzxx冗余字段：bdcdybh
     */
    private void synchronizationBdcFwfzxxField(BdcFdcqDz bdcFdcqDz, RedundantField redundantField) {
        if (bdcFdcqDz != null && redundantField != null) {
            List<BdcFwfzxx> bdcFwfzxxList = bdcFdcqDzService.getBdcFwfzxxByQlid(bdcFdcqDz.getQlid());
            if (CollectionUtils.isNotEmpty(bdcFwfzxxList)) {
                for (BdcFwfzxx bdcFwfzxx : bdcFwfzxxList) {
                    bdcFwfzxx.setBdcdybh(redundantField.getBdcdybh());
                    entityMapper.saveOrUpdate(bdcFwfzxx, bdcFwfzxx.getFzid());
                }
            }
        }
    }

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_jsydzjdsyq表冗余字段：bdcdyh、bdcdybh、zl
     */
    private void synchronizationBdcJsydzjdsyqField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            List<BdcJsydzjdsyq> bdcJsydzjdsyqList = bdcJsydzjdsyqService.getBdcJsydzjdsyqList(bdcXm.getProid());
            if (CollectionUtils.isNotEmpty(bdcJsydzjdsyqList)) {
                for (BdcJsydzjdsyq bdcJsydzjdsyq : bdcJsydzjdsyqList) {
                    bdcJsydzjdsyq.setBdcdyh(redundantField.getBdcdyh());
                    bdcJsydzjdsyq.setBdcdybh(redundantField.getBdcdybh());
                    bdcJsydzjdsyq.setZl(redundantField.getZl());
                    bdcJsydzjdsyqService.updateBdcJsydzjdsyqRedundantField(bdcJsydzjdsyq);
                }
            }
        }
    }

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_tdsyq表冗余字段：bdcdyh、bdcdybh、zl
     */
    private void synchronizationBdcTdsyqField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            Example example = new Example(BdcTdsyq.class);
            example.createCriteria().andEqualTo("proid", bdcXm.getProid());
            List<BdcTdsyq> bdcTdsyqList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcTdsyqList)) {
                for (BdcTdsyq bdcTdsyq : bdcTdsyqList) {
                    bdcTdsyq.setBdcdyh(redundantField.getBdcdyh());
                    bdcTdsyq.setBdcdybh(redundantField.getBdcdybh());
                    bdcTdsyq.setZl(redundantField.getZl());
                    entityMapper.saveOrUpdate(bdcTdsyq, bdcTdsyq.getQlid());
                }
            }
        }
    }

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_jzwsyq表冗余字段：bdcdyh、bdcdybh、zl
     */
    private void synchronizationBdcJzwsyqField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            Example example = new Example(BdcJzwsyq.class);
            example.createCriteria().andEqualTo("proid", bdcXm.getProid());
            List<BdcJzwsyq> bdcJzwsyqList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcJzwsyqList)) {
                for (BdcJzwsyq bdcJzwsyq : bdcJzwsyqList) {
                    bdcJzwsyq.setBdcdyh(redundantField.getBdcdyh());
                    bdcJzwsyq.setBdcdybh(redundantField.getBdcdybh());
                    bdcJzwsyq.setZl(redundantField.getZl());
                    entityMapper.saveOrUpdate(bdcJzwsyq, bdcJzwsyq.getQlid());
                }
            }
        }
    }

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_hysyq冗余字段：bdcdyh、bdcdybh、zl
     */
    private void synchronizationBdcHysyqField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            Example example = new Example(BdcHysyq.class);
            example.createCriteria().andEqualTo("proid", bdcXm.getProid());
            List<BdcHysyq> bdcHysyqList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcHysyqList)) {
                for (BdcHysyq bdcHysyq : bdcHysyqList) {
                    bdcHysyq.setBdcdyh(redundantField.getBdcdyh());
                    bdcHysyq.setBdcdybh(redundantField.getBdcdybh());
                    bdcHysyq.setZl(redundantField.getZl());
                    entityMapper.saveOrUpdate(bdcHysyq, bdcHysyq.getQlid());
                }
            }
        }
    }

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_tdcbnydsyq冗余字段：bdcdyh、bdcdybh、zl
     */
    private void synchronizationBdcTdcbnydsyqField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            Example example = new Example(BdcTdcbnydsyq.class);
            example.createCriteria().andEqualTo("proid", bdcXm.getProid());
            List<BdcTdcbnydsyq> bdcTdcbnydsyqList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcTdcbnydsyqList)) {
                for (BdcTdcbnydsyq bdcTdcbnydsyq : bdcTdcbnydsyqList) {
                    bdcTdcbnydsyq.setBdcdyh(redundantField.getBdcdyh());
                    bdcTdcbnydsyq.setBdcdybh(redundantField.getBdcdybh());
                    bdcTdcbnydsyq.setZl(redundantField.getZl());
                    entityMapper.saveOrUpdate(bdcTdcbnydsyq, bdcTdcbnydsyq.getQlid());
                }
            }
        }
    }


    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_tdcbnydsyq冗余字段：bdcdyh、bdcdybh、zl
     */
    private void synchronizationBdcLqField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            Example example = new Example(BdcLq.class);
            example.createCriteria().andEqualTo("proid", bdcXm.getProid());
            List<BdcLq> bdcLqList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcLqList)) {
                for (BdcLq bdcLq : bdcLqList) {
                    bdcLq.setBdcdyh(redundantField.getBdcdyh());
                    bdcLq.setBdcdybh(redundantField.getBdcdybh());
                    bdcLq.setZl(redundantField.getZl());
                    entityMapper.saveOrUpdate(bdcLq, bdcLq.getQlid());
                }
            }
        }
    }

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_dyaq冗余字段：dyr、dyrzjzl、dyrzjh、dyqr、dyqrzjzl、dyqrzjh、bdcqzh、bdcqzmh、bdcdyh、bdcdybh、zl
     */
    private void synchronizationBdcDyaqField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            List<BdcDyaq> bdcDyaqList = bdcDyaqService.getBdcDyaqListByProid(bdcXm.getProid(), "");
            if (CollectionUtils.isNotEmpty(bdcDyaqList)) {
                for (BdcDyaq bdcDyaq : bdcDyaqList) {
                    bdcDyaq.setDyr(redundantField.getYwr());
                    bdcDyaq.setDyrzjzl(redundantField.getYwrzjzl());
                    bdcDyaq.setDyrzjh(redundantField.getYwrzjh());
                    bdcDyaq.setDyqr(redundantField.getQlr());
                    bdcDyaq.setDyqrzjzl(redundantField.getQlrzjzl());
                    bdcDyaq.setDyqrzjh(redundantField.getQlrzjh());
                    bdcDyaq.setBdcqzh(redundantField.getBdcqzh());
                    bdcDyaq.setBdcqzmh(redundantField.getBdcqzmh());
                    bdcDyaq.setBdcdyh(redundantField.getBdcdyh());
                    bdcDyaq.setBdcdybh(redundantField.getBdcdybh());
                    bdcDyaq.setZl(redundantField.getZl());
                    bdcDyaqService.updateBdcDyaqRedundantField(bdcDyaq);
                }
            }
        }
    }

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_dyq冗余字段：gydbdcdyh、gydbdcdybh、gydqlr、gydqlrzjzl、gydqlrzjh、xydqlr、xydqlrzjzl、xydqlrzjh、xydbdcdybh、bdcqzh、bdcqzmh
     */
    private void synchronizationBdcDyqField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            Example example = new Example(BdcDyq.class);
            example.createCriteria().andEqualTo("proid", bdcXm.getProid());
            List<BdcDyq> bdcDyqList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcDyqList)) {
                for (BdcDyq bdcDyq : bdcDyqList) {
                    //同步冗余字段待完善
                    bdcDyq.setGydbdcdyh(redundantField.getBdcdyh());
                    bdcDyq.setGydbdcdybh(redundantField.getBdcdybh());
                    bdcDyq.setGydqlr(redundantField.getYwr());
                    bdcDyq.setGydqlrzjzl(redundantField.getYwrzjzl());
                    bdcDyq.setGydqlrzjh(redundantField.getYwrzjh());
                    bdcDyq.setXydqlr(redundantField.getQlr());
                    bdcDyq.setXydqlrzjzl(redundantField.getQlrzjzl());
                    bdcDyq.setXydqlrzjh(redundantField.getQlrzjh());
                    bdcDyq.setBdcqzh(redundantField.getBdcqzh());
                    bdcDyq.setBdcqzmh(redundantField.getBdcqzmh());
                    //bdcDyq.setXydbdcdyh(redundantField);
                    bdcDyq.setBdcqzh(redundantField.getBdcqzh());
                    bdcDyq.setBdcqzmh(redundantField.getBdcqzmh());
                    entityMapper.saveOrUpdate(bdcDyq, bdcDyq.getQlid());
                }
            }
        }
    }

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_yg冗余字段：qlr、qlrzjzl、qlrzjh、ywr、ywrzjzl、ywrzjh、bdcdyh、bdcqzh、bdcqzmh、bdcdybh、zl
     */
    private void synchronizationBdcYgField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            List<BdcYg> bdcYgList = bdcYgService.getBdcYgListByProid(bdcXm.getProid());
            if (CollectionUtils.isNotEmpty(bdcYgList)) {
                for (BdcYg bdcYg : bdcYgList) {
                    bdcYg.setQlr(redundantField.getQlr());
                    bdcYg.setQlrzjzl(redundantField.getQlrzjzl());
                    bdcYg.setQlrzjh(redundantField.getQlrzjh());
                    bdcYg.setYwr(redundantField.getYwr());
                    bdcYg.setYwrzjzl(redundantField.getYwrzjzl());
                    bdcYg.setYwrzjh(redundantField.getYwrzjh());
                    bdcYg.setBdcqzh(redundantField.getBdcqzh());
                    bdcYg.setBdcqzmh(redundantField.getBdcqzmh());
                    bdcYg.setBdcdyh(redundantField.getBdcdyh());
                    bdcYg.setBdcdybh(redundantField.getBdcdybh());
                    bdcYg.setZl(redundantField.getZl());
                    bdcYgService.updateBdcYgRedundantField(bdcYg);
                }
            }
        }
    }

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_yy冗余字段：ywr、ywrzjzl、ywrzjh、bdcdyh、bdcqzh、bdcqzmh、bdcdybh、zl
     */
    private void synchronizationBdcYyField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            List<BdcYy> bdcYyList = bdcYyService.getBdcYyListByProid(bdcXm.getProid());
            if (CollectionUtils.isNotEmpty(bdcYyList)) {
                for (BdcYy bdcYy : bdcYyList) {
                    bdcYy.setYwr(redundantField.getYwr());
                    bdcYy.setYwrzjzl(redundantField.getYwrzjzl());
                    bdcYy.setYwrzjh(redundantField.getYwrzjh());
                    bdcYy.setBdcqzh(redundantField.getBdcqzh());
                    bdcYy.setBdcqzmh(redundantField.getBdcqzmh());
                    bdcYy.setBdcdyh(redundantField.getBdcdyh());
                    bdcYy.setBdcdybh(redundantField.getBdcdybh());
                    bdcYy.setZl(redundantField.getZl());
                    bdcYyService.updateBdcYyRedundantField(bdcYy);
                }
            }
        }
    }

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_cf冗余字段：qlrzjzl、qlrzjh、ywrzjzl、ywrzjh、bdcdyh、bdcqzh、bdcdybh、zl
     */
    private void synchronizationBdcCfField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            List<BdcCf> bdcCfList = bdcCfService.getBdcCfListByProid(bdcXm.getProid());
            if (CollectionUtils.isNotEmpty(bdcCfList)) {
                for (BdcCf bdcCf : bdcCfList) {
                    bdcCf.setQlrzjzl(redundantField.getQlrzjzl());
                    bdcCf.setQlrzjh(redundantField.getQlrzjh());
                    bdcCf.setYwrzjzl(redundantField.getYwrzjzl());
                    bdcCf.setYwrzjh(redundantField.getYwrzjh());
                    bdcCf.setBdcqzh(redundantField.getBdcqzh());
                    bdcCf.setBdcdyh(redundantField.getBdcdyh());
                    bdcCf.setBdcdybh(redundantField.getBdcdybh());
                    bdcCf.setZl(redundantField.getZl());
                    bdcCfService.updateBdcCfRedundantField(bdcCf);
                }
            }
        }
    }


    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_qlr冗余字段：qzysxlh、bdcqzh
     */
    private void synchronizationBdcQlrField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            List<BdcQlr> bdcQlrList = bdcQlrService.getBdcQlrListByProidAndQlrlx(bdcXm.getProid(), Constants.QLRLX_QLR);
            if (CollectionUtils.isNotEmpty(bdcQlrList)) {
                for (BdcQlr bdcQlr : bdcQlrList) {
                    List<BdcZs> bdcZsList = bdcZsService.getBdcZsByQlrid(bdcQlr.getQlrid());
                    if (CollectionUtils.isNotEmpty(bdcZsList)) {
                        BdcZs bdcZs = bdcZsList.get(0);
                        bdcQlr.setBdcqzh(bdcZs.getBdcqzh());
                        bdcQlr.setQzysxlh(bdcZs.getBh());
                        entityMapper.saveOrUpdate(bdcQlr, bdcQlr.getQlrid());
                    }

                }
            }
        }
    }

    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 同步bdc_zs冗余字段：qlrzjzl,qlrzjh、ywr、ywrzjzl、ywrzjh
     */
    private void synchronizationBdcZsField(BdcXm bdcXm, RedundantField redundantField) {
        if (bdcXm != null && redundantField != null) {
            List<BdcZs> bdcZsList = bdcZsService.getBdcZsByProid(bdcXm.getProid());
            //  更新权属状态
            QllxVo qllxVo = qllxService.queryQllxVo(bdcXm);
            if (CollectionUtils.isNotEmpty(bdcZsList)) {
                for (BdcZs bdcZs : bdcZsList) {
                    if (qllxVo != null && qllxVo.getQszt() != null) {
                        bdcZs.setQszt(String.valueOf(qllxVo.getQszt()));
                    }
                    bdcZs.setSqlxdm(redundantField.getSqlxdm());
                    bdcZs.setSqlxmc(redundantField.getSqlxmc());
                    if (StringUtils.isNotBlank(bdcZs.getBdcqzh())) {
                        bdcZs.setBdcqzhjc(Common.getOrderNumber(bdcZs.getBdcqzh()));
                    }
                    bdcZs.setQlrzjzl(redundantField.getQlrzjzl());
                    bdcZs.setQlrzjh(redundantField.getQlrzjh());
                    bdcZs.setYwr(redundantField.getYwr());
                    bdcZs.setYwrzjzl(redundantField.getYwrzjzl());
                    bdcZs.setYwrzjh(redundantField.getYwrzjh());
                    bdcZsService.updateBdcZsRedundantField(bdcZs);
                }
            }
        }
    }


}
