package cn.gtmap.estateplat.config.service.impl.redundantfield;

import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.model.redundantfield.RedundantField;
import cn.gtmap.estateplat.config.service.redundantfield.GdRedundantFieldService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CommonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

/**
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 2018/3/22
 * @description
 */
@Service
public class GdRedundantFieldServiceImpl implements GdRedundantFieldService {

    @Autowired
    private GdFwService gdFwService;
    @Autowired
    private GdTdService gdTdService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private GdQlrService gdQlrService;
    @Autowired
    private GdBdcQlRelService gdBdcQlRelService;
    @Autowired
    private BdcGdDyhRelService bdcGdDyhRelService;
    @Autowired
    private DjsjService djsjService;
    @Autowired
    private GdCfService gdCfService;
    @Autowired
    private GdYgService gdYgService;
    @Autowired
    private GdYyService gdYyService;
    @Autowired
    private GdDyService gdDyService;

    @Override
    public RedundantField getGdRedundantField(String gdproid) {
        RedundantField redundantField = null;
        if (StringUtils.isNotBlank(gdproid)) {
            redundantField = new RedundantField();
            if (StringUtils.isNotBlank(gdproid)) {
                Example gdFwQlExample = new Example(GdFwQl.class);
                gdFwQlExample.createCriteria().andEqualTo("proid", gdproid);
                List<GdFwQl> gdFwQlList = entityMapper.selectByExample(gdFwQlExample);

                String qlid = "";
                String bdcdybh = "";
                if (CollectionUtils.isNotEmpty(gdFwQlList)) {
                    GdFwQl gdFwQl = gdFwQlList.get(0);
                    if (null != gdFwQl && StringUtils.isNotBlank(gdFwQl.getQlid())) {
                        if (StringUtils.isNotBlank(gdFwQl.getFwzl()))
                            redundantField.setZl(gdFwQl.getFwzl());
                        qlid = gdFwQl.getQlid();
                        Example gdFwsyqExample = new Example(GdFwsyq.class);
                        gdFwsyqExample.createCriteria().andEqualTo("qlid", qlid);
                        List<GdFwsyq> gdFwsyqList = entityMapper.selectByExample(gdFwsyqExample);
                        if (CollectionUtils.isNotEmpty(gdFwsyqList)) {
                            if (StringUtils.isNotBlank(gdFwQl.getFczh()))
                                redundantField.setBdcqzh(gdFwQl.getFczh());
                        }else{
                            Example gdDyExample  = new Example(GdDy.class);
                            gdDyExample.createCriteria().andEqualTo("dyid",qlid);
                            List<GdDy> gdDyList = entityMapper.selectByExample(gdDyExample);
                            if(CollectionUtils.isNotEmpty(gdDyList)){
                                GdDy gdDy = gdDyList.get(0);
                                if(gdDy!=null&&StringUtils.isNotBlank(gdDy.getYqzh()))
                                    redundantField.setBdcqzmh(gdDy.getDydjzmh());
                            }else{
                                Example gdYyExample = new Example(GdYy.class);
                                gdYyExample.createCriteria().andEqualTo("yyid",qlid);
                                List<GdYy> gdYyList = entityMapper.selectByExample(gdYyExample);
                                if(CollectionUtils.isNotEmpty(gdYyList)){
                                    GdYy gdYy = gdYyList.get(0);
                                    if(gdYy!=null&&StringUtils.isNotBlank(gdYy.getYqzh()))
                                        redundantField.setBdcqzh(gdYy.getYqzh());
                                }else{
                                    Example gdCfExample = new Example(GdCf.class);
                                    gdCfExample.createCriteria().andEqualTo("cfid",qlid);
                                    List<GdCf> gdCfList = entityMapper.selectByExample(gdCfExample);
                                    if(CollectionUtils.isNotEmpty(gdCfList)){
                                        GdCf gdCf = gdCfList.get(0);
                                        if(gdCf!=null&&StringUtils.isNotBlank(gdCf.getYqzh()))
                                            redundantField.setBdcqzh(gdCf.getYqzh());
                                    }else{
                                        Example gdYgExample = new Example(GdYg.class);
                                        gdYgExample.createCriteria().andEqualTo("ygid",qlid);
                                        List<GdYg> gdYgList = entityMapper.selectByExample(gdYgExample);
                                        if(CollectionUtils.isNotEmpty(gdYgList)){
                                            GdYg gdYg = gdYgList.get(0);
                                            if(gdYg!=null&&StringUtils.isNotBlank(gdYg.getYqzh()))
                                                redundantField.setBdcqzmh(gdYg.getYgdjzmh());
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else {
                    Example gdTdQlExample = new Example(GdTdQl.class);
                    gdTdQlExample.createCriteria().andEqualTo("proid", gdproid);
                    List<GdTdQl> gdTdQlList = entityMapper.selectByExample(gdTdQlExample);
                    if (CollectionUtils.isNotEmpty(gdTdQlList)) {
                        GdTdQl gdTdQl = gdTdQlList.get(0);
                        if (null != gdTdQl && StringUtils.isNotBlank(gdTdQl.getQlid())) {
                            qlid = gdTdQl.getQlid();
                            if (StringUtils.isNotBlank(gdTdQl.getTdzl()))
                                redundantField.setZl(gdTdQl.getTdzl());
                            Example gdTdsyqExample = new Example(GdTdsyq.class);
                            gdTdsyqExample.createCriteria().andEqualTo("qlid", qlid);
                            List<GdTdsyq> gdTdsyqList = entityMapper.selectByExample(gdTdsyqExample);
                            if (CollectionUtils.isNotEmpty(gdTdsyqList)) {
                                if(StringUtils.isNotBlank(gdTdQl.getTdzh())){
                                    redundantField.setBdcqzh(gdTdQl.getTdzh());
                                }
                            }else{
                                Example gdDyExample  = new Example(GdDy.class);
                                gdDyExample.createCriteria().andEqualTo("dyid",qlid);
                                List<GdDy> gdDyList = entityMapper.selectByExample(gdDyExample);
                                if(CollectionUtils.isNotEmpty(gdDyList)){
                                    GdDy gdDy = gdDyList.get(0);
                                    if(gdDy!=null&&StringUtils.isNotBlank(gdDy.getYqzh()))
                                        redundantField.setBdcqzmh(gdDy.getDydjzmh());
                                }else{
                                    Example gdYyExample = new Example(GdYy.class);
                                    gdYyExample.createCriteria().andEqualTo("yyid",qlid);
                                    List<GdYy> gdYyList = entityMapper.selectByExample(gdYyExample);
                                    if(CollectionUtils.isNotEmpty(gdYyList)){
                                        GdYy gdYy = gdYyList.get(0);
                                        if(gdYy!=null&&StringUtils.isNotBlank(gdYy.getYqzh()))
                                            redundantField.setBdcqzh(gdYy.getYqzh());
                                    }else{
                                        Example gdCfExample = new Example(GdCf.class);
                                        gdCfExample.createCriteria().andEqualTo("cfid",qlid);
                                        List<GdCf> gdCfList = entityMapper.selectByExample(gdCfExample);
                                        if(CollectionUtils.isNotEmpty(gdCfList)){
                                            GdCf gdCf = gdCfList.get(0);
                                            if(gdCf!=null&&StringUtils.isNotBlank(gdCf.getYqzh()))
                                                redundantField.setBdcqzh(gdCf.getYqzh());
                                        }else{
                                            Example gdYgExample = new Example(GdYg.class);
                                            gdYgExample.createCriteria().andEqualTo("ygid",qlid);
                                            List<GdYg> gdYgList = entityMapper.selectByExample(gdYgExample);
                                            if(CollectionUtils.isNotEmpty(gdYgList)){
                                                GdYg gdYg = gdYgList.get(0);
                                                if(gdYg!=null&&StringUtils.isNotBlank(gdYg.getYqzh()))
                                                    redundantField.setBdcqzmh(gdYg.getYgdjzmh());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

                HashMap<String, String> gdQLrAndYwr = gdQlrService.combinationQlrAndYwrByProid(gdproid);
                if (null != gdQLrAndYwr) {
                    redundantField.setQlr(CommonUtil.formatEmptyValue(gdQLrAndYwr.get("qlr")));
                    redundantField.setQlrzjzl(CommonUtil.formatEmptyValue(gdQLrAndYwr.get("qlrzjzl")));
                    redundantField.setQlrzjh(CommonUtil.formatEmptyValue(gdQLrAndYwr.get("qlrzjh")));
                    redundantField.setYwr(CommonUtil.formatEmptyValue(gdQLrAndYwr.get("ywr")));
                    redundantField.setYwrzjzl(CommonUtil.formatEmptyValue(gdQLrAndYwr.get("ywrzjzl")));
                    redundantField.setYwrzjh(CommonUtil.formatEmptyValue(gdQLrAndYwr.get("ywrzjh")));
                }
                List<GdBdcQlRel> gdBdcQlRelList = gdBdcQlRelService.queryGdBdcQlListByQlid(qlid);
                if (CollectionUtils.isNotEmpty(gdBdcQlRelList)) {
                    for(GdBdcQlRel gdBdcQlRel:gdBdcQlRelList) {
                        if (StringUtils.isNotBlank(gdBdcQlRel.getBdcid())) {
                            List<BdcGdDyhRel> gdDyhRelList = bdcGdDyhRelService.getGdDyhRelListByGdid(gdBdcQlRel.getBdcid());
                            if (CollectionUtils.isNotEmpty(gdDyhRelList)) {
                                for(BdcGdDyhRel bdcGdDyhRel:gdDyhRelList) {
                                    if (null != bdcGdDyhRel && StringUtils.isNotBlank(bdcGdDyhRel.getBdcdyh())) {
                                        if(bdcGdDyhRel.getBdcdyh().contains(Constants.DZWTZM_F)) {
                                            List<DjsjFwHs> djsjFwHsList = djsjService.getDjsjFwHsByBdcdyh(bdcGdDyhRel.getBdcdyh());
                                            if(CollectionUtils.isNotEmpty(djsjFwHsList)) {
                                                DjsjFwHs djsjFwHs = djsjFwHsList.get(0);
                                                if(StringUtils.isNotBlank(djsjFwHs.getFwbm())) {
                                                    bdcdybh = djsjFwHs.getFwbm();
                                                }
                                            }
                                        }else if(bdcGdDyhRel.getBdcdyh().contains(Constants.DZWTZM_W)) {
                                            if (bdcGdDyhRel.getBdcdyh().length() > 19) {
                                                if (StringUtils.isBlank(bdcdybh)) {
                                                    bdcdybh = bdcGdDyhRel.getBdcdyh().substring(0, 19);
                                                } else {
                                                    bdcdybh = bdcdybh + "," + bdcGdDyhRel.getBdcdyh().substring(0, 19);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (StringUtils.isNotBlank(bdcdybh))
                    redundantField.setBdcdybh(bdcdybh);
            }
        }
        return redundantField;
    }


    @Override
    public void synchronizationGdRedundantField(String gdProid, RedundantField redundantField) {
        synchronizationGdFwsyqField(gdProid, redundantField);
        synchronizationGdtdsyqField(gdProid, redundantField);
        synchronizationGdFwQlField(gdProid, redundantField);
        synchronizationGdTdQlField(gdProid, redundantField);
        synchronizationGdCfField(gdProid, redundantField);
        synchronizationGdYgField(gdProid, redundantField);
        synchronizationGdYyField(gdProid, redundantField);
        synchronizationGdDyField(gdProid, redundantField);
        synchronizationGdQlrField(gdProid, redundantField);
    }

    /**
     * @author <a herf="mailto:xinghuajian@gtmap.cn">xinghuajian</a>
     * @description 同步Gdfwsyq冗余字段zl, qlr, qlrzjzl, qlrzjh, bdcdybh
     */
    private void synchronizationGdFwsyqField(String gdProid, RedundantField redundantField) {
        if (StringUtils.isNotBlank(gdProid) && redundantField != null) {
            List<GdFwsyq> gdFwsyqList = gdFwService.getGdFwsyqListByGdproid(gdProid, "");
            if (CollectionUtils.isNotEmpty(gdFwsyqList)) {
                for (GdFwsyq gdFwsyq : gdFwsyqList) {
                    gdFwsyq.setZl(redundantField.getZl());
                    gdFwsyq.setQlr(redundantField.getQlr());
                    gdFwsyq.setQlrzjzl(redundantField.getQlrzjzl());
                    gdFwsyq.setQlrzjh(redundantField.getQlrzjh());
                    gdFwsyq.setBdcdybh(redundantField.getBdcdybh());
                    gdFwService.updateGdFwsyqRedundantField(gdFwsyq);
                }
            }
        }
    }

    /**
     * @author <a herf="mailto:xinghuajian@gtmap.cn">xinghuajian</a>
     * @description 同步Gdtdsyq冗余字段zl, qlr, qlrzjzl, qlrzjh, bdcdybh
     */
    private void synchronizationGdtdsyqField(String gdProid, RedundantField redundantField) {
        if (StringUtils.isNotBlank(gdProid) && redundantField != null) {
            Example tdsyqExample = new Example(GdTdsyq.class);
            tdsyqExample.createCriteria().andEqualTo("proid", gdProid);
            List<GdTdsyq> gdTdsyqList = entityMapper.selectByExample(tdsyqExample);
            if (CollectionUtils.isNotEmpty(gdTdsyqList)) {
                for (GdTdsyq gdTdsyq : gdTdsyqList) {
                    gdTdsyq.setQlrzjzl(redundantField.getQlrzjzl());
                    gdTdsyq.setQlr(redundantField.getQlr());
                    gdTdsyq.setQlrzjh(redundantField.getQlrzjh());
                    gdTdsyq.setBdcdybh(redundantField.getBdcdybh());
                    gdTdsyq.setZl(redundantField.getZl());
                    gdTdService.updateGdTdsyqRedundantField(gdTdsyq);
                }
            }
        }
    }

    /**
     * @author <a herf="mailto:xinghuajian@gtmap.cn">xinghuajian</a>
     * @description 同步gdfwql冗余字段Ywrzjh, Bdcdybh
     */
    private void synchronizationGdFwQlField(String gdProid, RedundantField redundantField) {
        if (StringUtils.isNotBlank(gdProid) && null != redundantField) {
            Example gdFwQlExample = new Example(GdFwQl.class);
            gdFwQlExample.createCriteria().andEqualTo("proid", gdProid);
            List<GdFwQl> gdFwQlList = entityMapper.selectByExample(gdFwQlExample);
            if (CollectionUtils.isNotEmpty(gdFwQlList)) {
                for (GdFwQl gdFwQl : gdFwQlList) {
                    gdFwQl.setYwrzjh(redundantField.getYwrzjh());
                    gdFwQl.setBdcdybh(redundantField.getBdcdybh());
                    gdFwService.updateGdFwQlRedundantField(gdFwQl);
                }
            }
        }
    }

    /**
     * @author <a herf="mailto:xinghuajian@gtmap.cn">xinghuajian</a>
     * @description 同步gdtdql冗余字段Ywrzjh, Bdcdybh
     */
    private void synchronizationGdTdQlField(String gdProid, RedundantField redundantField) {
        if (StringUtils.isNotBlank(gdProid) && null != redundantField) {
            Example gdTdQlExample = new Example(GdTdQl.class);
            gdTdQlExample.createCriteria().andEqualTo("proid", gdProid);
            List<GdTdQl> gdTdQlList = entityMapper.selectByExample(gdTdQlExample);
            if (CollectionUtils.isNotEmpty(gdTdQlList)) {
                for (GdTdQl gdtdQl : gdTdQlList) {
                    gdtdQl.setYwrzjh(redundantField.getYwrzjh());
                    gdtdQl.setBdcdybh(redundantField.getBdcdybh());
                    gdTdService.updateGdTdQlRedundantField(gdtdQl);
                }
            }
        }
    }

    /**
     * @author <a herf="mailto:xinghuajian@gtmap.cn">xinghuajian</a>
     * @description 同步gdYg冗余字段qlr, qlrzjh，qlrzjzl，ywr，ywrzjzl，ycqzh，bdcdybh
     */
    private void synchronizationGdYgField(String gdProid, RedundantField redundantField) {
        if (StringUtils.isNotBlank(gdProid) && null != redundantField) {
            Example gdYgExample = new Example(GdYg.class);
            gdYgExample.createCriteria().andEqualTo("proid", gdProid);
            List<GdYg> gdYgList = entityMapper.selectByExample(gdYgExample);
            if (CollectionUtils.isNotEmpty(gdYgList)) {
                for (GdYg gdYg : gdYgList) {
                    gdYg.setQlr(redundantField.getQlr());
                    gdYg.setQlrzjh(redundantField.getYwrzjh());
                    gdYg.setQlrzjzl(redundantField.getQlrzjzl());
                    gdYg.setYwr(redundantField.getYwr());
                    gdYg.setYwrzjzl(redundantField.getYwrzjzl());
                    gdYg.setYcqzh(redundantField.getBdcqzmh());
                    gdYg.setYwrzjh(redundantField.getYwrzjh());
                    gdYg.setBdcdybh(redundantField.getBdcdybh());
                    gdYgService.updateGdYgRedundantField(gdYg);
                }
            }
        }
    }

    /**
     * @author <a herf="mailto:xinghuajian@gtmap.cn">xinghuajian</a>
     * @description 同步gdYy冗余字段Ywrzjh, zl等
     */
    private void synchronizationGdYyField(String gdProid, RedundantField redundantField) {
        if (StringUtils.isNotBlank(gdProid) && null != redundantField) {
            Example gdYyExample = new Example(GdYy.class);
            gdYyExample.createCriteria().andEqualTo("proid", gdProid);
            List<GdYy> gdYyList = entityMapper.selectByExample(gdYyExample);
            if (CollectionUtils.isNotEmpty(gdYyList)) {
                for (GdYy gdYy : gdYyList) {
                    gdYy.setYwr(redundantField.getYwr());
                    gdYy.setYwrzjzl(redundantField.getYwrzjzl());
                    gdYy.setYwrzjh(redundantField.getYwrzjh());
                    gdYy.setBdcdybh(redundantField.getBdcdybh());
                    gdYy.setYcqzh(redundantField.getBdcqzmh());
                    gdYy.setZl(redundantField.getZl());
                    gdYyService.updateGdYyRedundantField(gdYy);
                }
            }
        }
    }

    /**
     * @author <a herf="mailto:xinghuajian@gtmap.cn">xinghuajian</a>
     * @description 同步gdDy冗余字段Dyrzjh, Bdcdybh, zl, dyqr等
     */
    private void synchronizationGdDyField(String gdProid, RedundantField redundantField) {
        if (StringUtils.isNotBlank(gdProid) && null != redundantField) {
            Example gdDyExample = new Example(GdDy.class);
            gdDyExample.createCriteria().andEqualTo("proid", gdProid);
            List<GdDy> gdDyList = entityMapper.selectByExample(gdDyExample);
            if (CollectionUtils.isNotEmpty(gdDyList)) {
                for (GdDy gdDy : gdDyList) {
                    gdDy.setDyr(redundantField.getYwr());
                    gdDy.setDyrzjzl(redundantField.getYwrzjzl());
                    gdDy.setDyrzjh(redundantField.getYwrzjh());
                    gdDy.setDyqr(redundantField.getQlr());
                    gdDy.setDyqrzjzl(redundantField.getQlrzjzl());
                    gdDy.setDyqrzjh(redundantField.getQlrzjh());
                    gdDy.setYcqzh(redundantField.getBdcqzh());
                    gdDy.setBdcdybh(redundantField.getBdcdybh());
                    gdDy.setZl(redundantField.getZl());
                    gdDyService.updateGdDyRedundantField(gdDy);
                }
            }
        }
    }

    /**
     * @author <a herf="mailto:xinghuajian@gtmap.cn">xinghuajian</a>
     * @description 同步gdCf冗余字段Ywrzjh, Bdcdybh等
     */
    private void synchronizationGdCfField(String gdProid, RedundantField redundantField) {
        if (StringUtils.isNotBlank(gdProid) && null != redundantField) {
            Example gdCfExample = new Example(GdCf.class);
            gdCfExample.createCriteria().andEqualTo("proid", gdProid);
            List<GdCf> gdCfList = entityMapper.selectByExample(gdCfExample);
            if (CollectionUtils.isNotEmpty(gdCfList)) {
                for (GdCf gdcf : gdCfList) {
                    gdcf.setQlrzjzl(redundantField.getQlrzjzl());
                    gdcf.setQlrzjh(redundantField.getQlrzjh());
                    gdcf.setYwrzjh(redundantField.getYwrzjh());
                    gdcf.setYwrzjzl(redundantField.getYwrzjzl());
                    gdcf.setYcqzh(redundantField.getBdcqzh());
                    gdcf.setBdcdybh(redundantField.getBdcdybh());
                    gdcf.setZl(redundantField.getZl());
                    gdCfService.updateGdCfRedundantField(gdcf);
                }
            }
        }
    }

    /**
     * @author <a herf="mailto:xinghuajian@gtmap.cn">xinghuajian</a>
     * @description 同步gdqlr冗余字段cqzh, qzsxlh
     */
    private void synchronizationGdQlrField(String gdProid, RedundantField redundantField) {
        if (StringUtils.isNotBlank(gdProid) && null != redundantField) {
            List<GdQlr> gdQlrList = gdQlrService.getGdQlrListByqlidAndQlrlx(gdProid, "");
            Example tdsyqExample = new Example(GdTdsyq.class);
            tdsyqExample.createCriteria().andEqualTo("proid", gdProid);
            List<GdTdsyq> gdTdsyqList = entityMapper.selectByExample(tdsyqExample);
            List<GdFwsyq> gdFwsyqList = gdFwService.getGdFwsyqListByGdproid(gdProid, "");
            if (CollectionUtils.isNotEmpty(gdQlrList)) {
                for (GdQlr gdQlr : gdQlrList) {
                    if(CollectionUtils.isNotEmpty(gdFwsyqList)|| CollectionUtils.isNotEmpty(gdTdsyqList)) {
                        if(StringUtils.isNotBlank(gdQlr.getCqzh())) {
                            //针对产权分别持证情况
                            gdQlr.setCqzh(gdQlr.getCqzh());
                        }else {
                            gdQlr.setCqzh(redundantField.getBdcqzh());
                        }
                    }else{
                        gdQlr.setCqzh(redundantField.getBdcqzmh());
                    }
                    //Qzysxlh暂不处理
                    gdQlr.setQzysxlh("");
                    entityMapper.saveOrUpdate(gdQlr, gdQlr.getQlrid());
                }
            }
        }
    }


}
