package cn.gtmap.estateplat.config.service.impl.redundantfield;

import cn.gtmap.estateplat.config.core.service.BdcXmRelService;
import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.model.redundantfield.RedundantField;
import cn.gtmap.estateplat.config.service.redundantfield.BdcRedundantFieldService;
import cn.gtmap.estateplat.config.service.redundantfield.GdRedundantFieldService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXmRel;
import cn.gtmap.estateplat.service.config.RedundantFieldService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 2018/3/13
 * @description 不动产冗余字段
 */
@Service
public class RedundantFieldServiceImpl implements RedundantFieldService {
    @Autowired
    private BdcRedundantFieldService bdcRedundantFieldService;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private GdRedundantFieldService gdRedundantFieldService;
    @Autowired
    private BdcXmRelService bdcXmRelService;

    protected final Logger logger = LoggerFactory.getLogger(getClass());

    @Async
    @Override
    public void synchronizationBdcField(String proid) {
        try{
            BdcXm bdcXm = bdcXmService.getBdcXmByProid(proid);
            RedundantField redundantField = bdcRedundantFieldService.getBdcRedundantField(bdcXm);
            bdcRedundantFieldService.synchronizationBdcRedundantField(bdcXm,redundantField);

            List<BdcXmRel> bdcXmRelList = bdcXmRelService.getBdcXmRelByProid(proid);
            if(CollectionUtils.isNotEmpty(bdcXmRelList)) {
                for(BdcXmRel bdcXmRel:bdcXmRelList) {
                    if(StringUtils.equals(bdcXmRel.getYdjxmly(),Constants.XMLY_BDC)) {
                        BdcXm yBdcXm = bdcXmService.getBdcXmByProid(bdcXmRel.getYproid());
                        RedundantField yBdcXmRedundantField = bdcRedundantFieldService.getBdcRedundantField(yBdcXm);
                        bdcRedundantFieldService.synchronizationBdcRedundantField(yBdcXm,yBdcXmRedundantField);
                    }else{
                        synchronizationGdField(bdcXmRel.getYproid());
                    }
                }
            }
        }catch (Exception e){
            logger.error("RedundantFieldServiceImpl.synchronizationBdcField",e);
        }
    }

    @Async
    @Override
    public void synchronizationGdField(String gdproid) {
        if (StringUtils.isNotBlank(gdproid)) {
            RedundantField redundantField = gdRedundantFieldService.getGdRedundantField(gdproid);
            gdRedundantFieldService.synchronizationGdRedundantField(gdproid, redundantField);
        }
    }

}
