package cn.gtmap.estateplat.config.service.impl.redundantfield;

import cn.gtmap.estateplat.config.core.service.BdcXmRelService;
import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.model.redundantfield.RedundantField;
import cn.gtmap.estateplat.config.service.redundantfield.BdcRedundantFieldService;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXmRel;
import cn.gtmap.estateplat.service.config.RedundantMulFieldService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2020-05-15
 * @description 冗余字段服务接口
 */
@Service
public class RedundantMulFieldServiceImpl implements RedundantMulFieldService {
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcRedundantFieldService bdcRedundantFieldService;
    @Autowired
    private BdcXmRelService bdcXmRelService;
    protected final Logger logger = LoggerFactory.getLogger(getClass());

    /**
     * @param wiid
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 同步不动产库冗余字段信息(试用于江阴，无过度数据)
     */
    @Override
    public void synchronizationBdcField(String wiid) {
        try {
            List<BdcXm> bdcXmList = bdcXmService.getBdcXmListByWiid(wiid);
            if (CollectionUtils.isNotEmpty(bdcXmList)) {
                for (BdcXm bdcXm : bdcXmList) {
                    RedundantField redundantField = bdcRedundantFieldService.getBdcRedundantField(bdcXm);
                    bdcRedundantFieldService.synchronizationBdcRedundantField(bdcXm, redundantField);
                    List<BdcXmRel> bdcXmRelList = bdcXmRelService.getBdcXmRelByProid(bdcXm.getProid());
                    if (CollectionUtils.isNotEmpty(bdcXmRelList)) {
                        for (BdcXmRel bdcXmRel : bdcXmRelList) {
                            BdcXm yBdcXm = bdcXmService.getBdcXmByProid(bdcXmRel.getYproid());
                            RedundantField yBdcXmRedundantField = bdcRedundantFieldService.getBdcRedundantField(yBdcXm);
                            bdcRedundantFieldService.synchronizationBdcRedundantField(yBdcXm, yBdcXmRedundantField);
                        }
                    }
                }
            }
        } catch (Exception e) {
            logger.error("RedundantFieldServiceImpl.synchronizationBdcField", e);
        }
    }
}
