package cn.gtmap.estateplat.config.service.lpb.impl;

import cn.gtmap.estateplat.config.core.mapper.sjgl.FwHsMapper;
import cn.gtmap.estateplat.config.service.lpb.BdcLpbService;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
 * @version 1.0, 2017/12/15
 * @description 楼盘表服务
 */
@Service
public class BdcLpbServiceImpl implements BdcLpbService {

    private static final String LPB_LENGTH = "10";
    @Autowired
    private FwHsMapper fwHsMapper;

    @Override
    public Model layoutLpb(String ljzId, Model model) {
        if (StringUtils.isNotBlank(ljzId)) {
            //jyl  楼盘表长度默认每行展示10户
            String lpbLength = AppConfig.getProperty("lpb.length");
            if (StringUtils.isBlank(lpbLength)) {
                lpbLength = LPB_LENGTH;
            }
            //jyl 获取最大物理层数,然后再查询每层户室数，如果每层户室数没有超过lpbLength那么就以最大户室数做长
            //，如果超过最大lpbLength就以lpbLength为长，超出户室换行，maxWlcs增加。
            Integer maxWlcs = fwHsMapper.maxWlcs(ljzId);
            if (maxWlcs != null) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("ljzId", ljzId);
                param.put("lpbLength", lpbLength);
                List<Map> csAndHssList = fwHsMapper.listCsAndHss(param);
                if (CollectionUtils.isNotEmpty(csAndHssList)) {
                    Integer length = Integer.valueOf(lpbLength);
                    for (Map csAndHss : csAndHssList) {
                        if (csAndHss.get("HSS") != null) {
                            Integer hss=Integer.valueOf(csAndHss.get("HSS").toString());
                            Integer addCs=hss/length;
                            if(addCs!=null&&addCs>0){
                                 maxWlcs=maxWlcs+addCs;
                            }
                        }
                    }
                }
            }
            model.addAttribute("lzjid", ljzId);
            model.addAttribute("cellCount", lpbLength);
            model.addAttribute("rowCount", maxWlcs);
        }
        return model;
    }
}
