package cn.gtmap.estateplat.config.service.value;

import cn.gtmap.estateplat.config.service.BdcJtcyService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcJtcy;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
@Repository
public class BdcJtcyServiceImpl implements BdcJtcyService{
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    Repo repository;

    @Override
    public Page<HashMap> getBdcJtcy(Map map, Pageable pageable){
        return repository.selectPaging("getBdcJtcyByPage", map,  pageable);
    }

    @Override
    public void deleteBdcJtcy( String ids){
        if (ids.contains(",")) {
            for (String id : ids.split(",")){
                entityMapper.deleteByPrimaryKey(BdcJtcy.class, id);
            }
        } else {
            entityMapper.deleteByPrimaryKey(BdcJtcy.class, ids);
        }
    }


    @Override
    public String valiteBdcJtcy (BdcJtcy bdcJtcy) {
        String msg = "2";
        List<BdcJtcy> sqrList = entityMapper.select(new BdcJtcy());
        for (BdcJtcy bdcJtcy1:sqrList){
            if (StringUtils.equals(bdcJtcy1.getJtcyid(), bdcJtcy.getJtcyid())) {
                msg = "3";
                break;
            }
        }
        return msg;
    }

    @Override
    public void saveBdcJtcy (BdcJtcy bdcJtcy, String jtcyid){
        entityMapper.saveOrUpdate(bdcJtcy, bdcJtcy.getJtcyid());
    }
}
