package cn.gtmap.estateplat.config.service.value;

import cn.gtmap.estateplat.config.service.BdcSqrService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcSqr;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Pageable;

@Repository
public class BdcSqrServiceImpl implements BdcSqrService{
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    Repo repository;

    @Override
    public void deleteBdcSqr( String ids){
        if (ids.contains(",")) {
            for (String id : ids.split(",")){
                entityMapper.deleteByPrimaryKey(BdcSqr.class, id);
            }
        } else {
            entityMapper.deleteByPrimaryKey(BdcSqr.class, ids);
        }
    }
    @Override
    public Page<HashMap> getBdcSqr(Map map, Pageable pageable){
        return repository.selectPaging("getBdcSqrByPage", map,  pageable);
    }

    @Override
    public void saveBdcSqr (BdcSqr bdcSqr, String sqrid){
        entityMapper.saveOrUpdate(bdcSqr, bdcSqr.getSqrid());
    }

    @Override
    public List<BdcSqr> selectBdcSqr() {
        return entityMapper.select(new BdcSqr());
    }
    
    @Override
    public String valiteBdcSqr (BdcSqr bdcSqr) {
        String msg = "2";
        List<BdcSqr> sqrList = entityMapper.select(new BdcSqr());
        for (BdcSqr bdcSqr1:sqrList){
            if (StringUtils.equals(bdcSqr1.getSqrid(), bdcSqr.getSqrid())) {
                msg = "3";
                break;
            }
        }
        return msg;
    }
}
