package cn.gtmap.estateplat.config.service.ztxx;

import cn.gtmap.estateplat.model.server.core.BdcGdDyhRel;
import cn.gtmap.estateplat.model.server.core.GdTd;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
 * @version 1.0  2018-06-01.
 * @description 根据不动产单元查询BDC、GD权利相关服务
 */
public interface BdcCxBdcdyQlxxService {

    /**
     * 根据BDCDYH 截取 DJH 查询 GD_TD
     * @param changeNew true 重新查询一下新DJH（原有逻辑） 东北地区没有此逻辑
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    GdTd queryGdTdByBdcdyh(String bdcdyh,boolean changeNew);

    /**
     * 东北地区 特殊版本  暂不处理 土地证权利绑定房屋的逻辑
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    void dealGdTdidsBdclxTdfw(String tdid,List<String> bdcdyhList,List<String> tdisList);

    /**
     * 根据BDCDYH 查询 GD_DYH_REL
     * 由于GD_DYH_REL表的地区差异，所以独立这个查询方法
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    List<BdcGdDyhRel> listGdDyhRelByDyh(final String bdcdyh);

    /**
     * 根据GDID查询GD_DYH_REL
     * 由于GD_DYH_REL表的地区差异，所以独立这个查询方法
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    List<BdcGdDyhRel> getGdDyhRelListByGdid(final String gdid);

    /**
     * 循环处理 MAP中的 权利数量，相加
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    void countByMap(Map<String,Integer> fromMap, Map<String,Integer> toMap);

    /**
     * 创建一个空的Map,MAP中初始各种权利数量为0
     * @param isGd 过度数据部分权利不需要计算，所以初始化时区分是否是用于处理过度数据
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    Map<String,Integer> createEmptyQlMap(boolean isGd);

    /**
     * 根据fwidList或tdidList查找过渡库各现势权利
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    Map queryGdQlByBdcid(List<String> bdcidList);

    /**
     * 根据获取的不动产单元号得到与之相关的所有不动产权利
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    Map<String,Integer> queryBdcQlByBdcdyh(List<String> bdcdyhList);

    /**
     * 更新BDCDY ZT
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    void updateBdcdyZt(Map map);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param: * @param bdcdyh
     * @Description:根据不动产单元号获取有效的不动产产权证
     * @Date 9:43 2017/12/21
     */
    List<Map> getFwSyqByBdcdyh(String bdcdyh);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param: bdcdyh
     * @Description:通过不动产单元号获取过渡房产证号
     * @Date 11:18 2017/12/21
     */
    List<Map> getGdFwSyqByBdcdyh(String bdcdyh);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param: * @param bdcdyh
     * @Description:根据不动产单元号获取有效的不动产土地产权证
     * @Date 9:43 2017/12/21
     */
    List<Map> getTdSyqByBdcdyh(String bdcdyh);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param: * @param bdcdyh
     * @Description:根据不动产单元号获取有效的过渡土地产权证
     * @Date 9:43 2017/12/21
     */
    List<Map> getGdTdSyqByBdcdyh(String bdcdyh);

    /**
     * 根据BDCDYH查BDC权利  或者 根据BDCID查询GD权利，计算权利数量，保存进qlslMap
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    void putQlslMap(String bdcdyh,String bdcid,Map<String,Integer> qlslMap);
}