package cn.gtmap.estateplat.config.service.ztxx;

import cn.gtmap.estateplat.config.core.model.IdModel;
import cn.gtmap.estateplat.model.config.BdcCxBdcdyZt;

import java.util.List;
import java.util.Map;

/*
 * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
 * @version 1.0, 2017/11/21
 * @description  不动产单元权利状态服务
 */
public interface BdcCxBdcdyZtService {

    /**
     * @param ztid 状态id（主键）
     * @return BdcCxBdcdyZt 实体对象
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @version
     * @description 根据ztid（主键）获取BdcCxBdcdyZt 实体对象
     */
    BdcCxBdcdyZt getBdcdyZtByZtid(String ztid);

    /**
     * @param bdcdyh 不动产单元号
     * @return BdcCxBdcdyZt实体对象
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @version
     * @description 根据不动产单元号获取BdcCxBdcdyZt 实体对象
     */
    BdcCxBdcdyZt getBdcdyZtByBdcdyh(String bdcdyh);

    /**
     * @param bdcdybh 不动产单元编号
     * @return BdcCxBdcdyZt 实体对象
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @version
     * @description 根据不动产单元编号获取BdcCxBdcdyZt 实体对象
     */
    BdcCxBdcdyZt getBdcdyZtByBdcdybh(String bdcdybh);

    /**
     * @param bdcdyh  不动产单元号
     * @param bdcdybh 不动产单元编号
     * @return msg:success或者failed
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @version
     * @description 为新的不动产单元号初始化不动产单元权利状态
     */
    String initBdcCxBdcdyZt(String bdcdyh, String bdcdybh);

    /**
     * @param bdcdyh  不动产单元号
     * @param bdcdybh 不动产单元编号
     * @return msg:success或者failed
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @version
     * @description 当不动产单元状态发生变化时需要设置不动产单元状态
     */
    String setBdcdyZt(String bdcdyh, String bdcdybh);

    /**
     * @param bdcdyh  不动产单元号
     * @param bdcdybh 不动产单元编号
     * @return msg:success或者failed
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @version
     * @description 当进行变更撤销时，需要根据撤销前的不动产单元号删除表中的记录，并将记录当前的操作日志
     */
    String delBdcCxBdcdyZt(String bdcdyh, String bdcdybh);

    /**
     * @param bdcdyh  不动产单元号
     * @param bdcdybh 不动产单元编号
     * @return msg:success或者failed或者其他错误信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @version
     * @description 当不动产单元登记状态发生变化时需要设置不动产单元登记状态
     */
    String setBdcdyDjzt(String bdcdyh, String bdcdybh);

    /**
     * @param bdcdyh  不动产单元号
     * @param bdcdybh 不动产单元编号
     * @return msg:success或者failed或者其他错误信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @version
     * @description 统一由登记业务时登簿后进行修改需要设置不动产单元登记状态
     */
    String setBdcdyQlzt(String bdcdyh, String bdcdybh);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:
     * @Description:查询不动产单元状态表
     * @Date 16:28 2017/11/22
     */
    List<BdcCxBdcdyZt> getBdcCxBdcdyZtList(Map map);


    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param:bdcdyh 不动产单元号
     * @param:bdclx 不动产类型
     * @Description:为不动产单元的权利状态设计，根据不动产单元号找到对应的房屋和土地，房屋和土地的过渡权利和不动产单元的不动产权利的集合就是该不动产单元所有权利
     * @Date 15:46 2017/11/23
     */
    IdModel getXgIdModelForBdcdy(String bdcdyh, String bdclx);


    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param:fwid 房屋id
     * @Description:获取所有相关不动产单元号 不动产数据都是一一对应, 但需要考虑以现在附属设施的设计不需要考虑
     * 主要是过渡数据需要考虑房屋和房屋所在的土地的物理场景，
     * 以及一证多房，项目内多幢等业务场景延伸出来的相关联不动产单元号
     * 先由一个不动产单元号，找到他相关联的不动产单元号(为产权）
     * @Date 15:46 2017/11/23
     */
    IdModel getXgIdModelByFwidForSyq(String fwid);

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param:tdid 土地id
     * @Description:获取所有相关不动产单元号 不动产数据都是一一对应, 但需要考虑以现在附属设施的设计不需要考虑
     * 主要是过渡数据需要考虑房屋和房屋所在的土地的物理场景，
     * 以及一证多房，项目内多幢等业务场景延伸出来的相关联不动产单元号
     * 先由一个不动产单元号，找到他相关联的不动产单元号(为产权）
     * @Date 15:46 2017/11/23
     */
    IdModel getXgIdModelByTdidForSyq(String tdid);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param: * @param null
     * @Description:根据不动产类型获取bdccxbdcdyzt表中的不动产单元号
     * @Date 17:24 2017/12/6
     */
    List<String> getBdcdyh(Map map);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:bdclx
     * @Description:获取该不动产类型的数据量
     * @Date 10:37 2018/1/12
     */
    Integer getBdcdyhCount(String bdclx);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param: * @param null
     * @Description:根据bdcdyh转相应数据
     * @Date 17:33 2017/12/6
     */
    String updateBdcdyZtByBdcdyh(List<String> bdcdyhList, String bdclx);

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param: * idModel
     * @Description:根据bdcdyh转相应数据
     * @Date 15:33 2017/12/7
     */
    Map queryQLsl(IdModel idModel);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:bdcdyh、ks、ys
     * @Description:更新可售、预售状态
     * @Date 10:55 2018/5/3
     */
    String updateKsYsByBdcdyh(String bdcdyh, Integer ks, Integer ys);

    /**
     * @param bdcdyhList 不动产单元号集合
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 更新锁定状态
     */
    String updateSdByBdcdyh(List<String> bdcdyhList, Integer o);

    /**
     *@author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     *@param
     *@description 更新备案状态
     */
    String updateSfbaByBdcdyh(String bdcdyh, String sfba);
}
